/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.svggen.font.table;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.RandomAccessFile;
import org.apache.batik.svggen.font.table.DirectoryEntry;
import org.apache.batik.svggen.font.table.GlyfCompositeDescript;
import org.apache.batik.svggen.font.table.GlyfDescript;
import org.apache.batik.svggen.font.table.GlyfSimpleDescript;
import org.apache.batik.svggen.font.table.LocaTable;
import org.apache.batik.svggen.font.table.Table;

public class GlyfTable
implements Table {
    private byte[] buf = null;
    private GlyfDescript[] descript;

    protected GlyfTable(DirectoryEntry de, RandomAccessFile raf) throws IOException {
        raf.seek(de.getOffset());
        this.buf = new byte[de.getLength()];
        raf.read(this.buf);
    }

    public void init(int numGlyphs, LocaTable loca) {
        if (this.buf == null) {
            return;
        }
        this.descript = new GlyfDescript[numGlyphs];
        ByteArrayInputStream bais = new ByteArrayInputStream(this.buf);
        int i = 0;
        while (i < numGlyphs) {
            int len = loca.getOffset((short)(i + 1)) - loca.getOffset(i);
            if (len > 0) {
                bais.reset();
                bais.skip(loca.getOffset(i));
                short numberOfContours = (short)(bais.read() << 8 | bais.read());
                if (numberOfContours >= 0) {
                    this.descript[i] = new GlyfSimpleDescript(this, numberOfContours, bais);
                }
            } else {
                this.descript[i] = null;
            }
            ++i;
        }
        int i2 = 0;
        while (i2 < numGlyphs) {
            int len = loca.getOffset((short)(i2 + 1)) - loca.getOffset(i2);
            if (len > 0) {
                bais.reset();
                bais.skip(loca.getOffset(i2));
                short numberOfContours = (short)(bais.read() << 8 | bais.read());
                if (numberOfContours < 0) {
                    this.descript[i2] = new GlyfCompositeDescript(this, bais);
                }
            }
            ++i2;
        }
        this.buf = null;
    }

    public GlyfDescript getDescription(int i) {
        return this.descript[i];
    }

    public int getType() {
        return 1735162214;
    }
}

