/*
 * Decompiled with CFR 0.152.
 */
package com.install4j.runtime.beans.actions.files;

import com.install4j.api.context.Context;
import com.install4j.api.context.InstallerContext;
import com.install4j.api.context.UserCanceledException;
import com.install4j.api.unix.UnixFileSystem;
import com.install4j.runtime.beans.actions.SystemInstallOrUninstallAction;
import com.install4j.runtime.beans.actions.files.BackupFileForRollbackAction;
import com.install4j.runtime.installer.helper.InstallerUtil;
import com.install4j.runtime.installer.helper.fileinst.FileInstaller;
import java.io.File;

public class CreateSymlinkAction
extends SystemInstallOrUninstallAction {
    private File file;
    private File linkFile;
    private boolean removeOnUninstall = true;

    public File getFile() {
        return CreateSymlinkAction.replaceVariables(this.file);
    }

    public void setFile(File file) {
        this.file = file;
    }

    public File getLinkFile() {
        return CreateSymlinkAction.replaceVariables(this.linkFile);
    }

    public void setLinkFile(File linkFile) {
        this.linkFile = linkFile;
    }

    public boolean isRemoveOnUninstall() {
        return this.removeOnUninstall;
    }

    public void setRemoveOnUninstall(boolean removeOnUninstall) {
        this.removeOnUninstall = removeOnUninstall;
    }

    @Override
    public boolean execute(Context context) throws UserCanceledException {
        if (InstallerUtil.isWindows()) {
            return true;
        }
        File usedFile = context.getDestinationFile(this.getFile());
        if (usedFile == null || !usedFile.exists()) {
            return false;
        }
        File usedLinkFile = context.getDestinationFile(this.getLinkFile());
        if (usedLinkFile == null) {
            return false;
        }
        if (context instanceof InstallerContext) {
            BackupFileForRollbackAction backupAction = new BackupFileForRollbackAction(usedLinkFile, true, true);
            backupAction.install((InstallerContext)context);
            this.addRollbackAction(backupAction);
        }
        if (this.removeOnUninstall) {
            FileInstaller.getInstance().registerUninstallFile(usedLinkFile);
        }
        return UnixFileSystem.createLink(usedFile.getAbsolutePath(), usedLinkFile);
    }
}

