/*
 * Decompiled with CFR 0.152.
 */
package com.install4j.runtime.beans.formcomponents;

import com.install4j.api.formcomponents.AbstractFormComponent;
import com.install4j.api.formcomponents.FormComponent;
import com.install4j.api.formcomponents.FormEnvironment;
import com.install4j.api.formcomponents.LayoutGroup;
import com.install4j.runtime.beans.formcomponents.CoupledComponentsHolder;
import java.util.ListIterator;
import java.util.Map;

public class CoupledComponentsUtil {
    public static void migrateCoupledIds(CoupledComponentsHolder couplesComponentsHolder, Map<String, String> oldItToNewId) {
        ListIterator<String> it = couplesComponentsHolder.getCoupledComponentIds().listIterator();
        while (it.hasNext()) {
            String oldId = it.next();
            String newId = oldItToNewId.get(oldId);
            if (newId == null) {
                it.remove();
                continue;
            }
            it.set(newId);
        }
    }

    public static void enableCoupledComponents(CoupledComponentsHolder coupledComponentsHolder) {
        Boolean enabled = coupledComponentsHolder.isEnableCoupledComponents();
        if (enabled == null) {
            return;
        }
        if (!coupledComponentsHolder.isEnabled()) {
            enabled = Boolean.FALSE;
        } else if (coupledComponentsHolder.isInverseCoupling()) {
            enabled = enabled != false ? Boolean.FALSE : Boolean.TRUE;
        }
        for (String id : coupledComponentsHolder.getCoupledComponentIds()) {
            FormEnvironment formEnvironment = ((AbstractFormComponent)((Object)coupledComponentsHolder)).getFormEnvironment();
            FormComponent formComponent = formEnvironment.getFormComponentById(id);
            if (formComponent != null) {
                formComponent.setEnabled(enabled);
                continue;
            }
            LayoutGroup layoutGroup = formEnvironment.getLayoutGroupById(id);
            if (layoutGroup == null) continue;
            layoutGroup.setEnabled(enabled);
        }
    }
}

