/*
 * Decompiled with CFR 0.152.
 */
package com.install4j.runtime.beans.formcomponents;

import com.install4j.api.Util;
import com.install4j.api.context.Context;
import com.install4j.api.screens.Screen;
import com.install4j.runtime.beans.actions.InstallFilesAction;
import com.install4j.runtime.beans.actions.desktop.CreateFileAssociationAction;
import com.install4j.runtime.beans.formcomponents.ChecklistComponent;
import com.install4j.runtime.beans.formcomponents.VerticalDockingPosition;
import com.install4j.runtime.installer.ContextImpl;
import com.install4j.runtime.installer.ContextInt;
import com.install4j.runtime.installer.frontend.GUIHelper;
import com.install4j.runtime.installer.frontend.Messages;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JPanel;

public class FileAssociationsComponent
extends ChecklistComponent<SingleAssociationPanel> {
    public static final String VARIABLE_EXTENSIONS = "sys.fileAssociation.extensions";
    public static final String VARIABLE_LAUNCHERS = "sys.fileAssociation.launchers";
    private boolean showSelectionButtons = false;
    private VerticalDockingPosition selectionButtonPosition = VerticalDockingPosition.BOTTOM;

    public boolean isShowSelectionButtons() {
        return this.showSelectionButtons;
    }

    public void setShowSelectionButtons(boolean showSelectionButtons) {
        this.showSelectionButtons = showSelectionButtons;
    }

    public VerticalDockingPosition getSelectionButtonPosition() {
        return this.selectionButtonPosition;
    }

    public void setSelectionButtonPosition(VerticalDockingPosition selectionButtonPosition) {
        this.selectionButtonPosition = selectionButtonPosition;
    }

    @Override
    protected void save() {
        super.save();
        ArrayList<String> extensions = new ArrayList<String>();
        ArrayList<String> launchers = new ArrayList<String>();
        for (SingleAssociationPanel singleAssociationPanel : this.getSingleCheckPanels()) {
            CreateFileAssociationAction associationAction = singleAssociationPanel.getAssociationAction();
            if (!associationAction.isSelected()) continue;
            extensions.add(associationAction.getExtension());
            launchers.add(associationAction.getLauncherId());
        }
        this.getContext().setVariable(VARIABLE_EXTENSIONS, extensions.toArray(new String[0]));
        this.getContext().registerResponseFileVariable(VARIABLE_EXTENSIONS);
        this.getContext().setVariable(VARIABLE_LAUNCHERS, launchers.toArray(new String[0]));
        this.getContext().registerResponseFileVariable(VARIABLE_LAUNCHERS);
    }

    private boolean isAssociationSelected(String extension, String launcherId, boolean defaultValue) {
        String[] arrayLauncher;
        String[] arrayExtensions;
        Object varExtensions = this.getContext().getVariable(VARIABLE_EXTENSIONS);
        Object varLaunchers = this.getContext().getVariable(VARIABLE_LAUNCHERS);
        if (varExtensions instanceof String[] && varLaunchers instanceof String[] && (arrayExtensions = (String[])varExtensions).length == (arrayLauncher = (String[])varLaunchers).length) {
            for (int i = 0; i < arrayLauncher.length; ++i) {
                if (!Objects.equals(arrayLauncher[i], launcherId) || !Objects.equals(arrayExtensions[i], extension)) continue;
                return true;
            }
            return false;
        }
        return defaultValue;
    }

    @Override
    protected void addSingleChecks(JPanel checklistPanel, GridBagConstraints gc) {
        gc.insets.bottom = 3;
        List<CreateFileAssociationAction> associationActions = this.getCreateFileAssociationActions();
        for (CreateFileAssociationAction associationAction : associationActions) {
            SingleAssociationPanel singleAssociationPanel = new SingleAssociationPanel(associationAction);
            this.getSingleCheckPanels().add(singleAssociationPanel);
            gc.insets.bottom = 0;
            gc.insets.top = 3;
            checklistPanel.add((Component)singleAssociationPanel, gc);
            ++gc.gridy;
        }
    }

    private List<CreateFileAssociationAction> getCreateFileAssociationActions() {
        if (this.getFormEnvironment().isDesignTime()) {
            return Arrays.asList(this.createDesignTimeFileAssociationAction(1), this.createDesignTimeFileAssociationAction(2), this.createDesignTimeFileAssociationAction(3), this.createDesignTimeFileAssociationAction(2), this.createDesignTimeFileAssociationAction(3), this.createDesignTimeFileAssociationAction(2), this.createDesignTimeFileAssociationAction(3), this.createDesignTimeFileAssociationAction(2), this.createDesignTimeFileAssociationAction(3));
        }
        return FileAssociationsComponent.findAssociationActions(this.getContext(), this.getFormEnvironment().getScreen());
    }

    private CreateFileAssociationAction createDesignTimeFileAssociationAction(int index) {
        CreateFileAssociationAction action = new CreateFileAssociationAction();
        action.setDescription("File association " + index);
        action.setExtension("ext" + index);
        return action;
    }

    public static List<CreateFileAssociationAction> findAssociationActions(Context context, Screen screen) {
        ContextInt contextInt = ContextImpl.getContextInt(context);
        boolean installFilesFollows = contextInt.getExecutableActionsStartingFrom(InstallFilesAction.class, screen).size() > 0;
        ArrayList<CreateFileAssociationAction> usedActions = new ArrayList<CreateFileAssociationAction>();
        List<CreateFileAssociationAction> executableActions = contextInt.getExecutableActionsStartingFrom(CreateFileAssociationAction.class, screen);
        for (CreateFileAssociationAction action : executableActions) {
            if (!installFilesFollows && !action.fileExists(context)) continue;
            if (Util.isWindowsInstaller() && action.isWindows()) {
                usedActions.add(action);
                continue;
            }
            if (!Util.isMacosInstaller() || !action.isMac()) continue;
            usedActions.add(action);
        }
        return usedActions;
    }

    @Override
    protected void buildPanel(JPanel panel, GridBagConstraints gc) {
        if (this.showSelectionButtons && this.selectionButtonPosition == VerticalDockingPosition.TOP) {
            this.addSelectionButtons(panel, gc);
        }
        super.buildPanel(panel, gc);
        if (this.showSelectionButtons && this.selectionButtonPosition == VerticalDockingPosition.BOTTOM) {
            this.addSelectionButtons(panel, gc);
        }
    }

    private void addSelectionButtons(JPanel panel, GridBagConstraints gc) {
        Box box = new Box(2);
        JButton selectAllButton = GUIHelper.adjustButton(new JButton(Messages.getMessages().getString("SelectAll")));
        selectAllButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                FileAssociationsComponent.this.selectAllCheckboxes(true);
            }
        });
        box.add(selectAllButton);
        box.add(Box.createHorizontalStrut(5));
        JButton unselectAllButton = GUIHelper.adjustButton(new JButton(Messages.getMessages().getString("SelectNone")));
        unselectAllButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                FileAssociationsComponent.this.selectAllCheckboxes(false);
            }
        });
        box.add(unselectAllButton);
        gc.weighty = 0.0;
        gc.fill = 0;
        panel.add((Component)box, gc);
        ++gc.gridy;
    }

    private void selectAllCheckboxes(boolean select) {
        for (SingleAssociationPanel panel : this.getSingleCheckPanels()) {
            panel.chkSingle.setSelected(select);
        }
    }

    protected class SingleAssociationPanel
    extends ChecklistComponent.SingleCheckPanel {
        private CreateFileAssociationAction associationAction;

        public SingleAssociationPanel(CreateFileAssociationAction associationAction) {
            super(FileAssociationsComponent.this);
            this.associationAction = associationAction;
            this.setLayout(new BorderLayout());
            this.chkSingle = new JCheckBox(associationAction.getDescription() + " (*." + associationAction.getExtension() + ")", FileAssociationsComponent.this.isAssociationSelected(associationAction.getExtension(), associationAction.getLauncherId(), associationAction.isSelected()));
            this.add((Component)this.chkSingle, "Before");
        }

        @Override
        public void save() {
            this.associationAction.setSelected(this.chkSingle.isSelected());
        }

        public CreateFileAssociationAction getAssociationAction() {
            return this.associationAction;
        }
    }
}

