/*
 * Decompiled with CFR 0.152.
 */
package com.install4j.runtime.beans.formcomponents;

import com.install4j.api.Util;
import com.install4j.api.beans.ScriptProperty;
import com.install4j.api.context.UserCanceledException;
import com.install4j.api.formcomponents.FormEnvironment;
import com.install4j.api.screens.Console;
import com.install4j.runtime.beans.formcomponents.AxisType;
import com.install4j.runtime.beans.formcomponents.LeadingLabelComponent;
import com.install4j.runtime.installer.helper.Logger;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.Enumeration;
import javax.swing.AbstractButton;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JRadioButton;

public class RadiobuttonsComponent
extends LeadingLabelComponent {
    private String variableName = "";
    private String[] radioButtonLabels;
    private int initiallySelectedIndex;
    private AxisType axisType = AxisType.VERTICAL;
    private ButtonGroup buttonGroup;
    private JRadioButton[] radioButtons;
    private ScriptProperty selectionScript;

    public String getVariableName() {
        return this.variableName;
    }

    public void setVariableName(String variableName) {
        this.variableName = variableName;
    }

    public String[] getRadioButtonLabels() {
        return this.replaceFormVariables(this.radioButtonLabels);
    }

    public void setRadioButtonLabels(String[] radioButtonLabels) {
        this.radioButtonLabels = radioButtonLabels;
    }

    public int getInitiallySelectedIndex() {
        return this.initiallySelectedIndex;
    }

    public void setInitiallySelectedIndex(int initiallySelectedIndex) {
        this.initiallySelectedIndex = initiallySelectedIndex;
    }

    public AxisType getAxisType() {
        return this.axisType;
    }

    public void setAxisType(AxisType axisType) {
        this.axisType = axisType;
    }

    public ScriptProperty getSelectionScript() {
        return this.selectionScript;
    }

    public void setSelectionScript(ScriptProperty selectionScript) {
        this.selectionScript = selectionScript;
    }

    @Override
    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        Enumeration<AbstractButton> elements = this.buttonGroup.getElements();
        while (elements.hasMoreElements()) {
            ((JRadioButton)elements.nextElement()).setEnabled(enabled);
        }
    }

    @Override
    public void initialize() {
        super.initialize();
        int initIndex = (Integer)this.getInitValue(this.getInitiallySelectedIndex(), this.getVariableName(), Integer.class);
        for (int i = 0; i < this.radioButtons.length; ++i) {
            JRadioButton radioButton = this.radioButtons[i];
            if (i != 0 && i != initIndex) continue;
            radioButton.setSelected(true);
        }
    }

    @Override
    public void setFormEnvironment(FormEnvironment formEnvironment) {
        super.setFormEnvironment(formEnvironment);
        if (this.radioButtons != null && this.radioButtons.length > 0 && formEnvironment != null) {
            this.radioButtons[0].getParent().setName(formEnvironment.getId(this));
        }
    }

    @Override
    public JComponent createCenterComponent() {
        this.buttonGroup = new ButtonGroup();
        String[] radioButtonLabels = this.getRadioButtonLabels();
        this.radioButtons = new JRadioButton[radioButtonLabels.length];
        RadioButtonPanelPanel panel = new RadioButtonPanelPanel(this.buttonGroup);
        panel.setName(this.getFormEnvironment().getId(this));
        int axis = this.axisType == AxisType.HORIZONTAL ? 0 : 1;
        panel.setLayout(new BoxLayout(panel, axis));
        panel.setAlignmentX(0.0f);
        for (int i = 0; i < radioButtonLabels.length; ++i) {
            JRadioButton radioButton = new JRadioButton(radioButtonLabels[i]);
            final int selectedIndex = i;
            radioButton.addItemListener(new ItemListener(){

                @Override
                public void itemStateChanged(ItemEvent e) {
                    if (RadiobuttonsComponent.this.getFormEnvironment().isInitialized() && e.getStateChange() == 1) {
                        RadiobuttonsComponent.this.executeSelectionScript(selectedIndex);
                    }
                }
            });
            this.buttonGroup.add(radioButton);
            if (i == 0) {
                radioButton.setSelected(true);
            }
            radioButton.setActionCommand(String.valueOf(i));
            radioButton.setAlignmentX(0.0f);
            panel.add(radioButton);
            this.radioButtons[i] = radioButton;
        }
        return panel;
    }

    @Override
    public boolean isFillCenterHorizontal() {
        return false;
    }

    @Override
    public Object getConfigurationObject() {
        return this.buttonGroup;
    }

    @Override
    public Class getConfigurationObjectClass() {
        return ButtonGroup.class;
    }

    @Override
    public boolean checkCompleted() {
        this.getContext().setVariable(this.getVariableName(), new Integer(this.buttonGroup.getSelection().getActionCommand()));
        this.getContext().registerResponseFileVariable(this.getVariableName());
        return true;
    }

    @Override
    public boolean handleConsole(Console console) throws UserCanceledException {
        String[] descriptions = new String[this.buttonGroup.getButtonCount()];
        JRadioButton[] buttons = new JRadioButton[this.buttonGroup.getButtonCount()];
        int i = 0;
        Enumeration<AbstractButton> elements = this.buttonGroup.getElements();
        while (elements.hasMoreElements()) {
            JRadioButton radioButton;
            buttons[i] = radioButton = (JRadioButton)elements.nextElement();
            descriptions[i++] = radioButton.getText();
        }
        int newValue = console.askOption(this.getConsoleLabelText(false), descriptions, null, Integer.parseInt(this.buttonGroup.getSelection().getActionCommand()));
        buttons[newValue].setSelected(true);
        this.executeSelectionScript(newValue);
        return true;
    }

    private void executeSelectionScript(int selectedIndex) {
        try {
            this.getContext().runScript(this.selectionScript, this, this.getFormEnvironment(), selectedIndex);
        }
        catch (Exception e) {
            Util.printAnnotatedStackTrace(e);
            Logger.getInstance().log(e);
        }
    }

    private static class RadioButtonPanelPanel
    extends JPanel {
        private ButtonGroup buttonGroup;

        public RadioButtonPanelPanel(ButtonGroup buttonGroup) {
            this.buttonGroup = buttonGroup;
        }

        @Override
        public void setOpaque(boolean opaque) {
            super.setOpaque(opaque);
            if (this.buttonGroup != null) {
                Enumeration<AbstractButton> elements = this.buttonGroup.getElements();
                while (elements.hasMoreElements()) {
                    ((JRadioButton)elements.nextElement()).setOpaque(opaque);
                }
            }
        }
    }
}

