/*
 * Decompiled with CFR 0.152.
 */
package com.install4j.runtime.installer.config;

import com.install4j.runtime.installer.config.AbstractBeanConfig;
import com.install4j.runtime.installer.config.FormComponentBeanConfig;
import com.install4j.runtime.installer.config.GroupBeanConfig;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.w3c.dom.Element;

public abstract class FormComponentContainerBeanConfig
extends AbstractBeanConfig {
    private List<AbstractBeanConfig> formComponentConfigs;

    public List<AbstractBeanConfig> getFormComponentConfigs() {
        return this.formComponentConfigs;
    }

    @Override
    protected void read(Element element) {
        super.read(element);
        this.readFormComponentConfigs(element);
    }

    private void readFormComponentConfigs(Element element) {
        LinkedList<FormComponentBeanConfig> formComponentConfigs = new LinkedList<FormComponentBeanConfig>();
        Element formComponentsElement = FormComponentContainerBeanConfig.findChild(element, "formComponents");
        if (formComponentsElement == null) {
            return;
        }
        for (Element beanElement : FormComponentContainerBeanConfig.childElements(formComponentsElement)) {
            AbstractBeanConfig beanConfig;
            String beanElementName = beanElement.getTagName();
            if (beanElementName.equalsIgnoreCase("formComponent")) {
                beanConfig = new FormComponentBeanConfig();
            } else if (beanElementName.equalsIgnoreCase("group")) {
                beanConfig = new GroupBeanConfig(false);
            } else {
                return;
            }
            ((AbstractBeanConfig)beanConfig).read(beanElement);
            formComponentConfigs.add((FormComponentBeanConfig)beanConfig);
        }
        this.formComponentConfigs = Collections.unmodifiableList(formComponentConfigs);
    }

    @Override
    public void addAllTo(Map<String, AbstractBeanConfig> id2BeanConfig) {
        super.addAllTo(id2BeanConfig);
        if (this.formComponentConfigs != null) {
            for (AbstractBeanConfig formComponentConfig : this.formComponentConfigs) {
                formComponentConfig.addAllTo(id2BeanConfig);
            }
        }
    }

    @Override
    public FormComponentContainerBeanConfig clone() {
        FormComponentContainerBeanConfig clone = (FormComponentContainerBeanConfig)super.clone();
        clone.formComponentConfigs = new ArrayList<AbstractBeanConfig>();
        for (AbstractBeanConfig formComponentConfig : this.formComponentConfigs) {
            clone.formComponentConfigs.add(formComponentConfig.clone());
        }
        return clone;
    }
}

