/*
 * Decompiled with CFR 0.152.
 */
package com.install4j.runtime.installer.helper.content;

import com.install4j.api.context.Context;
import com.install4j.runtime.installer.config.ComponentConfig;
import com.install4j.runtime.installer.config.InstallerConfig;
import com.install4j.runtime.installer.helper.InstallerUtil;
import com.install4j.runtime.installer.helper.comm.ExecutionContext;
import com.install4j.runtime.installer.helper.comm.HelperCommunication;
import com.install4j.runtime.installer.helper.comm.actions.FetchObjectAction;
import com.install4j.runtime.installer.helper.comm.actions.RunAction;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Objects;
import java.util.Properties;
import java.util.Set;
import java.util.StringTokenizer;

class ContentStats {
    private static ContentStats instance;
    private Properties stats = new Properties();

    public static ContentStats getInstance() throws IOException {
        if (instance == null) {
            if (HelperCommunication.getInstance().isElevatedHelper()) {
                HelperCommunication.getInstance().executeAction(ExecutionContext.UNELEVATED, new RunAction(){

                    @Override
                    protected void run(Context context) throws Exception {
                        ContentStats.getInstance();
                    }
                });
            }
            instance = new ContentStats();
        }
        return instance;
    }

    private ContentStats() throws IOException {
        FileInputStream in = new FileInputStream(InstallerUtil.getInstallerFile("stats.properties"));
        this.stats.load(in);
        ((InputStream)in).close();
    }

    public long getSelectedContentSize() throws IOException {
        return this.getStatValue("content.size.", this.getSelectedContentNumbers(null));
    }

    public long getSelectedContentCount() throws IOException {
        return this.getStatValue("content.count.", this.getSelectedContentNumbers(null));
    }

    public long getSelectedContentSize(String componentId) throws IOException {
        return this.getStatValue("content.size.", this.getSelectedContentNumbers(componentId));
    }

    public long getSelectedContentCount(String componentId) throws IOException {
        return this.getStatValue("content.count.", this.getSelectedContentNumbers(componentId));
    }

    private long getStatValue(String type, Set<String> contentNumbers) {
        long ret = 0L;
        for (String number : contentNumbers) {
            ret += Long.parseLong(this.stats.getProperty(type + number));
        }
        return ret;
    }

    public Set<String> getSelectedContentNumbers(String componentId) {
        HashSet<String> ret = new HashSet<String>();
        if (componentId == null) {
            this.addContentNumbers(ret, String.valueOf(0));
            for (String s : ContentStats.getSelectedComponents()) {
                this.addContentNumbers(ret, s);
            }
        } else {
            this.addContentNumbers(ret, componentId);
        }
        return ret;
    }

    private static Collection<String> getSelectedComponents() {
        return HelperCommunication.getInstance().fetchObject(ExecutionContext.UNELEVATED, new FetchObjectAction<Collection<String>>(){

            @Override
            protected Collection<String> fetchValue(Context context) throws Exception {
                ArrayList<String> ret = new ArrayList<String>();
                for (ComponentConfig componentConfig : InstallerConfig.getCurrentInstance().getComponents()) {
                    if (!componentConfig.isSelected()) continue;
                    ret.add(componentConfig.getId());
                }
                return ret;
            }
        });
    }

    private void addContentNumbers(Set<String> ret, String componentId) {
        int setNumbers = Integer.parseInt(this.stats.getProperty("setCount", "0"));
        for (int i = 0; i < setNumbers; ++i) {
            String components = this.stats.getProperty("components." + i);
            StringTokenizer stringTokenizer = new StringTokenizer(components, ".");
            while (stringTokenizer.hasMoreTokens()) {
                String componentInFile = stringTokenizer.nextToken();
                if (!Objects.equals(componentInFile, componentId)) continue;
                ret.add(String.valueOf(i));
            }
        }
    }

    public long getFileSize(String number) {
        return Long.parseLong(this.stats.getProperty("file.size." + number));
    }

    public String getDirName() {
        return this.stats.getProperty("dirName");
    }

    public String getFileName(String number) {
        return this.stats.getProperty("file.name." + number);
    }

    public String getComponentListString(String number) {
        return this.stats.getProperty("components." + number);
    }

    public String toString() {
        return "ContentStats{stats=" + this.stats + '}';
    }
}

