/*
 * Decompiled with CFR 0.152.
 */
package com.install4j.runtime.installer.helper.content;

import com.install4j.api.context.Context;
import com.install4j.runtime.installer.helper.InstallerUtil;
import com.install4j.runtime.installer.helper.Logger;
import com.install4j.runtime.installer.helper.comm.ExecutionContext;
import com.install4j.runtime.installer.helper.comm.HelperCommunication;
import com.install4j.runtime.installer.helper.comm.actions.FetchObjectAction;
import com.install4j.runtime.installer.helper.versionspecific.ProxyHostInfo;
import com.install4j.runtime.installer.platform.win32.Win32Proxy;
import java.net.URL;

public class ProxyHelper {
    public static final boolean DEBUG_PAC = Boolean.getBoolean("install4j.debugPAC");

    public static ProxyHostInfo getProxyHostInfo(final URL url) {
        if (!InstallerUtil.isWindows()) {
            return null;
        }
        return HelperCommunication.getInstance().fetchObject(ExecutionContext.UNELEVATED, new FetchObjectAction<ProxyHostInfo>(){

            @Override
            protected ProxyHostInfo fetchValue(Context context) throws Exception {
                return ProxyHelper.getProxyHostInfoUnguarded(url);
            }
        });
    }

    private static ProxyHostInfo getProxyHostInfoUnguarded(URL url) {
        String host = url.getHost().toLowerCase();
        if (host.equals("localhost") || host.equals("127.0.0.1")) {
            return null;
        }
        try {
            return Win32Proxy.getProxyHostInfo(url);
        }
        catch (Throwable t) {
            Logger.getInstance().log(t);
            t.printStackTrace();
            return null;
        }
    }
}

