/*
 * Decompiled with CFR 0.152.
 */
package com.install4j.runtime.installer.helper.content.apache.archivers.tar;

import com.install4j.runtime.installer.helper.content.apache.archivers.ArchiveEntry;
import com.install4j.runtime.installer.helper.content.apache.archivers.ArchiveInputStream;
import com.install4j.runtime.installer.helper.content.apache.archivers.tar.TarArchiveEntry;
import com.install4j.runtime.installer.helper.content.apache.archivers.tar.TarArchiveSparseEntry;
import com.install4j.runtime.installer.helper.content.apache.archivers.tar.TarBuffer;
import com.install4j.runtime.installer.helper.content.apache.archivers.tar.TarUtils;
import com.install4j.runtime.installer.helper.content.apache.utils.ArchiveUtils;
import com.install4j.runtime.installer.helper.content.apache.utils.ZipEncoding;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;

public class TarArchiveInputStream
extends ArchiveInputStream {
    private static final int SMALL_BUFFER_SIZE = 256;
    private static final int BUFFER_SIZE = 8192;
    private boolean hasHitEOF;
    private long entrySize;
    private long entryOffset;
    private byte[] readBuf;
    protected final TarBuffer buffer;
    private TarArchiveEntry currEntry;
    private final ZipEncoding encoding = TarUtils.DEFAULT_ENCODING;

    public TarArchiveInputStream(InputStream is) {
        this(is, 10240, 512);
    }

    public TarArchiveInputStream(InputStream is, int blockSize) {
        this(is, blockSize, 512);
    }

    public TarArchiveInputStream(InputStream is, int blockSize, int recordSize) {
        this.buffer = new TarBuffer(is, blockSize, recordSize);
        this.readBuf = null;
        this.hasHitEOF = false;
    }

    @Override
    public void close() throws IOException {
        this.buffer.close();
    }

    public int getRecordSize() {
        return this.buffer.getRecordSize();
    }

    @Override
    public int available() throws IOException {
        if (this.entrySize - this.entryOffset > Integer.MAX_VALUE) {
            return Integer.MAX_VALUE;
        }
        return (int)(this.entrySize - this.entryOffset);
    }

    @Override
    public long skip(long numToSkip) throws IOException {
        int realSkip;
        long skip;
        int numRead;
        byte[] skipBuf = new byte[8192];
        for (skip = numToSkip; skip > 0L && (numRead = this.read(skipBuf, 0, realSkip = (int)(skip > (long)skipBuf.length ? (long)skipBuf.length : skip))) != -1; skip -= (long)numRead) {
        }
        return numToSkip - skip;
    }

    @Override
    public synchronized void reset() {
    }

    public TarArchiveEntry getNextTarEntry() throws IOException {
        if (this.hasHitEOF) {
            return null;
        }
        if (this.currEntry != null) {
            long skipped;
            for (long numToSkip = this.entrySize - this.entryOffset; numToSkip > 0L; numToSkip -= skipped) {
                skipped = this.skip(numToSkip);
                if (skipped > 0L) continue;
                throw new RuntimeException("failed to skip current tar entry");
            }
            this.readBuf = null;
        }
        byte[] headerBuf = this.getRecord();
        if (this.hasHitEOF) {
            this.currEntry = null;
            return null;
        }
        try {
            this.currEntry = new TarArchiveEntry(headerBuf, this.encoding);
        }
        catch (IllegalArgumentException e) {
            IOException ioe = new IOException("Error detected parsing the header");
            ioe.initCause(e);
            throw ioe;
        }
        this.entryOffset = 0L;
        this.entrySize = this.currEntry.getSize();
        if (this.currEntry.isGNULongNameEntry()) {
            StringBuilder longName = new StringBuilder();
            byte[] buf = new byte[256];
            int length = 0;
            while ((length = this.read(buf)) >= 0) {
                longName.append(new String(buf, 0, length));
            }
            this.getNextEntry();
            if (this.currEntry == null) {
                return null;
            }
            if (longName.length() > 0 && longName.charAt(longName.length() - 1) == '\u0000') {
                longName.deleteCharAt(longName.length() - 1);
            }
            this.currEntry.setName(longName.toString());
        }
        if (this.currEntry.isPaxHeader()) {
            this.paxHeaders();
        }
        if (this.currEntry.isGNUSparse()) {
            this.readGNUSparse();
        }
        this.entrySize = this.currEntry.getSize();
        return this.currEntry;
    }

    private byte[] getRecord() throws IOException {
        if (this.hasHitEOF) {
            return null;
        }
        byte[] headerBuf = this.buffer.readRecord();
        if (headerBuf == null) {
            this.hasHitEOF = true;
        } else if (this.buffer.isEOFRecord(headerBuf)) {
            this.hasHitEOF = true;
        }
        return this.hasHitEOF ? null : headerBuf;
    }

    private void paxHeaders() throws IOException {
        Map<String, String> headers = this.parsePaxHeaders(this);
        this.getNextEntry();
        this.applyPaxHeadersToCurrentEntry(headers);
    }

    Map<String, String> parsePaxHeaders(InputStream i) throws IOException {
        int ch;
        HashMap<String, String> headers = new HashMap<String, String>();
        block0: do {
            int len = 0;
            int read = 0;
            while ((ch = i.read()) != -1) {
                ++read;
                if (ch == 32) {
                    ByteArrayOutputStream coll = new ByteArrayOutputStream();
                    while ((ch = i.read()) != -1) {
                        ++read;
                        if (ch == 61) {
                            String keyword = coll.toString("UTF-8");
                            byte[] rest = new byte[len - read];
                            int got = i.read(rest);
                            if (got != len - read) {
                                throw new IOException("Failed to read Paxheader. Expected " + (len - read) + " bytes, read " + got);
                            }
                            String value = new String(rest, 0, len - read - 1, "UTF-8");
                            headers.put(keyword, value);
                            continue block0;
                        }
                        coll.write((byte)ch);
                    }
                    continue block0;
                }
                len *= 10;
                len += ch - 48;
            }
        } while (ch != -1);
        return headers;
    }

    private void applyPaxHeadersToCurrentEntry(Map<String, String> headers) {
        for (Map.Entry<String, String> ent : headers.entrySet()) {
            String key = ent.getKey();
            String val = ent.getValue();
            if (Objects.equals("path", key)) {
                this.currEntry.setName(val);
                continue;
            }
            if (Objects.equals("linkpath", key)) {
                this.currEntry.setLinkName(val);
                continue;
            }
            if (Objects.equals("gid", key)) {
                this.currEntry.setGroupId(Integer.parseInt(val));
                continue;
            }
            if (Objects.equals("gname", key)) {
                this.currEntry.setGroupName(val);
                continue;
            }
            if (Objects.equals("uid", key)) {
                this.currEntry.setUserId(Integer.parseInt(val));
                continue;
            }
            if (Objects.equals("uname", key)) {
                this.currEntry.setUserName(val);
                continue;
            }
            if (Objects.equals("size", key)) {
                this.currEntry.setSize(Long.parseLong(val));
                continue;
            }
            if (Objects.equals("mtime", key)) {
                this.currEntry.setModTime((long)(Double.parseDouble(val) * 1000.0));
                continue;
            }
            if (Objects.equals("SCHILY.devminor", key)) {
                this.currEntry.setDevMinor(Integer.parseInt(val));
                continue;
            }
            if (!Objects.equals("SCHILY.devmajor", key)) continue;
            this.currEntry.setDevMajor(Integer.parseInt(val));
        }
    }

    private void readGNUSparse() throws IOException {
        if (this.currEntry.isExtended()) {
            byte[] headerBuf;
            TarArchiveSparseEntry entry;
            do {
                headerBuf = this.getRecord();
                if (!this.hasHitEOF) continue;
                this.currEntry = null;
                break;
            } while ((entry = new TarArchiveSparseEntry(headerBuf)).isExtended());
        }
    }

    @Override
    public ArchiveEntry getNextEntry() throws IOException {
        return this.getNextTarEntry();
    }

    @Override
    public int read(@NotNull byte[] buf, int offset, int numToRead) throws IOException {
        int totalRead = 0;
        if (this.entryOffset >= this.entrySize) {
            return -1;
        }
        if ((long)numToRead + this.entryOffset > this.entrySize) {
            numToRead = (int)(this.entrySize - this.entryOffset);
        }
        if (this.readBuf != null) {
            int sz = numToRead > this.readBuf.length ? this.readBuf.length : numToRead;
            System.arraycopy(this.readBuf, 0, buf, offset, sz);
            if (sz >= this.readBuf.length) {
                this.readBuf = null;
            } else {
                int newLen = this.readBuf.length - sz;
                byte[] newBuf = new byte[newLen];
                System.arraycopy(this.readBuf, sz, newBuf, 0, newLen);
                this.readBuf = newBuf;
            }
            totalRead += sz;
            numToRead -= sz;
            offset += sz;
        }
        while (numToRead > 0) {
            byte[] rec = this.buffer.readRecord();
            if (rec == null) {
                throw new IOException("unexpected EOF with " + numToRead + " bytes unread. Occured at byte: " + this.getBytesRead());
            }
            this.count(rec.length);
            int sz = numToRead;
            int recLen = rec.length;
            if (recLen > sz) {
                System.arraycopy(rec, 0, buf, offset, sz);
                this.readBuf = new byte[recLen - sz];
                System.arraycopy(rec, sz, this.readBuf, 0, recLen - sz);
            } else {
                sz = recLen;
                System.arraycopy(rec, 0, buf, offset, recLen);
            }
            totalRead += sz;
            numToRead -= sz;
            offset += sz;
        }
        this.entryOffset += (long)totalRead;
        return totalRead;
    }

    @Override
    public boolean canReadEntryData(ArchiveEntry ae) {
        if (ae instanceof TarArchiveEntry) {
            TarArchiveEntry te = (TarArchiveEntry)ae;
            return !te.isGNUSparse();
        }
        return false;
    }

    protected final TarArchiveEntry getCurrentEntry() {
        return this.currEntry;
    }

    protected final void setCurrentEntry(TarArchiveEntry e) {
        this.currEntry = e;
    }

    protected final boolean isAtEOF() {
        return this.hasHitEOF;
    }

    protected final void setAtEOF(boolean b) {
        this.hasHitEOF = b;
    }

    public static boolean matches(byte[] signature, int length) {
        if (length < 265) {
            return false;
        }
        if (ArchiveUtils.matchAsciiBuffer("ustar\u0000", signature, 257, 6) && ArchiveUtils.matchAsciiBuffer("00", signature, 263, 2)) {
            return true;
        }
        if (ArchiveUtils.matchAsciiBuffer("ustar ", signature, 257, 6) && (ArchiveUtils.matchAsciiBuffer(" \u0000", signature, 263, 2) || ArchiveUtils.matchAsciiBuffer("0\u0000", signature, 263, 2))) {
            return true;
        }
        return ArchiveUtils.matchAsciiBuffer("ustar\u0000", signature, 257, 6) && ArchiveUtils.matchAsciiBuffer("\u0000\u0000", signature, 263, 2);
    }
}

