/*
 * Decompiled with CFR 0.152.
 */
package com.install4j.runtime.installer.platform.macos;

import com.install4j.api.macos.MacProcesses;
import com.install4j.runtime.installer.helper.AppleScriptHelper;
import com.install4j.runtime.installer.helper.Logger;
import com.install4j.runtime.installer.platform.unix.Execution;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class MacProcessHelper {
    private static final Pattern PATTERN_MODULE_NAME = Pattern.compile("-Dexe4j.moduleName=(.*)");
    private static final int MIN_TIMEOUT = 400;
    public static final int TIMEOUT_STEP = 200;

    public static boolean terminateProcesses(int[] processIds, boolean force, int closeTimeout) {
        ArrayList<String> command = new ArrayList<String>();
        command.add("/bin/kill");
        if (force) {
            command.add("-9");
        }
        for (int processId : processIds) {
            command.add(String.valueOf(processId));
        }
        StringBuffer output = new StringBuffer();
        try {
            Execution.executeAndWait(command.toArray(new String[0]), output);
        }
        catch (IOException e) {
            Logger.getImpl().log(e);
            return false;
        }
        if (closeTimeout < 400) {
            closeTimeout = 400;
        }
        while (closeTimeout > 0) {
            if (MacProcessHelper.checkProcessesExited(processIds)) {
                return true;
            }
            try {
                Thread.sleep(200L);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
            closeTimeout -= 200;
        }
        return false;
    }

    private static boolean checkProcessesExited(int[] processIds) {
        for (int processId : processIds) {
            try {
                if (Execution.executeAndWait(new String[]{"/bin/kill", "-0", String.valueOf(processId)}, null)) continue;
                return false;
            }
            catch (IOException e) {
                Logger.getImpl().log(e);
                return false;
            }
        }
        return true;
    }

    public static MacProcesses.Info[] getRunningProcesses() {
        ArrayList<MacProcesses.Info> processes = new ArrayList<MacProcesses.Info>();
        HashMap<Integer, MacProcesses.Info> pidToProcess = new HashMap<Integer, MacProcesses.Info>();
        MacProcessHelper.addGuiProcesses(processes, pidToProcess);
        try {
            MacProcessHelper.addCommandLineProcesses(processes, pidToProcess);
        }
        catch (IOException e) {
            Logger.getImpl().log(e);
        }
        return processes.toArray(new MacProcesses.Info[0]);
    }

    private static void addGuiProcesses(List<MacProcesses.Info> processes, Map<Integer, MacProcesses.Info> pidToProcess) {
        String script = "tell application \"System Events\"\n    set listOfProcesses to every process\n    set output to \"\"\n    repeat with aProcess in listOfProcesses\n" + AppleScriptHelper.getRecordScript("disp", "displayed name of aProcess", "bid", "bundle identifier of aProcess", "pid", "unix id of aProcess", "bgr", "background only of aProcess") + "    end repeat\n" + "end tell\n" + "return output";
        List<Map<String, String>> records = AppleScriptHelper.getRecords(script);
        if (records != null) {
            for (Map<String, String> record : records) {
                try {
                    boolean backgroundOnly;
                    String bundleIdentifier;
                    String displayedName;
                    int pid = Integer.parseInt(record.get("pid"));
                    MacProcesses.Info info = new MacProcesses.Info(pid, "", displayedName = record.get("disp"), bundleIdentifier = record.get("bid"), backgroundOnly = Boolean.parseBoolean(record.get("bgr")));
                    if (processes.contains(info)) continue;
                    processes.add(info);
                    pidToProcess.put(pid, info);
                }
                catch (NumberFormatException e) {
                    Logger.getInstance().log(e);
                }
            }
        }
    }

    private static void addCommandLineProcesses(List<MacProcesses.Info> processes, Map<Integer, MacProcesses.Info> pidToProcess) throws IOException {
        String[] lines;
        StringBuffer output = new StringBuffer();
        Execution.executeAndWait(new String[]{"/bin/ps", "-axo", "pid,args"}, output);
        for (String line : lines = output.toString().split("\n")) {
            if (line.trim().isEmpty()) continue;
            String[] columns = line.trim().split(" ", 2);
            try {
                MacProcesses.Info info;
                int pid = Integer.parseInt(columns[0]);
                String moduleName = MacProcessHelper.getModuleNameFromCommandLine(columns[1]);
                MacProcesses.Info guiProcessInfo = pidToProcess.get(pid);
                if (guiProcessInfo == null) {
                    info = new MacProcesses.Info(pid, moduleName, new File(moduleName).getName(), null, true);
                    processes.add(info);
                    pidToProcess.put(pid, info);
                    continue;
                }
                if (!guiProcessInfo.getModuleName().isEmpty()) continue;
                processes.remove(guiProcessInfo);
                info = new MacProcesses.Info(pid, moduleName, guiProcessInfo.getDisplayedName(), guiProcessInfo.getBundleIdentifier(), guiProcessInfo.isBackgroundOnly());
                processes.add(info);
                pidToProcess.put(pid, info);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
    }

    private static String getModuleNameFromCommandLine(String commandLine) {
        Matcher matcher = PATTERN_MODULE_NAME.matcher(commandLine);
        if (matcher.find()) {
            return MacProcessHelper.getLongestExistingPath(matcher.group(1));
        }
        return MacProcessHelper.getLongestExistingPath(commandLine);
    }

    private static String getLongestExistingPath(String commandLine) {
        String[] components = commandLine.split(" ");
        for (int max = components.length; max > 0; --max) {
            StringBuilder buffer = new StringBuilder();
            for (int i = 0; i < max; ++i) {
                if (i > 0) {
                    buffer.append(' ');
                }
                buffer.append(components[i]);
            }
            String fileName = buffer.toString();
            try {
                if (!new File(fileName).exists()) continue;
                return fileName;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return commandLine;
    }
}

