/*
 * Decompiled with CFR 0.152.
 */
package com.install4j.runtime.installer.platform.win32;

import com.install4j.api.Util;
import com.install4j.runtime.installer.platform.win32.Common;
import com.install4j.runtime.installer.platform.win32.WinGuiHelper;
import java.awt.Window;
import java.io.File;

public class VistaFileChooser {
    public static final int FOS_OVERWRITEPROMPT = 2;
    public static final int FOS_STRICTFILETYPES = 4;
    public static final int FOS_NOCHANGEDIR = 8;
    public static final int FOS_PICKFOLDERS = 32;
    public static final int FOS_FORCEFILESYSTEM = 64;
    public static final int FOS_ALLNONSTORAGEITEMS = 128;
    public static final int FOS_NOVALIDATE = 256;
    public static final int FOS_ALLOWMULTISELECT = 512;
    public static final int FOS_PATHMUSTEXIST = 2048;
    public static final int FOS_FILEMUSTEXIST = 4096;
    public static final int FOS_CREATEPROMPT = 8192;
    public static final int FOS_SHAREAWARE = 16384;
    public static final int FOS_NOREADONLYRETURN = 32768;
    public static final int FOS_NOTESTFILECREATE = 65536;
    public static final int FOS_HIDEMRUPLACES = 131072;
    public static final int FOS_HIDEPINNEDPLACES = 262144;
    public static final int FOS_NODEREFERENCELINKS = 0x100000;
    public static final int FOS_DONTADDTORECENT = 0x2000000;
    public static final int FOS_FORCESHOWHIDDEN = 0x10000000;
    public static final int FOS_DEFAULTNOMINIMODE = 0x20000000;
    public static final int FOS_FORCEPREVIEWPANEON = 0x40000000;
    public static final int FOS_SUPPORTSTREAMABLEITEMS = Integer.MIN_VALUE;
    private static ThreadLocal initializer;
    private final boolean save;
    private File directory;
    private String fileName;
    private String defaultExtension;
    private String title;
    private String button;
    private int includedOptions;
    private int excludedOptions;
    private int selectedFilter;
    private Question[] questions;
    private Filter[] filter;

    private static synchronized native void initialize0();

    private static native String[] displayDialog0(long var0, String var2, String var3, String var4, String var5, int var6, int var7, boolean var8, String var9, String[] var10, String[] var11, int var12, String[] var13, boolean[] var14);

    private static void initialize() {
        initializer.get();
    }

    public VistaFileChooser(boolean save) {
        if (!Util.isAtLeastWindowsVista()) {
            throw new RuntimeException("works only on Windows Vista or higher");
        }
        this.save = save;
    }

    public File[] show(Window parent) {
        VistaFileChooser.initialize();
        String[] filterNames = null;
        String[] filterSpecs = null;
        if (this.filter != null) {
            filterNames = new String[this.filter.length];
            filterSpecs = new String[this.filter.length];
            for (int i = 0; i < this.filter.length; ++i) {
                filterNames[i] = this.filter[i].name;
                filterSpecs[i] = this.filter[i].spec;
            }
        }
        String[] checkboxes = null;
        boolean[] states = null;
        if (this.questions != null) {
            checkboxes = new String[this.questions.length];
            states = new boolean[this.questions.length];
            for (int i = 0; i < this.questions.length; ++i) {
                checkboxes[i] = this.questions[i].description;
                states[i] = this.questions[i].selected;
            }
        }
        String[] selection = VistaFileChooser.displayDialog0(WinGuiHelper.getHwnd(parent), this.title, this.button, this.directory == null ? null : this.directory.getAbsolutePath(), this.fileName, this.includedOptions, this.excludedOptions, this.save, this.defaultExtension, filterNames, filterSpecs, this.selectedFilter, checkboxes, states);
        if (this.questions != null) {
            for (int i = 0; i < this.questions.length; ++i) {
                assert (states != null);
                this.questions[i].selected = states[i];
            }
        }
        if (selection != null) {
            File[] ret = new File[selection.length];
            for (int i = 0; i < selection.length; ++i) {
                ret[i] = new File(selection[i]);
            }
            return ret;
        }
        return null;
    }

    public VistaFileChooser directory(File directory) {
        this.directory = directory;
        return this;
    }

    public VistaFileChooser fileName(String fileName) {
        this.fileName = fileName;
        return this;
    }

    public VistaFileChooser defaultExtension(String defaultExtension) {
        this.defaultExtension = defaultExtension;
        return this;
    }

    public VistaFileChooser title(String title) {
        this.title = title;
        return this;
    }

    public VistaFileChooser button(String button) {
        this.button = button;
        return this;
    }

    public VistaFileChooser includedOptions(int includedOptions) {
        this.includedOptions = includedOptions;
        return this;
    }

    public VistaFileChooser excludedOptions(int excludedOptions) {
        this.excludedOptions = excludedOptions;
        return this;
    }

    public VistaFileChooser selectedFilter(int selectedFilter) {
        this.selectedFilter = selectedFilter;
        return this;
    }

    public VistaFileChooser questions(Question[] questions) {
        this.questions = questions;
        return this;
    }

    public VistaFileChooser filter(Filter[] filter) {
        this.filter = filter;
        return this;
    }

    static {
        Common.init();
        initializer = new ThreadLocal(){

            protected Object initialValue() {
                VistaFileChooser.initialize0();
                return null;
            }
        };
    }

    public static class Question {
        private final String description;
        private boolean selected;

        public Question(String description, boolean selected) {
            this.description = description;
            this.selected = selected;
        }

        public boolean isSelected() {
            return this.selected;
        }
    }

    public static class Filter {
        private final String name;
        private final String spec;

        public Filter(String name, String spec) {
            this.name = name;
            this.spec = spec;
        }
    }
}

