/*
 * Decompiled with CFR 0.152.
 */
package com.install4j.runtime.util;

import com.install4j.runtime.util.CustomLabel;
import java.awt.Color;
import java.awt.Cursor;
import java.awt.event.ActionEvent;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Objects;
import java.util.WeakHashMap;
import javax.swing.Action;

public class HyperlinkLabel
extends CustomLabel
implements MouseListener {
    private static final Color COLOR_PASSIVE = Color.BLUE;
    private static final Color COLOR_ACTIVE = Color.RED;
    private static WeakHashMap<HyperlinkLabel, Object> allLabels = new WeakHashMap();
    private Action action;
    private boolean override;
    private static Color passiveColor = COLOR_PASSIVE;
    private static Color activeColor = COLOR_ACTIVE;

    public static void setPassiveColor(Color color) {
        passiveColor = color;
        for (HyperlinkLabel hyperlinkLabel : allLabels.keySet()) {
            if (hyperlinkLabel == null) continue;
            hyperlinkLabel.setForeground(color);
        }
    }

    public static void setActiveColor(Color color) {
        activeColor = color;
    }

    public HyperlinkLabel(Action action) {
        this((String)action.getValue("Name"), action);
    }

    public HyperlinkLabel(String text, Action action) {
        super(text);
        this.action = action;
        allLabels.put(this, null);
        this.setupComponent();
        this.setupEventHandlers();
        this.changeState(action.isEnabled());
    }

    @Override
    public void setEnabled(boolean enabled) {
        this.override = true;
        this.changeState(enabled);
    }

    public void clearOverride() {
        this.override = false;
        this.changeState(this.action.isEnabled());
    }

    public Action getAction() {
        return this.action;
    }

    private void setupComponent() {
        this.setUnderlined(true);
        this.setForeground(passiveColor);
        this.setCursor(Cursor.getPredefinedCursor(12));
    }

    private void setupEventHandlers() {
        this.action.addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent event) {
                if (Objects.equals(event.getPropertyName(), "enabled") && !HyperlinkLabel.this.override) {
                    HyperlinkLabel.this.changeState((Boolean)event.getNewValue());
                }
            }
        });
    }

    private void changeState(boolean enabled) {
        this.setUnderlined(enabled);
        if (enabled) {
            this.addMouseListener(this);
        } else {
            this.removeMouseListener(this);
        }
        super.setEnabled(enabled);
    }

    @Override
    public void mousePressed(MouseEvent event) {
        if ((event.getModifiers() & 0x10) == 0) {
            return;
        }
        this.setForeground(activeColor);
    }

    @Override
    public void mouseReleased(MouseEvent event) {
        if ((event.getModifiers() & 0x10) == 0) {
            return;
        }
        this.setForeground(passiveColor);
    }

    @Override
    public void mouseClicked(MouseEvent event) {
        if ((event.getModifiers() & 0x10) == 0) {
            return;
        }
        if (this.action != null && this.action.isEnabled()) {
            this.action.actionPerformed(new ActionEvent(this, 0, null));
        }
    }

    @Override
    public void mouseExited(MouseEvent event) {
    }

    @Override
    public void mouseEntered(MouseEvent event) {
    }
}

