/*
 * Decompiled with CFR 0.152.
 */
package com.install4j.runtime.util;

import java.awt.SecondaryLoop;
import java.awt.Toolkit;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.SynchronousQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.jetbrains.annotations.NotNull;

public class SecondaryLoopHelper {
    private static final ExecutorService executor = new ThreadPoolExecutor(0, Integer.MAX_VALUE, 10000L, TimeUnit.DAYS, new SynchronousQueue<Runnable>(), new ThreadFactory(){
        private ThreadFactory threadFactory = Executors.defaultThreadFactory();

        @Override
        public Thread newThread(@NotNull Runnable runnable) {
            Thread thread = this.threadFactory.newThread(runnable);
            thread.setDaemon(true);
            return thread;
        }
    });

    private SecondaryLoopHelper() {
    }

    public static <V> V executeWithSecondaryLoopChecked(final Callable<V> callable) throws Exception {
        final SecondaryLoop secondaryLoop = Toolkit.getDefaultToolkit().getSystemEventQueue().createSecondaryLoop();
        Future future = executor.submit(new Callable<V>(){

            @Override
            public V call() throws Exception {
                try {
                    Object v = callable.call();
                    return v;
                }
                finally {
                    while (!secondaryLoop.exit()) {
                        Thread.sleep(200L);
                    }
                }
            }
        });
        secondaryLoop.enter();
        try {
            return (V)future.get();
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
        catch (ExecutionException e) {
            if (e.getCause() instanceof Error) {
                throw (Error)e.getCause();
            }
            if (e.getCause() instanceof Exception) {
                throw (Exception)e.getCause();
            }
            throw new RuntimeException(e.getCause());
        }
    }

    public static <V> V executeWithSecondaryLoop(Callable<V> callable) {
        try {
            return SecondaryLoopHelper.executeWithSecondaryLoopChecked(callable);
        }
        catch (Exception e) {
            if (e instanceof RuntimeException) {
                throw (RuntimeException)e;
            }
            throw new RuntimeException(e);
        }
    }
}

