/*
 * Decompiled with CFR 0.152.
 */
package org.astrogrid.samp;

import java.util.HashMap;
import java.util.Map;
import org.astrogrid.samp.DataException;
import org.astrogrid.samp.SampMap;

public class Message
extends SampMap {
    public static final String MTYPE_KEY = "samp.mtype";
    public static final String PARAMS_KEY = "samp.params";
    private static final String[] KNOWN_KEYS = new String[]{"samp.mtype", "samp.params"};

    public Message() {
        super(KNOWN_KEYS);
    }

    public Message(Map map) {
        this();
        this.putAll(map);
    }

    public Message(String mtype, Map params) {
        this();
        this.put(MTYPE_KEY, mtype);
        this.put(PARAMS_KEY, params == null ? new HashMap() : params);
    }

    public Message(String mtype) {
        this(mtype, null);
    }

    public String getMType() {
        return this.getString(MTYPE_KEY);
    }

    public void setParams(Map params) {
        this.put(PARAMS_KEY, params);
    }

    public Map getParams() {
        return this.getMap(PARAMS_KEY);
    }

    public Message addParam(String name, Object value) {
        if (!this.containsKey(PARAMS_KEY)) {
            this.put(PARAMS_KEY, new HashMap());
        }
        this.getParams().put(name, value);
        return this;
    }

    public Object getParam(String name) {
        Map params = this.getParams();
        return params == null ? null : params.get(name);
    }

    public Object getRequiredParam(String name) {
        Object param = this.getParam(name);
        if (param != null) {
            return param;
        }
        throw new DataException("Required parameter \"" + name + "\" is missing");
    }

    public void check() {
        super.check();
        this.checkHasKeys(new String[]{MTYPE_KEY});
    }

    public static Message asMessage(Map map) {
        return map instanceof Message || map == null ? (Message)map : new Message(map);
    }
}

