/*
 * Decompiled with CFR 0.152.
 */
package org.astrogrid.samp.client;

import java.util.logging.Logger;
import org.astrogrid.samp.Client;
import org.astrogrid.samp.ErrInfo;
import org.astrogrid.samp.Message;
import org.astrogrid.samp.Response;
import org.astrogrid.samp.SampUtils;
import org.astrogrid.samp.client.ResultHandler;

public class LogResultHandler
implements ResultHandler {
    private final String mtype_;
    private static final Logger logger_ = Logger.getLogger(LogResultHandler.class.getName());

    public LogResultHandler(Message msg) {
        this.mtype_ = msg.getMType();
    }

    public void result(Client client, Response response) {
        if (response.isOK()) {
            logger_.info(this.mtype_ + ": successful send to " + client);
        } else {
            logger_.warning(this.mtype_ + ": error sending to " + client);
            ErrInfo errInfo = response.getErrInfo();
            if (errInfo != null) {
                String errortxt = errInfo.getErrortxt();
                if (errortxt != null) {
                    logger_.warning(errortxt);
                }
                logger_.info(SampUtils.formatObject(errInfo, 3));
            }
        }
    }

    public void done() {
    }
}

