/*
 * Decompiled with CFR 0.152.
 */
package org.astrogrid.samp.gui;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Toolkit;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;
import javax.swing.AbstractListModel;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.JComponent;
import javax.swing.JEditorPane;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTextField;
import javax.swing.border.Border;
import org.astrogrid.samp.Client;
import org.astrogrid.samp.Metadata;
import org.astrogrid.samp.Subscriptions;
import org.astrogrid.samp.gui.BrowserLauncher;
import org.astrogrid.samp.hub.HubClient;

public class ClientPanel
extends JPanel {
    private final JTextField idField_;
    private final JTextField profileField_;
    private final Box metaBox_;
    private final JList subsList_;
    private Client client_;
    private static final int INFO_WIDTH = 240;
    private final Logger logger_ = Logger.getLogger(ClientPanel.class.getName());

    public ClientPanel(boolean hubLike) {
        super(new BorderLayout());
        JSplitPane splitter = new JSplitPane(0);
        splitter.setBorder(BorderFactory.createEmptyBorder());
        splitter.setOneTouchExpandable(true);
        splitter.setResizeWeight(0.5);
        this.add((Component)splitter, "Center");
        Box regBox = Box.createVerticalBox();
        regBox.setBorder(ClientPanel.createTitledBorder("Registration"));
        Box idLine = Box.createHorizontalBox();
        this.idField_ = new JTextField();
        this.idField_.setEditable(false);
        this.idField_.setBorder(BorderFactory.createEmptyBorder());
        idLine.add(new JLabel("Public ID: "));
        idLine.add(this.idField_);
        regBox.add(idLine);
        if (hubLike) {
            this.profileField_ = new JTextField();
            this.profileField_.setEditable(false);
            this.profileField_.setBorder(BorderFactory.createEmptyBorder());
            Box profileLine = Box.createHorizontalBox();
            profileLine.add(new JLabel("Profile: "));
            profileLine.add(this.profileField_);
            regBox.add(profileLine);
        } else {
            this.profileField_ = null;
        }
        this.add((Component)regBox, "North");
        this.metaBox_ = Box.createVerticalBox();
        JPanel metaPanel = new JPanel(new BorderLayout());
        metaPanel.add((Component)this.metaBox_, "North");
        JScrollPane metaScroller = new JScrollPane(metaPanel);
        metaScroller.setBorder(ClientPanel.createTitledBorder("Metadata"));
        metaScroller.setPreferredSize(new Dimension(240, 120));
        splitter.setTopComponent(metaScroller);
        Box subsBox = Box.createVerticalBox();
        this.subsList_ = new JList();
        JScrollPane subsScroller = new JScrollPane(this.subsList_);
        subsScroller.setBorder(ClientPanel.createTitledBorder("Subscriptions"));
        subsScroller.setPreferredSize(new Dimension(240, 120));
        subsBox.add(subsScroller);
        splitter.setBottomComponent(subsBox);
    }

    public void setClient(Client client) {
        this.idField_.setText(client == null ? null : client.getId());
        if (this.profileField_ != null) {
            this.profileField_.setText(client instanceof HubClient ? ((HubClient)client).getProfileToken().getProfileName() : null);
        }
        this.setMetadata(client == null ? null : client.getMetadata());
        this.setSubscriptions(client == null ? null : client.getSubscriptions());
        this.client_ = client;
    }

    public Client getClient() {
        return this.client_;
    }

    public void setMetadata(Metadata meta) {
        this.metaBox_.removeAll();
        if (meta != null) {
            Iterator it = meta.entrySet().iterator();
            while (it.hasNext()) {
                Map.Entry entry = (Map.Entry)it.next();
                String key = (String)entry.getKey();
                Object value = entry.getValue();
                Box keyBox = Box.createHorizontalBox();
                keyBox.add(new JLabel(key + ":"));
                keyBox.add(Box.createHorizontalGlue());
                this.metaBox_.add(keyBox);
                Box valueBox = Box.createHorizontalBox();
                valueBox.add(Box.createHorizontalStrut(24));
                valueBox.add(this.createViewer(value));
                this.metaBox_.add(valueBox);
            }
        }
        this.metaBox_.add(Box.createVerticalGlue());
        this.metaBox_.repaint();
        this.metaBox_.revalidate();
    }

    public void setSubscriptions(Subscriptions subs) {
        final Object[] subscriptions = subs == null ? new Object[]{} : subs.keySet().toArray();
        this.subsList_.setModel(new AbstractListModel(){

            public int getSize() {
                return subscriptions.length;
            }

            public Object getElementAt(int index) {
                return subscriptions[index];
            }
        });
    }

    public void openURL(URL url) throws IOException {
        BrowserLauncher.openURL(url.toString());
    }

    private JComponent createViewer(Object value) {
        if (value instanceof String) {
            JTextField field = new JTextField();
            field.setEditable(false);
            field.setText((String)value);
            field.setCaretPosition(0);
            try {
                final URL url = new URL((String)value);
                field.setForeground(Color.BLUE);
                field.addMouseListener(new MouseAdapter(){

                    public void mouseClicked(MouseEvent evt) {
                        try {
                            ClientPanel.this.openURL(url);
                        }
                        catch (IOException e) {
                            Toolkit.getDefaultToolkit().beep();
                            ClientPanel.this.logger_.warning("Can't open URL " + url + e);
                        }
                    }
                });
            }
            catch (MalformedURLException malformedURLException) {
                // empty catch block
            }
            return field;
        }
        if (value instanceof List) {
            return new JList<Object>(((List)value).toArray());
        }
        if (value instanceof Map) {
            JEditorPane edPane = new JEditorPane("text/html", ClientPanel.toHtml(value));
            edPane.setEditable(false);
            edPane.setCaretPosition(0);
            return edPane;
        }
        return new JLabel("???");
    }

    private static String toHtml(Object data) {
        StringBuffer sbuf = new StringBuffer();
        if (data instanceof Map) {
            sbuf.append("<dl>\n");
            Iterator it = ((Map)data).entrySet().iterator();
            while (it.hasNext()) {
                Map.Entry entry = it.next();
                sbuf.append("<dt>").append(ClientPanel.htmlEscape(String.valueOf(entry.getKey()))).append("</dt>\n").append("<dd>").append(ClientPanel.toHtml(entry.getValue())).append("</dd>\n");
            }
            sbuf.append("</dl>\n");
        } else if (data instanceof List) {
            sbuf.append("<ul>\n");
            Iterator it = ((List)data).iterator();
            while (it.hasNext()) {
                sbuf.append("<li>").append(ClientPanel.toHtml(it.next())).append("</li>\n");
            }
            sbuf.append("</ul>\n");
        } else if (data instanceof String) {
            sbuf.append(ClientPanel.htmlEscape((String)data));
        } else {
            sbuf.append("???");
        }
        return sbuf.toString();
    }

    private static String htmlEscape(String text) {
        int leng = text.length();
        StringBuffer sbuf = new StringBuffer(leng);
        block5: for (int i = 0; i < leng; ++i) {
            char c = text.charAt(i);
            switch (c) {
                case '<': {
                    sbuf.append("&lt;");
                    continue block5;
                }
                case '>': {
                    sbuf.append("&gt;");
                    continue block5;
                }
                case '&': {
                    sbuf.append("&amp;");
                    continue block5;
                }
                default: {
                    sbuf.append(c);
                }
            }
        }
        return sbuf.toString();
    }

    static Border createTitledBorder(String title) {
        return BorderFactory.createCompoundBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5), BorderFactory.createTitledBorder(BorderFactory.createLineBorder(Color.BLACK), title));
    }
}

