/*
 * Decompiled with CFR 0.152.
 */
package org.astrogrid.samp.gui;

import java.awt.event.ActionEvent;
import java.util.Map;
import java.util.Random;
import javax.swing.AbstractAction;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JList;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.ListModel;
import javax.swing.ListSelectionModel;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.astrogrid.samp.Client;
import org.astrogrid.samp.Message;
import org.astrogrid.samp.client.HubConnection;
import org.astrogrid.samp.client.SampException;
import org.astrogrid.samp.gui.ClientListCellRenderer;
import org.astrogrid.samp.gui.GuiClientSet;
import org.astrogrid.samp.gui.HubClientPopupListener;
import org.astrogrid.samp.gui.HubView;
import org.astrogrid.samp.gui.SampThread;
import org.astrogrid.samp.hub.BasicHubService;
import org.astrogrid.samp.hub.ClientSet;
import org.astrogrid.samp.hub.HubClient;

public class GuiHubService
extends BasicHubService {
    private GuiClientSet clientSet_;
    private ListSelectionModel selectionModel_;

    public GuiHubService(Random random) {
        super(random);
    }

    public void start() {
        super.start();
        this.clientSet_ = (GuiClientSet)this.getClientSet();
    }

    protected ClientSet createClientSet() {
        return new GuiClientSet(this.getIdComparator());
    }

    public JComponent createHubPanel() {
        HubView hubView = new HubView(true);
        hubView.setClientListModel(this.getClientListModel());
        JList jlist = hubView.getClientList();
        jlist.setCellRenderer(new ClientListCellRenderer());
        jlist.addMouseListener(new HubClientPopupListener(this));
        this.selectionModel_ = jlist.getSelectionModel();
        return hubView;
    }

    public JFrame createHubWindow() {
        JFrame frame = new JFrame("SAMP Hub");
        frame.getContentPane().add(this.createHubPanel());
        frame.setIconImage(new ImageIcon(Client.class.getResource("images/hub.png")).getImage());
        frame.pack();
        return frame;
    }

    protected void declareMetadata(HubClient caller, Map meta) throws SampException {
        super.declareMetadata(caller, meta);
        this.clientSet_.scheduleClientChanged(caller);
    }

    protected void declareSubscriptions(HubClient caller, Map subscriptions) throws SampException {
        super.declareSubscriptions(caller, subscriptions);
        this.clientSet_.scheduleClientChanged(caller);
    }

    public ListModel getClientListModel() {
        return this.clientSet_;
    }

    public ListSelectionModel getClientSelectionModel() {
        return this.selectionModel_;
    }

    private Client getSelectedClient() {
        ListSelectionModel selModel = this.getClientSelectionModel();
        int isel = selModel.getMinSelectionIndex();
        Object selected = isel >= 0 ? this.getClientListModel().getElementAt(isel) : null;
        return selected instanceof Client ? (Client)selected : null;
    }

    public JMenu[] createMenus() {
        final HubConnection serviceConnection = this.getServiceConnection();
        final String hubId = serviceConnection.getRegInfo().getSelfId();
        final Message pingMessage = new Message("samp.app.ping");
        AbstractAction pingAllAction = new AbstractAction("Ping all"){

            public void actionPerformed(ActionEvent evt) {
                new SampThread(evt, "Ping Error", "Error broadcasting ping"){

                    protected void sampRun() throws SampException {
                        serviceConnection.callAll("ping-tag", pingMessage);
                    }
                }.start();
            }
        };
        pingAllAction.putValue("ShortDescription", "Send ping message to all clients");
        String pingSelectedName = "Ping selected client";
        final AbstractAction pingSelectedAction = new AbstractAction("Ping selected client"){

            public void actionPerformed(ActionEvent evt) {
                final Client client = GuiHubService.this.getSelectedClient();
                if (client != null) {
                    new SampThread(evt, "Ping Error", "Error sending ping to " + client){

                        protected void sampRun() throws SampException {
                            serviceConnection.call(client.getId(), "ping-tag", pingMessage);
                        }
                    }.start();
                }
            }
        };
        pingSelectedAction.putValue("ShortDescription", "Send ping message to selected client");
        String disconnectSelectedName = "Disconnect selected client";
        final AbstractAction disconnectSelectedAction = new AbstractAction("Disconnect selected client"){

            public void actionPerformed(ActionEvent evt) {
                final Client client = GuiHubService.this.getSelectedClient();
                if (client != null) {
                    new SampThread(evt, "Disconnect Error", "Error disconnecting " + client){

                        protected void sampRun() throws SampException {
                            GuiHubService.this.disconnect(client.getId(), "GUI hub user requested ejection");
                        }
                    }.start();
                }
            }
        };
        disconnectSelectedAction.putValue("ShortDescription", "Forcibly disconnect selected client from the hub");
        ListSelectionListener selListener = new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent evt) {
                Client client = GuiHubService.this.getSelectedClient();
                boolean isSel = client != null;
                boolean canPing = isSel && client.getSubscriptions().isSubscribed(pingMessage.getMType());
                boolean canDisco = isSel && !hubId.equals(client.getId());
                pingSelectedAction.setEnabled(canPing);
                disconnectSelectedAction.setEnabled(canDisco);
                String clientDesignation = client == null ? "" : " (" + client + ")";
                pingSelectedAction.putValue("Name", "Ping selected client" + clientDesignation);
                disconnectSelectedAction.putValue("Name", "Disconnect selected client" + clientDesignation);
            }
        };
        this.getClientSelectionModel().addListSelectionListener(selListener);
        selListener.valueChanged(null);
        JMenu clientMenu = new JMenu("Clients");
        clientMenu.setMnemonic(67);
        clientMenu.add(new JMenuItem(pingAllAction));
        clientMenu.add(new JMenuItem(pingSelectedAction));
        clientMenu.add(new JMenuItem(disconnectSelectedAction));
        return new JMenu[]{clientMenu};
    }
}

