/*
 * Decompiled with CFR 0.152.
 */
package org.astrogrid.samp.hub;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.astrogrid.samp.Message;
import org.astrogrid.samp.Metadata;
import org.astrogrid.samp.client.AbstractMessageHandler;
import org.astrogrid.samp.client.HubConnection;
import org.astrogrid.samp.hub.ClientSet;
import org.astrogrid.samp.hub.HubClient;

class MetaQueryMessageHandler
extends AbstractMessageHandler {
    private final ClientSet clientSet_;
    private static final String BASE_MTYPE = "query.by-meta";

    public MetaQueryMessageHandler(ClientSet clientSet) {
        super(new String[]{"samp.query.by-meta", "x-samp.query.by-meta"});
        this.clientSet_ = clientSet;
    }

    public Map processCall(HubConnection conn, String senderId, Message msg) {
        String key = (String)msg.getRequiredParam("key");
        String value = (String)msg.getRequiredParam("value");
        HubClient[] clients = this.clientSet_.getClients();
        ArrayList<String> foundList = new ArrayList<String>();
        for (int ic = 0; ic < clients.length; ++ic) {
            HubClient client = clients[ic];
            Metadata meta = client.getMetadata();
            if (meta == null || !value.equals(meta.get(key))) continue;
            foundList.add(client.getId());
        }
        HashMap<String, ArrayList<String>> result = new HashMap<String, ArrayList<String>>();
        result.put("ids", foundList);
        return result;
    }
}

