/*
 * Decompiled with CFR 0.152.
 */
package org.astrogrid.samp.web;

import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.astrogrid.samp.SampUtils;
import org.astrogrid.samp.client.CallableClient;
import org.astrogrid.samp.client.SampException;
import org.astrogrid.samp.web.Callback;
import org.astrogrid.samp.web.ClientCallbackOperation;
import org.astrogrid.samp.xmlrpc.SampXmlRpcClient;
import org.astrogrid.samp.xmlrpc.XmlRpcHubConnection;

class WebHubConnection
extends XmlRpcHubConnection {
    private final String appName_;
    private final String clientKey_;
    private CallWorker callWorker_;
    private static Logger logger_ = Logger.getLogger(WebHubConnection.class.getName());

    public WebHubConnection(SampXmlRpcClient xClient, Map securityMap) throws SampException {
        super(xClient, "samp.webhub.", Collections.singletonList(securityMap));
        Object nameObj = securityMap.get("samp.name");
        this.appName_ = nameObj instanceof String ? (String)nameObj : "??";
        this.clientKey_ = this.getRegInfo().getPrivateKey();
    }

    public Object getClientKey() {
        return this.clientKey_;
    }

    public void setCallable(CallableClient client) throws SampException {
        CallWorker oldWorker = this.callWorker_;
        this.callWorker_ = null;
        if (oldWorker != null) {
            oldWorker.stopped_ = true;
        }
        this.exec("allowReverseCallbacks", new Object[]{SampUtils.encodeBoolean(client != null)});
        if (client != null) {
            CallWorker callWorker = new CallWorker(this, client, this.appName_);
            callWorker.start();
            this.callWorker_ = callWorker;
        }
    }

    private static class CallWorker
    extends Thread {
        private final XmlRpcHubConnection xconn_;
        private final CallableClient client_;
        private final int timeoutSec_ = 600;
        private final long minWaitMillis_ = 5000L;
        private volatile boolean stopped_;

        CallWorker(XmlRpcHubConnection xconn, CallableClient client, String appName) {
            super("Web Profile Callback Puller for " + appName);
            this.xconn_ = xconn;
            this.client_ = client;
            this.setDaemon(true);
        }

        public void run() {
            String stimeout = SampUtils.encodeInt(600);
            while (!this.stopped_) {
                Object result;
                long start = System.currentTimeMillis();
                try {
                    result = this.xconn_.exec("pullCallbacks", new Object[]{stimeout});
                }
                catch (Exception e) {
                    long wait = System.currentTimeMillis() - start;
                    if (wait < 5000L) {
                        this.seriousError(e);
                        break;
                    }
                    logger_.config("pullCallbacks timeout? " + wait / 1000L + "s");
                    break;
                }
                catch (Throwable e) {
                    this.seriousError(e);
                    break;
                }
                if (this.stopped_) continue;
                if (result instanceof List) {
                    List resultList = (List)result;
                    Iterator it = resultList.iterator();
                    while (it.hasNext()) {
                        try {
                            final Callback cb = new Callback((Map)it.next());
                            new Thread("Web Profile Callback"){

                                public void run() {
                                    try {
                                        ClientCallbackOperation.invoke(cb, CallWorker.this.client_);
                                    }
                                    catch (Throwable e) {
                                        logger_.log(Level.WARNING, "Callback failure: " + e.getMessage(), e);
                                    }
                                }
                            }.start();
                        }
                        catch (Throwable e) {
                            logger_.log(Level.WARNING, e.getMessage(), e);
                        }
                    }
                    continue;
                }
                logger_.warning("pullCallbacks result is not a List - ignore");
            }
        }

        private void seriousError(Throwable e) {
            this.stopped_ = true;
            logger_.log(Level.WARNING, "Fatal pullCallbacks error - stopped listening", e);
        }
    }
}

