/*
 * Decompiled with CFR 0.152.
 */
package com.drew.metadata.exif;

import com.drew.lang.annotations.NotNull;
import com.drew.lang.annotations.Nullable;
import com.drew.metadata.TagDescriptor;
import com.drew.metadata.exif.OlympusMakernoteDirectory;

public class OlympusMakernoteDescriptor
extends TagDescriptor<OlympusMakernoteDirectory> {
    public OlympusMakernoteDescriptor(@NotNull OlympusMakernoteDirectory olympusMakernoteDirectory) {
        super(olympusMakernoteDirectory);
    }

    @Override
    @Nullable
    public String getDescription(int n) {
        switch (n) {
            case 512: {
                return this.getSpecialModeDescription();
            }
            case 513: {
                return this.getJpegQualityDescription();
            }
            case 514: {
                return this.getMacroModeDescription();
            }
            case 516: {
                return this.getDigiZoomRatioDescription();
            }
        }
        return super.getDescription(n);
    }

    @Nullable
    public String getDigiZoomRatioDescription() {
        Integer n = ((OlympusMakernoteDirectory)this._directory).getInteger(516);
        if (n == null) {
            return null;
        }
        switch (n) {
            case 0: {
                return "Normal";
            }
            case 2: {
                return "Digital 2x Zoom";
            }
        }
        return "Unknown (" + n + ")";
    }

    @Nullable
    public String getMacroModeDescription() {
        Integer n = ((OlympusMakernoteDirectory)this._directory).getInteger(514);
        if (n == null) {
            return null;
        }
        switch (n) {
            case 0: {
                return "Normal (no macro)";
            }
            case 1: {
                return "Macro";
            }
        }
        return "Unknown (" + n + ")";
    }

    @Nullable
    public String getJpegQualityDescription() {
        Integer n = ((OlympusMakernoteDirectory)this._directory).getInteger(513);
        if (n == null) {
            return null;
        }
        switch (n) {
            case 1: {
                return "SQ";
            }
            case 2: {
                return "HQ";
            }
            case 3: {
                return "SHQ";
            }
        }
        return "Unknown (" + n + ")";
    }

    @Nullable
    public String getSpecialModeDescription() {
        int[] nArray = ((OlympusMakernoteDirectory)this._directory).getIntArray(512);
        if (nArray == null) {
            return null;
        }
        if (nArray.length < 1) {
            return "";
        }
        StringBuilder stringBuilder = new StringBuilder();
        switch (nArray[0]) {
            case 0: {
                stringBuilder.append("Normal picture taking mode");
                break;
            }
            case 1: {
                stringBuilder.append("Unknown picture taking mode");
                break;
            }
            case 2: {
                stringBuilder.append("Fast picture taking mode");
                break;
            }
            case 3: {
                stringBuilder.append("Panorama picture taking mode");
                break;
            }
            default: {
                stringBuilder.append("Unknown picture taking mode");
            }
        }
        if (nArray.length < 2) {
            return stringBuilder.toString();
        }
        stringBuilder.append(" - ");
        switch (nArray[1]) {
            case 0: {
                stringBuilder.append("Unknown sequence number");
                break;
            }
            case 1: {
                stringBuilder.append("1st in a sequence");
                break;
            }
            case 2: {
                stringBuilder.append("2nd in a sequence");
                break;
            }
            case 3: {
                stringBuilder.append("3rd in a sequence");
                break;
            }
            default: {
                stringBuilder.append(nArray[1]);
                stringBuilder.append("th in a sequence");
            }
        }
        if (nArray.length < 3) {
            return stringBuilder.toString();
        }
        stringBuilder.append(" - ");
        switch (nArray[2]) {
            case 1: {
                stringBuilder.append("Left to right panorama direction");
                break;
            }
            case 2: {
                stringBuilder.append("Right to left panorama direction");
                break;
            }
            case 3: {
                stringBuilder.append("Bottom to top panorama direction");
                break;
            }
            case 4: {
                stringBuilder.append("Top to bottom panorama direction");
            }
        }
        return stringBuilder.toString();
    }
}

