/*
 * Decompiled with CFR 0.152.
 */
package com.drew.metadata.photoshop;

import com.drew.lang.BufferBoundsException;
import com.drew.lang.BufferReader;
import com.drew.lang.ByteArrayReader;
import com.drew.lang.annotations.NotNull;
import com.drew.metadata.Metadata;
import com.drew.metadata.MetadataReader;
import com.drew.metadata.iptc.IptcReader;
import com.drew.metadata.photoshop.PhotoshopDirectory;

public class PhotoshopReader
implements MetadataReader {
    @Override
    public void extract(@NotNull BufferReader bufferReader, @NotNull Metadata metadata) {
        PhotoshopDirectory photoshopDirectory = metadata.getOrCreateDirectory(PhotoshopDirectory.class);
        int n = 0;
        try {
            n = bufferReader.getString(0, 13).equals("Photoshop 3.0") ? 14 : 0;
        }
        catch (BufferBoundsException bufferBoundsException) {
            photoshopDirectory.addError("Unable to read header");
            return;
        }
        while ((long)n < bufferReader.getLength()) {
            try {
                int n2 = bufferReader.getUInt16(n += 4);
                int n3 = bufferReader.getUInt16(n += 2);
                if (n3 < 0 || (long)(n3 + (n += 2)) > bufferReader.getLength()) {
                    return;
                }
                if ((n += n3) % 2 != 0) {
                    ++n;
                }
                int n4 = bufferReader.getInt32(n);
                byte[] byArray = bufferReader.getBytes(n += 4, n4);
                if ((n += n4) % 2 != 0) {
                    ++n;
                }
                photoshopDirectory.setByteArray(n2, byArray);
                if (n2 == 1028) {
                    new IptcReader().extract(new ByteArrayReader(byArray), metadata);
                }
                if (n2 < 4000 || n2 > 4999) continue;
                PhotoshopDirectory._tagNameMap.put(n2, String.format("Plug-in %d Data", n2 - 4000 + 1));
            }
            catch (BufferBoundsException bufferBoundsException) {
                photoshopDirectory.addError(bufferBoundsException.getMessage());
                return;
            }
        }
    }
}

