/*
 * Decompiled with CFR 0.152.
 */
package ucar.jpeg.jj2000.j2k.image.output;

import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import ucar.jpeg.jj2000.j2k.image.BlkImgDataSrc;
import ucar.jpeg.jj2000.j2k.image.DataBlkInt;
import ucar.jpeg.jj2000.j2k.image.output.ImgWriter;
import ucar.jpeg.jj2000.j2k.util.FacilityManager;

public class ImgWriterPGM
extends ImgWriter {
    private int levShift;
    private RandomAccessFile out;
    private int c;
    private int fb;
    private DataBlkInt db = new DataBlkInt();
    private int offset;
    private byte[] buf;

    public ImgWriterPGM(File out, BlkImgDataSrc imgSrc, int c) throws IOException {
        if (c < 0 || c >= imgSrc.getNumComps()) {
            throw new IllegalArgumentException("Invalid number of components");
        }
        if (imgSrc.getNomRangeBits(c) > 8) {
            FacilityManager.getMsgLogger().println("Warning: Component " + c + " has nominal bitdepth " + imgSrc.getNomRangeBits(c) + ". Pixel values will be down-shifted to fit bitdepth of 8 for PGM file", 8, 8);
        }
        if (out.exists() && !out.delete()) {
            throw new IOException("Could not reset file");
        }
        this.out = new RandomAccessFile(out, "rw");
        this.src = imgSrc;
        this.c = c;
        this.w = imgSrc.getImgWidth();
        this.h = imgSrc.getImgHeight();
        this.fb = imgSrc.getFixedPoint(c);
        this.levShift = 1 << imgSrc.getNomRangeBits(c) - 1;
        this.writeHeaderInfo();
    }

    public ImgWriterPGM(String fname, BlkImgDataSrc imgSrc, int c) throws IOException {
        this(new File(fname), imgSrc, c);
    }

    @Override
    public void close() throws IOException {
        if (this.out.length() != (long)(this.w * this.h + this.offset)) {
            this.out.seek(this.out.length());
            for (int i = this.offset + this.w * this.h - (int)this.out.length(); i > 0; --i) {
                this.out.writeByte(0);
            }
        }
        this.out.close();
        this.src = null;
        this.out = null;
        this.db = null;
    }

    @Override
    public void flush() throws IOException {
        this.buf = null;
    }

    @Override
    public void write(int ulx, int uly, int w, int h2) throws IOException {
        int fracbits = this.fb;
        this.db.ulx = ulx;
        this.db.uly = uly;
        this.db.w = w;
        this.db.h = h2;
        int tOffx = this.src.getCompULX(this.c) - (int)Math.ceil((double)this.src.getImgULX() / (double)this.src.getCompSubsX(this.c));
        int tOffy = this.src.getCompULY(this.c) - (int)Math.ceil((double)this.src.getImgULY() / (double)this.src.getCompSubsY(this.c));
        if (this.db.data != null && this.db.data.length < w * h2) {
            this.db.data = null;
        }
        do {
            this.db = (DataBlkInt)this.src.getInternCompData(this.db, this.c);
        } while (this.db.progressive);
        int maxVal = (1 << this.src.getNomRangeBits(this.c)) - 1;
        int downShift = this.src.getNomRangeBits(this.c) - 8;
        if (downShift < 0) {
            downShift = 0;
        }
        if (this.buf == null || this.buf.length < w) {
            this.buf = new byte[w];
        }
        for (int i = 0; i < h2; ++i) {
            int tmp;
            int j;
            int k;
            this.out.seek(this.offset + this.w * (uly + tOffy + i) + ulx + tOffx);
            if (fracbits == 0) {
                k = this.db.offset + i * this.db.scanw + w - 1;
                j = w - 1;
                while (j >= 0) {
                    tmp = this.db.data[k] + this.levShift;
                    this.buf[j] = (byte)((tmp < 0 ? 0 : (tmp > maxVal ? maxVal : tmp)) >> downShift);
                    --j;
                    --k;
                }
            } else {
                k = this.db.offset + i * this.db.scanw + w - 1;
                j = w - 1;
                while (j >= 0) {
                    tmp = (this.db.data[k] >> fracbits) + this.levShift;
                    this.buf[j] = (byte)((tmp < 0 ? 0 : (tmp > maxVal ? maxVal : tmp)) >> downShift);
                    --j;
                    --k;
                }
            }
            this.out.write(this.buf, 0, w);
        }
    }

    @Override
    public void write() throws IOException {
        int tIdx = this.src.getTileIdx();
        int tw = this.src.getTileCompWidth(tIdx, this.c);
        int th = this.src.getTileCompHeight(tIdx, this.c);
        for (int i = 0; i < th; i += 64) {
            this.write(0, i, tw, th - i < 64 ? th - i : 64);
        }
    }

    private void writeHeaderInfo() throws IOException {
        int i;
        this.out.writeByte(80);
        this.out.write(53);
        this.out.write(10);
        this.offset = 3;
        String val = String.valueOf(this.w);
        byte[] byteVals = val.getBytes();
        for (i = 0; i < byteVals.length; ++i) {
            this.out.writeByte(byteVals[i]);
            ++this.offset;
        }
        this.out.write(32);
        ++this.offset;
        val = String.valueOf(this.h);
        byteVals = val.getBytes();
        for (i = 0; i < byteVals.length; ++i) {
            this.out.writeByte(byteVals[i]);
            ++this.offset;
        }
        this.out.write(10);
        this.out.write(50);
        this.out.write(53);
        this.out.write(53);
        this.out.write(10);
        this.offset += 5;
    }

    public String toString() {
        return "ImgWriterPGM: WxH = " + this.w + "x" + this.h + ", Component=" + this.c + "\nUnderlying RandomAccessFile:\n" + this.out.toString();
    }
}

