/*
 * Decompiled with CFR 0.152.
 */
package ucar.mcidas;

import ucar.mcidas.AREAnav;

public final class MSGnav
extends AREAnav {
    private boolean isEastPositive = true;
    final double NOMORB = 42164.0;
    final double EARTH_RADIUS = 6378.169;
    int itype;
    double h;
    double a;
    double rp;
    double cdr;
    double crd;
    double rs;
    double yk;
    double deltax;
    double deltay;
    int[] ioff = new int[3];
    int count = 0;
    double sublon = 0.0;

    public MSGnav(int[] iparms) throws IllegalArgumentException {
        if (iparms[0] != 1297303328) {
            throw new IllegalArgumentException("Invalid navigation type" + iparms[0]);
        }
        this.itype = 2;
        this.h = 35785.831;
        this.rs = 6378.169 + this.h;
        this.yk = this.rs / 6378.169;
        this.a = 0.003367003367003367;
        this.rp = 6378.169 / (1.0 + this.a);
        this.crd = 57.29577951308232;
        this.cdr = Math.PI / 180;
        this.sublon = (double)iparms[1] / 10000.0;
        if (this.isEastPositive) {
            this.sublon = -this.sublon;
        }
        this.deltax = 0.004803879310344828;
        this.deltay = 0.004803879310344828;
    }

    @Override
    public double[][] toLatLon(double[][] linele) {
        double[][] imglinele;
        int number = linele[0].length;
        double[][] latlon = imglinele = this.areaCoordToImageCoord(linele);
        for (int point = 0; point < number; ++point) {
            double xlon;
            double xlat;
            double tany;
            double v2;
            if (Double.isNaN(imglinele[1][point]) || Double.isNaN(imglinele[0][point])) continue;
            double xlin = 3713.0 - imglinele[1][point] / 3.0;
            double xele = 3713.0 - imglinele[0][point] / 3.0;
            double xr = xele - 1856.0;
            double yr = xlin - 1856.0;
            xr = xr * this.deltax * this.cdr;
            yr = yr * this.deltay * this.cdr;
            double tanx = Math.tan(xr);
            double v1 = 1.0 + tanx * tanx;
            if (this.yk * this.yk - (this.yk * this.yk - 1.0) * v1 * (v2 = 1.0 + (tany = Math.tan(yr)) * tany * ((1.0 + this.a) * (1.0 + this.a))) <= 0.0) {
                xlat = Double.NaN;
                xlon = Double.NaN;
            } else {
                double vmu = (this.rs - 6378.169 * Math.sqrt(this.yk * this.yk - (this.yk * this.yk - 1.0) * v1 * v2)) / (v1 * v2);
                double xt = this.rs - vmu;
                double yt = -vmu * tanx;
                double zt = vmu * tany / Math.cos(xr);
                double teta = Math.asin(zt / this.rp);
                xlat = Math.atan(Math.tan(teta) * 6378.169 / this.rp) * this.crd;
                xlon = Math.atan(yt / xt) * this.crd;
            }
            xlon += this.sublon;
            if (!this.isEastPositive) {
                xlon = -xlon;
            }
            latlon[0][point] = xlat;
            latlon[1][point] = xlon;
        }
        return latlon;
    }

    @Override
    public double[][] toLinEle(double[][] latlon) {
        int number = latlon[0].length;
        double[][] linele = new double[2][number];
        for (int point = 0; point < number; ++point) {
            double xele;
            double xlin;
            double r2;
            if (Double.isNaN(latlon[0][point]) || Double.isNaN(latlon[1][point])) {
                linele[1][point] = Double.NaN;
                linele[0][point] = Double.NaN;
                continue;
            }
            double xlat = latlon[0][point];
            double xlon = this.isEastPositive ? latlon[1][point] : -latlon[1][point];
            double xfi = xlat * this.cdr;
            double xla = (xlon -= this.sublon) * this.cdr;
            double rom = 6378.169 * this.rp / Math.sqrt(this.rp * this.rp * Math.cos(xfi) * Math.cos(xfi) + 4.0681039792560995E7 * Math.sin(xfi) * Math.sin(xfi));
            double y = Math.sqrt(this.h * this.h + rom * rom - 2.0 * this.h * rom * Math.cos(xfi) * Math.cos(xla));
            double r1 = y * y + rom * rom;
            if (r1 > (r2 = this.h * this.h)) {
                xlin = Double.NaN;
                xele = Double.NaN;
                linele[1][point] = Double.NaN;
                linele[0][point] = Double.NaN;
                continue;
            }
            double teta = Math.atan(this.rp / 6378.169 * Math.tan(xfi));
            double xt = 6378.169 * Math.cos(teta) * Math.cos(xla);
            double yt = 6378.169 * Math.cos(teta) * Math.sin(xla);
            double zt = this.rp * Math.sin(teta);
            double px = Math.atan(yt / (xt - this.rs));
            double py = Math.atan(-zt / (xt - this.rs) * Math.cos(px));
            double xr = (px *= this.crd) / this.deltax;
            double yr = (py *= this.crd) / this.deltay;
            xele = 1857.0 - xr;
            xlin = 1857.0 - yr;
            xlin = 3713.0 - xlin;
            xele = 3713.0 - xele;
            xlin = 11136.0 - 3.0 * xlin + 3.0;
            xele = 11136.0 - 3.0 * xele + 3.0;
            linele[1][point] = xlin - 1.0;
            linele[0][point] = xele - 1.0;
        }
        return this.imageCoordToAreaCoord(linele, linele);
    }

    @Override
    public float[][] toLatLon(float[][] linele) {
        float[][] imglinele;
        int number = linele[0].length;
        float[][] latlon = imglinele = this.areaCoordToImageCoord(linele);
        for (int point = 0; point < number; ++point) {
            double xlon;
            double xlat;
            double tany;
            double v2;
            if (Float.isNaN(imglinele[1][point]) || Float.isNaN(imglinele[0][point])) continue;
            double xlin = 3713.0 - (double)imglinele[1][point] / 3.0;
            double xele = 3713.0 - (double)imglinele[0][point] / 3.0;
            double xr = xele - 1856.0;
            double yr = xlin - 1856.0;
            xr = xr * this.deltax * this.cdr;
            yr = yr * this.deltay * this.cdr;
            double tanx = Math.tan(xr);
            double v1 = 1.0 + tanx * tanx;
            if (this.yk * this.yk - (this.yk * this.yk - 1.0) * v1 * (v2 = 1.0 + (tany = Math.tan(yr)) * tany * ((1.0 + this.a) * (1.0 + this.a))) <= 0.0) {
                xlat = Double.NaN;
                xlon = Double.NaN;
            } else {
                double vmu = (this.rs - 6378.169 * Math.sqrt(this.yk * this.yk - (this.yk * this.yk - 1.0) * v1 * v2)) / (v1 * v2);
                double xt = this.rs - vmu;
                double yt = -vmu * tanx;
                double zt = vmu * tany / Math.cos(xr);
                double teta = Math.asin(zt / this.rp);
                xlat = Math.atan(Math.tan(teta) * 6378.169 / this.rp) * this.crd;
                xlon = Math.atan(yt / xt) * this.crd;
            }
            xlon += this.sublon;
            if (!this.isEastPositive) {
                xlon = -xlon;
            }
            latlon[0][point] = (float)xlat;
            latlon[1][point] = (float)xlon;
        }
        return latlon;
    }

    @Override
    public float[][] toLinEle(float[][] latlon) {
        int number = latlon[0].length;
        float[][] linele = new float[2][number];
        for (int point = 0; point < number; ++point) {
            double xele;
            double xlin;
            double r2;
            if (Float.isNaN(latlon[0][point]) || Float.isNaN(latlon[1][point])) {
                linele[1][point] = Float.NaN;
                linele[0][point] = Float.NaN;
                continue;
            }
            double xlat = latlon[0][point];
            double xlon = this.isEastPositive ? (double)latlon[1][point] : (double)(-latlon[1][point]);
            double xfi = xlat * this.cdr;
            double xla = (xlon -= this.sublon) * this.cdr;
            double rom = 6378.169 * this.rp / Math.sqrt(this.rp * this.rp * Math.cos(xfi) * Math.cos(xfi) + 4.0681039792560995E7 * Math.sin(xfi) * Math.sin(xfi));
            double y = Math.sqrt(this.h * this.h + rom * rom - 2.0 * this.h * rom * Math.cos(xfi) * Math.cos(xla));
            double r1 = y * y + rom * rom;
            if (r1 > (r2 = this.h * this.h)) {
                xlin = Double.NaN;
                xele = Double.NaN;
                linele[1][point] = Float.NaN;
                linele[0][point] = Float.NaN;
                continue;
            }
            double teta = Math.atan(this.rp / 6378.169 * Math.tan(xfi));
            double xt = 6378.169 * Math.cos(teta) * Math.cos(xla);
            double yt = 6378.169 * Math.cos(teta) * Math.sin(xla);
            double zt = this.rp * Math.sin(teta);
            double px = Math.atan(yt / (xt - this.rs));
            double py = Math.atan(-zt / (xt - this.rs) * Math.cos(px));
            double xr = (px *= this.crd) / this.deltax;
            double yr = (py *= this.crd) / this.deltay;
            xele = 1857.0 - xr;
            xlin = 1857.0 - yr;
            xlin = 3713.0 - xlin;
            xele = 3713.0 - xele;
            xlin = 11136.0 - 3.0 * xlin + 3.0;
            xele = 11136.0 - 3.0 * xele + 3.0;
            linele[1][point] = (float)(xlin - 1.0);
            linele[0][point] = (float)(xele - 1.0);
        }
        return this.imageCoordToAreaCoord(linele, linele);
    }
}

