/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.jni.netcdf;

import com.google.common.collect.ImmutableMap;
import com.sun.jna.Native;
import com.sun.jna.Platform;
import com.sun.jna.Pointer;
import com.sun.jna.ptr.IntByReference;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Formatter;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ucar.ma2.Array;
import ucar.ma2.ArrayStructure;
import ucar.ma2.ArrayStructureBB;
import ucar.ma2.DataType;
import ucar.ma2.IndexIterator;
import ucar.ma2.InvalidRangeException;
import ucar.ma2.Range;
import ucar.ma2.Section;
import ucar.ma2.StructureData;
import ucar.ma2.StructureDataDeep;
import ucar.ma2.StructureMembers;
import ucar.nc2.Attribute;
import ucar.nc2.Dimension;
import ucar.nc2.EnumTypedef;
import ucar.nc2.Group;
import ucar.nc2.NetcdfFile;
import ucar.nc2.NetcdfFileWriter;
import ucar.nc2.NetcdfFiles;
import ucar.nc2.Structure;
import ucar.nc2.Variable;
import ucar.nc2.constants.DataFormatType;
import ucar.nc2.ffi.netcdf.NetcdfClibrary;
import ucar.nc2.iosp.AbstractIOServiceProvider;
import ucar.nc2.iosp.IOServiceProviderWriter;
import ucar.nc2.iosp.IospHelper;
import ucar.nc2.iosp.NCheader;
import ucar.nc2.iosp.hdf4.HdfEos;
import ucar.nc2.jni.netcdf.Nc4prototypes;
import ucar.nc2.jni.netcdf.SizeT;
import ucar.nc2.jni.netcdf.SizeTByReference;
import ucar.nc2.util.CancelTask;
import ucar.nc2.util.DebugFlags;
import ucar.nc2.util.EscapeStrings;
import ucar.nc2.write.Nc4Chunking;
import ucar.nc2.write.Nc4ChunkingDefault;
import ucar.unidata.io.RandomAccessFile;

@Deprecated
public class Nc4Iosp
extends AbstractIOServiceProvider
implements IOServiceProviderWriter {
    private static Logger log = LoggerFactory.getLogger(Nc4Iosp.class);
    private static Logger startupLog = LoggerFactory.getLogger("serverStartup");
    public static final boolean DEBUG = false;
    public static int NC_TURN_OFF_LOGGING = -1;
    public static final String TRANSLATECONTROL = "ucar.translate";
    public static final String TRANSLATE_NONE = "none";
    public static final String TRANSLATE_NC4 = "nc4";
    private static Nc4prototypes nc4 = NetcdfClibrary.getForeignFunctionInterface();
    public static final String UCARTAGOPAQUE = "_edu.ucar.opaque.size";
    public static final String UCARTAGVLEN = "_edu.ucar.isvlen";
    public static final String UCARTAGORIGTYPE = "_edu.ucar.orig.type";
    private static final boolean debugCompound = false;
    private static final boolean debugCompoundAtt = false;
    private static final boolean debugDim = false;
    private static final boolean debugUserTypes = false;
    private static final boolean debugWrite = false;
    private static final boolean transcodeStrings = Charset.defaultCharset() != StandardCharsets.UTF_8;
    private static boolean useHdfEos = true;
    private NetcdfFileWriter.Version version;
    private boolean fill = true;
    private int ncid = -1;
    private int format;
    private boolean isClosed;
    private Map<Integer, UserType> userTypes = new HashMap<Integer, UserType>();
    private Map<Group, Integer> groupHash = new HashMap<Group, Integer>();
    private Nc4Chunking chunker = new Nc4ChunkingDefault();
    private boolean isEos;
    private boolean markreserved;

    @Deprecated
    public static void setLibraryAndPath(String jnaPath, String libName) {
        NetcdfClibrary.setLibraryNameAndPath(jnaPath, libName);
    }

    @Deprecated
    public static synchronized boolean isClibraryPresent() {
        return NetcdfClibrary.isLibraryPresent();
    }

    @Deprecated
    public static synchronized Nc4prototypes getCLibrary() {
        return nc4;
    }

    @Deprecated
    public static synchronized int setLogLevel(int level) {
        return NetcdfClibrary.setLogLevel(level);
    }

    public static void useHdfEos(boolean val) {
        useHdfEos = val;
    }

    public static void setDebugFlags(DebugFlags flags) {
    }

    public Nc4Iosp() {
        this(NetcdfFileWriter.Version.netcdf4);
    }

    public Nc4Iosp(NetcdfFileWriter.Version version) {
        this.version = version;
    }

    public void setChunker(Nc4Chunking chunker) {
        if (chunker != null) {
            this.chunker = chunker;
        }
    }

    @Override
    public boolean isValidFile(RandomAccessFile raf) throws IOException {
        int format = NCheader.checkFileType(raf);
        boolean valid = false;
        switch (format) {
            case 3: 
            case 5: {
                valid = true;
                break;
            }
        }
        if (valid) {
            if (Nc4Iosp.isClibraryPresent()) {
                return true;
            }
            log.debug("File is valid but the NetCDF-4 native library isn't installed: {}", (Object)raf.getLocation());
        }
        return false;
    }

    @Override
    public String getFileTypeDescription() {
        return "Netcdf/JNI: " + (Object)((Object)this.version);
    }

    @Override
    public String getFileTypeId() {
        if (this.isEos) {
            return "HDF5-EOS";
        }
        return this.version.isNetdf4format() ? DataFormatType.NETCDF4.getDescription() : DataFormatType.HDF5.getDescription();
    }

    @Override
    public String getFileTypeVersion() {
        return this.ncfile.getRootGroup().findAttributeString("_NCProperties", "N/A");
    }

    @Override
    public void close() throws IOException {
        if (this.isClosed) {
            return;
        }
        if (this.ncid < 0) {
            return;
        }
        int ret = nc4.nc_close(this.ncid);
        if (ret != 0) {
            throw new IOException(ret + ": " + nc4.nc_strerror(ret));
        }
        this.isClosed = true;
    }

    @Override
    public void open(RandomAccessFile raf, NetcdfFile ncfile, CancelTask cancelTask) throws IOException {
        super.open(raf, ncfile, cancelTask);
        this._open(raf, ncfile, true);
    }

    @Override
    public void openForWriting(RandomAccessFile raf, NetcdfFile ncfile, CancelTask cancelTask) throws IOException {
        this.ncfile = ncfile;
        this._open(raf, ncfile, false);
    }

    private void _open(RandomAccessFile raf, NetcdfFile ncfile, boolean readOnly) throws IOException {
        if (!Nc4Iosp.isClibraryPresent()) {
            throw new UnsupportedOperationException("Couldn't load NetCDF C library (see log for details).");
        }
        if (raf != null) {
            raf.close();
        }
        String location = NetcdfFiles.canonicalizeUriString(ncfile.getLocation());
        log.debug("open {}", (Object)location);
        IntByReference ncidp = new IntByReference();
        int ret = nc4.nc_open(location, readOnly ? 0 : 1, ncidp);
        if (ret != 0) {
            throw new IOException(ret + ": " + nc4.nc_strerror(ret));
        }
        this.isClosed = false;
        this.ncid = ncidp.getValue();
        IntByReference formatp = new IntByReference();
        ret = nc4.nc_inq_format(this.ncid, formatp);
        if (ret != 0) {
            throw new IOException(ret + ": " + nc4.nc_strerror(ret));
        }
        this.format = formatp.getValue();
        log.debug("open {} id={} format={}", ncfile.getLocation(), this.ncid, this.format);
        this.makeGroup(new Group4(this.ncid, ncfile.getRootGroup(), null));
        Group eosInfo = ncfile.getRootGroup().findGroupLocal("HDFEOS_INFORMATION");
        if (eosInfo != null && useHdfEos) {
            this.isEos = HdfEos.amendFromODL(ncfile, eosInfo);
        }
        ncfile.finish();
    }

    private void makeGroup(Group4 g4) throws IOException {
        this.groupHash.put(g4.g, g4.grpid);
        this.makeDimensions(g4);
        this.makeUserTypes(g4.grpid, g4.g);
        IntByReference ngattsp = new IntByReference();
        int ret = nc4.nc_inq_natts(g4.grpid, ngattsp);
        if (ret != 0) {
            throw new IOException(ret + ": " + nc4.nc_strerror(ret));
        }
        List<Attribute> gatts = this.makeAttributes(g4.grpid, -1, ngattsp.getValue(), null);
        for (Attribute att : gatts) {
            this.ncfile.addAttribute(g4.g, att);
            log.debug(" add Global Attribute {}", (Object)att);
        }
        this.makeVariables(g4);
        if (this.format == 3) {
            IntByReference numgrps = new IntByReference();
            ret = nc4.nc_inq_grps(g4.grpid, numgrps, null);
            if (ret != 0) {
                throw new IOException(ret + ": " + nc4.nc_strerror(ret));
            }
            int[] group_ids = new int[numgrps.getValue()];
            ret = nc4.nc_inq_grps(g4.grpid, numgrps, group_ids);
            if (ret != 0) {
                throw new IOException(ret + ": " + nc4.nc_strerror(ret));
            }
            for (int group_id : group_ids) {
                byte[] name = new byte[257];
                ret = nc4.nc_inq_grpname(group_id, name);
                if (ret != 0) {
                    throw new IOException(ret + ": " + nc4.nc_strerror(ret));
                }
                Group child = new Group(this.ncfile, g4.g, this.makeString(name));
                g4.g.addGroup(child);
                this.makeGroup(new Group4(group_id, child, g4));
            }
        }
    }

    private void makeDimensions(Group4 g4) throws IOException {
        IntByReference numDimsInGoup_p = new IntByReference();
        int ret = nc4.nc_inq_ndims(g4.grpid, numDimsInGoup_p);
        if (ret != 0) {
            throw new IOException(ret + ": " + nc4.nc_strerror(ret));
        }
        IntByReference numDimidsInGroup_p = new IntByReference();
        int[] dimIdsInGroup = new int[numDimsInGoup_p.getValue()];
        ret = nc4.nc_inq_dimids(g4.grpid, numDimidsInGroup_p, dimIdsInGroup, 0);
        if (ret != 0) {
            throw new IOException(ret + ": " + nc4.nc_strerror(ret));
        }
        assert (numDimsInGoup_p.getValue() == numDimidsInGroup_p.getValue()) : String.format("Number of dimensions in group (%s) differed from number of dimension IDs in group (%s).", numDimsInGoup_p.getValue(), numDimidsInGroup_p.getValue());
        IntByReference numUnlimitedDimsInGroup_p = new IntByReference();
        ret = nc4.nc_inq_unlimdims(g4.grpid, numUnlimitedDimsInGroup_p, null);
        if (ret != 0) {
            throw new IOException(ret + ": " + nc4.nc_strerror(ret));
        }
        int[] unlimitedDimIdsInGroup = new int[numUnlimitedDimsInGroup_p.getValue()];
        ret = nc4.nc_inq_unlimdims(g4.grpid, numUnlimitedDimsInGroup_p, unlimitedDimIdsInGroup);
        if (ret != 0) {
            throw new IOException(ret + ": " + nc4.nc_strerror(ret));
        }
        Arrays.sort(unlimitedDimIdsInGroup);
        for (int dimId : dimIdsInGroup) {
            byte[] dimNameBytes = new byte[257];
            SizeTByReference dimLength_p = new SizeTByReference();
            ret = nc4.nc_inq_dim(g4.grpid, dimId, dimNameBytes, dimLength_p);
            if (ret != 0) {
                throw new IOException(ret + ": " + nc4.nc_strerror(ret));
            }
            String dimName = this.makeString(dimNameBytes);
            boolean isUnlimited = Arrays.binarySearch(unlimitedDimIdsInGroup, dimId) >= 0;
            Dimension dimension = new Dimension(dimName, dimLength_p.getValue().intValue(), true, isUnlimited, false);
            this.ncfile.addDimension(g4.g, dimension);
            log.debug("add Dimension {} ({})", (Object)dimension, (Object)dimId);
        }
    }

    private void updateDimensions(Group g2) throws IOException {
        int[] unlimdimids;
        IntByReference nunlimdimsp;
        int grpid = this.groupHash.get(g2);
        int ret = nc4.nc_inq_unlimdims(grpid, nunlimdimsp = new IntByReference(), unlimdimids = new int[1024]);
        if (ret != 0) {
            throw new IOException(ret + ": " + nc4.nc_strerror(ret));
        }
        int ndims = nunlimdimsp.getValue();
        for (int i = 0; i < ndims; ++i) {
            byte[] name = new byte[257];
            SizeTByReference lenp = new SizeTByReference();
            ret = nc4.nc_inq_dim(grpid, unlimdimids[i], name, lenp);
            if (ret != 0) {
                throw new IOException(ret + ": " + nc4.nc_strerror(ret));
            }
            String dname = this.makeString(name);
            Dimension d = g2.findDimension(dname);
            if (d == null) {
                throw new IllegalStateException("Cant find dimension " + dname);
            }
            if (!d.isUnlimited()) {
                throw new IllegalStateException("dimension " + dname + " should be unlimited");
            }
            int len = lenp.getValue().intValue();
            if (len == d.getLength()) continue;
            d.setLength(len);
            for (Variable var : g2.getVariables()) {
                if (!this.contains(var.getDimensions(), d)) continue;
                var.resetShape();
                var.invalidateCache();
            }
        }
        for (Group child : g2.getGroups()) {
            this.updateDimensions(child);
        }
    }

    private boolean contains(List<Dimension> dims, Dimension want) {
        for (Dimension have : dims) {
            if (!have.getShortName().equals(want.getShortName())) continue;
            return true;
        }
        return false;
    }

    private String[] transcodeString(String[] systemStrings) {
        return (String[])Arrays.stream(systemStrings).map(systemString -> {
            byte[] byteArray = systemString.getBytes(Charset.defaultCharset());
            return new String(byteArray, StandardCharsets.UTF_8);
        }).toArray(String[]::new);
    }

    private String makeString(byte[] b) {
        int count;
        for (count = 0; count < b.length && b[count] != 0; ++count) {
        }
        if (count < b.length / 2) {
            byte[] bb = new byte[count];
            System.arraycopy(b, 0, bb, 0, count);
            b = bb;
        }
        return new String(b, 0, count, StandardCharsets.UTF_8);
    }

    private String makeAttString(byte[] b) {
        int count;
        for (count = 0; count < b.length && b[count] != 0; ++count) {
        }
        return new String(b, 0, count, StandardCharsets.UTF_8);
    }

    private List<Attribute> makeAttributes(int grpid, int varid, int natts, Variable v) throws IOException {
        ArrayList<Attribute> result = new ArrayList<Attribute>(natts);
        block28: for (int attnum = 0; attnum < natts; ++attnum) {
            IntByReference xtypep;
            byte[] name = new byte[257];
            int ret = nc4.nc_inq_attname(grpid, varid, attnum, name);
            if (ret != 0) {
                throw new IOException(nc4.nc_strerror(ret) + " varid=" + varid + " attnum=" + attnum);
            }
            String attname = this.makeString(name);
            ret = nc4.nc_inq_atttype(grpid, varid, attname, xtypep = new IntByReference());
            if (ret != 0) {
                throw new IOException(nc4.nc_strerror(ret) + " varid=" + varid + "attnum=" + attnum);
            }
            int type = xtypep.getValue();
            SizeTByReference lenp = new SizeTByReference();
            ret = nc4.nc_inq_attlen(grpid, varid, attname, lenp);
            if (ret != 0) {
                throw new IOException(ret + ": " + nc4.nc_strerror(ret));
            }
            int len = lenp.getValue().intValue();
            if (len == 0) {
                Attribute att;
                switch (type) {
                    case 1: {
                        att = new Attribute(attname, DataType.BYTE);
                        break;
                    }
                    case 7: {
                        att = new Attribute(attname, DataType.UBYTE);
                        break;
                    }
                    case 2: {
                        if (this.format == 4 || this.format == 3) {
                            att = new Attribute(attname, DataType.STRING);
                            break;
                        }
                        att = new Attribute(attname, "");
                        break;
                    }
                    case 6: {
                        att = new Attribute(attname, DataType.DOUBLE);
                        break;
                    }
                    case 5: {
                        att = new Attribute(attname, DataType.FLOAT);
                        break;
                    }
                    case 4: {
                        att = new Attribute(attname, DataType.INT);
                        break;
                    }
                    case 9: {
                        att = new Attribute(attname, DataType.UINT);
                        break;
                    }
                    case 11: {
                        att = new Attribute(attname, DataType.ULONG);
                        break;
                    }
                    case 10: {
                        att = new Attribute(attname, DataType.LONG);
                        break;
                    }
                    case 8: {
                        att = new Attribute(attname, DataType.USHORT);
                        break;
                    }
                    case 3: {
                        att = new Attribute(attname, DataType.SHORT);
                        break;
                    }
                    case 12: {
                        att = new Attribute(attname, DataType.STRING);
                        break;
                    }
                    default: {
                        log.warn("Unsupported attribute data type == " + type);
                        continue block28;
                    }
                }
                result.add(att);
                continue;
            }
            Array values = null;
            switch (type) {
                case 7: {
                    byte[] valbu = new byte[len];
                    ret = nc4.nc_get_att_uchar(grpid, varid, attname, valbu);
                    if (ret != 0) {
                        throw new IOException(ret + ": " + nc4.nc_strerror(ret));
                    }
                    values = Array.factory(DataType.UBYTE, new int[]{len}, (Object)valbu);
                    break;
                }
                case 1: {
                    byte[] valb = new byte[len];
                    ret = nc4.nc_get_att_schar(grpid, varid, attname, valb);
                    if (ret != 0) {
                        throw new IOException(ret + ": " + nc4.nc_strerror(ret));
                    }
                    values = Array.factory(DataType.BYTE, new int[]{len}, (Object)valb);
                    break;
                }
                case 2: {
                    byte[] text = new byte[len];
                    ret = nc4.nc_get_att_text(grpid, varid, attname, text);
                    if (ret != 0) {
                        throw new IOException(ret + ": " + nc4.nc_strerror(ret));
                    }
                    Attribute att = new Attribute(attname, this.makeAttString(text));
                    result.add(att);
                    break;
                }
                case 6: {
                    double[] vald = new double[len];
                    ret = nc4.nc_get_att_double(grpid, varid, attname, vald);
                    if (ret != 0) {
                        throw new IOException(ret + ": " + nc4.nc_strerror(ret));
                    }
                    values = Array.factory(DataType.DOUBLE, new int[]{len}, (Object)vald);
                    break;
                }
                case 5: {
                    float[] valf = new float[len];
                    ret = nc4.nc_get_att_float(grpid, varid, attname, valf);
                    if (ret != 0) {
                        throw new IOException(ret + ": " + nc4.nc_strerror(ret));
                    }
                    values = Array.factory(DataType.FLOAT, new int[]{len}, (Object)valf);
                    break;
                }
                case 9: {
                    int[] valiu = new int[len];
                    ret = nc4.nc_get_att_uint(grpid, varid, attname, valiu);
                    if (ret != 0) {
                        throw new IOException(ret + ": " + nc4.nc_strerror(ret));
                    }
                    values = Array.factory(DataType.UINT, new int[]{len}, (Object)valiu);
                    break;
                }
                case 4: {
                    int[] vali = new int[len];
                    ret = nc4.nc_get_att_int(grpid, varid, attname, vali);
                    if (ret != 0) {
                        throw new IOException(ret + ": " + nc4.nc_strerror(ret));
                    }
                    values = Array.factory(DataType.INT, new int[]{len}, (Object)vali);
                    break;
                }
                case 11: {
                    long[] vallu = new long[len];
                    ret = nc4.nc_get_att_ulonglong(grpid, varid, attname, vallu);
                    if (ret != 0) {
                        throw new IOException(ret + ": " + nc4.nc_strerror(ret));
                    }
                    values = Array.factory(DataType.ULONG, new int[]{len}, (Object)vallu);
                    break;
                }
                case 10: {
                    long[] vall = new long[len];
                    ret = nc4.nc_get_att_longlong(grpid, varid, attname, vall);
                    if (ret != 0) {
                        throw new IOException(ret + ": " + nc4.nc_strerror(ret));
                    }
                    values = Array.factory(DataType.LONG, new int[]{len}, (Object)vall);
                    break;
                }
                case 8: {
                    short[] valsu = new short[len];
                    ret = nc4.nc_get_att_ushort(grpid, varid, attname, valsu);
                    if (ret != 0) {
                        throw new IOException(ret + ": " + nc4.nc_strerror(ret));
                    }
                    values = Array.factory(DataType.USHORT, new int[]{len}, (Object)valsu);
                    break;
                }
                case 3: {
                    short[] vals = new short[len];
                    ret = nc4.nc_get_att_short(grpid, varid, attname, vals);
                    if (ret != 0) {
                        throw new IOException(ret + ": " + nc4.nc_strerror(ret));
                    }
                    values = Array.factory(DataType.SHORT, new int[]{len}, (Object)vals);
                    break;
                }
                case 12: {
                    String[] valss = new String[len];
                    ret = nc4.nc_get_att_string(grpid, varid, attname, valss);
                    if (ret != 0) {
                        throw new IOException(ret + ": " + nc4.nc_strerror(ret));
                    }
                    if (transcodeStrings) {
                        valss = this.transcodeString(valss);
                    }
                    values = Array.factory(DataType.STRING, new int[]{len}, (Object)valss);
                    break;
                }
                default: {
                    UserType userType = this.userTypes.get(type);
                    if (userType == null) {
                        log.warn("Unsupported attribute data type == " + type);
                        continue block28;
                    }
                    if (userType.typeClass == 15) {
                        result.add(this.readEnumAttValues(grpid, varid, attname, len, userType));
                        continue block28;
                    }
                    if (userType.typeClass == 14) {
                        result.add(this.readOpaqueAttValues(grpid, varid, attname, len, userType));
                        continue block28;
                    }
                    if (userType.typeClass == 13) {
                        values = this.readVlenAttValues(grpid, varid, attname, len, userType);
                        break;
                    }
                    if (userType.typeClass == 16) {
                        this.readCompoundAttValues(grpid, varid, attname, len, userType, result, v);
                        continue block28;
                    }
                    log.warn("Unsupported attribute data type == " + userType);
                    continue block28;
                }
            }
            if (values == null) continue;
            Attribute att = new Attribute(attname, values);
            result.add(att);
        }
        return result;
    }

    private Array readVlenAttValues(int grpid, int varid, String attname, int len, UserType userType) throws IOException {
        Nc4prototypes.Vlen_t[] vlen = new Nc4prototypes.Vlen_t[len];
        int ret = nc4.nc_get_att(grpid, varid, attname, vlen);
        if (ret != 0) {
            throw new IOException(ret + ": " + nc4.nc_strerror(ret));
        }
        int count = 0;
        for (int i = 0; i < len; ++i) {
            count += vlen[i].len;
        }
        switch (userType.baseTypeid) {
            case 4: {
                Array intArray = Array.factory(DataType.INT, new int[]{count});
                IndexIterator iter = intArray.getIndexIterator();
                for (int i = 0; i < len; ++i) {
                    int[] ba;
                    for (int aBa : ba = vlen[i].p.getIntArray(0L, vlen[i].len)) {
                        iter.setIntNext(aBa);
                    }
                }
                return intArray;
            }
            case 5: {
                Array fArray = Array.factory(DataType.FLOAT, new int[]{count});
                IndexIterator iter = fArray.getIndexIterator();
                for (int i = 0; i < len; ++i) {
                    float[] ba;
                    for (float aBa : ba = vlen[i].p.getFloatArray(0L, vlen[i].len)) {
                        iter.setFloatNext(aBa);
                    }
                }
                return fArray;
            }
        }
        return null;
    }

    private Attribute readEnumAttValues(int grpid, int varid, String attname, int len, UserType userType) throws IOException {
        DataType dtype = this.convertDataType((int)userType.baseTypeid).dt;
        int elemSize = dtype.getSize();
        byte[] bbuff = new byte[len * elemSize];
        int ret = nc4.nc_get_att(grpid, varid, attname, bbuff);
        if (ret != 0) {
            throw new IOException(ret + ": " + nc4.nc_strerror(ret));
        }
        ByteBuffer bb = ByteBuffer.wrap(bbuff);
        Array data = null;
        String[] econsts = new String[len];
        EnumTypedef en = userType.e;
        for (int i = 0; i < len; ++i) {
            long lval = 0L;
            switch (en.getBaseType()) {
                case ENUM1: {
                    lval = bb.get(i);
                    break;
                }
                case ENUM2: {
                    lval = bb.getShort(i);
                    break;
                }
                case ENUM4: {
                    lval = bb.getInt(i);
                }
            }
            int ival = (int)lval;
            String name = en.lookupEnumString(ival);
            if (name == null) {
                name = "Unknown enum value=" + ival;
            }
            econsts[i] = name;
        }
        data = Array.factory(DataType.STRING, new int[]{len}, (Object)econsts);
        Attribute a = new Attribute(attname, data);
        a.setEnumType(userType.e);
        return a;
    }

    private Array convertByteBuffer(ByteBuffer bb, int baseType, int[] shape) throws IOException {
        switch (baseType) {
            case 1: {
                return Array.factory(DataType.BYTE, shape, (Object)bb.array());
            }
            case 7: {
                return Array.factory(DataType.UBYTE, shape, (Object)bb.array());
            }
            case 3: {
                return Array.factory(DataType.SHORT, shape, (Object)bb.asShortBuffer().array());
            }
            case 8: {
                return Array.factory(DataType.USHORT, shape, (Object)bb.asShortBuffer().array());
            }
            case 4: {
                return Array.factory(DataType.INT, shape, (Object)bb.asIntBuffer().array());
            }
            case 9: {
                return Array.factory(DataType.UINT, shape, (Object)bb.asIntBuffer().array());
            }
            case 10: {
                return Array.factory(DataType.LONG, shape, (Object)bb.asLongBuffer().array());
            }
            case 11: {
                return Array.factory(DataType.ULONG, shape, (Object)bb.asLongBuffer().array());
            }
        }
        throw new IllegalArgumentException("Illegal type=" + baseType);
    }

    private Attribute readOpaqueAttValues(int grpid, int varid, String attname, int len, UserType userType) throws IOException {
        int total = len * userType.size;
        byte[] bb = new byte[total];
        int ret = nc4.nc_get_att(grpid, varid, attname, bb);
        if (ret != 0) {
            throw new IOException(ret + ": " + nc4.nc_strerror(ret));
        }
        return new Attribute(attname, Array.factory(DataType.BYTE, new int[]{total}, (Object)bb));
    }

    private void readCompoundAttValues(int grpid, int varid, String attname, int len, UserType userType, List<Attribute> result, Variable v) throws IOException {
        int buffSize = len * userType.size;
        byte[] bb = new byte[buffSize];
        int ret = nc4.nc_get_att(grpid, varid, attname, bb);
        if (ret != 0) {
            throw new IOException(ret + ": " + nc4.nc_strerror(ret));
        }
        ByteBuffer bbuff = ByteBuffer.wrap(bb);
        this.decodeCompoundData(len, userType, bbuff);
        if (v instanceof Structure) {
            Structure s2 = (Structure)v;
            for (Field fld : userType.flds) {
                Variable mv = s2.findVariable(fld.name);
                if (mv != null) {
                    mv.addAttribute(new Attribute(attname, fld.data));
                    continue;
                }
                result.add(new Attribute(attname + "." + fld.name, fld.data));
            }
        } else {
            for (Field fld : userType.flds) {
                result.add(new Attribute(attname + "." + fld.name, fld.data));
            }
        }
    }

    private void decodeCompoundData(int len, UserType userType, ByteBuffer bbuff) throws IOException {
        bbuff.order(ByteOrder.LITTLE_ENDIAN);
        for (Field fld : userType.flds) {
            ConvertedType ct = this.convertDataType(fld.fldtypeid);
            if (fld.fldtypeid == 2) {
                fld.data = Array.factory(DataType.STRING, new int[]{len});
                continue;
            }
            if (ct.isVlen) continue;
            fld.data = Array.factory(ct.dt, new int[]{len});
        }
        for (int i = 0; i < len; ++i) {
            int record_start = i * userType.size;
            block12: for (Field fld : userType.flds) {
                int pos = record_start + fld.offset;
                switch (fld.fldtypeid) {
                    case 2: {
                        int blen = 1;
                        if (fld.dims != null) {
                            Section s2 = new Section(fld.dims);
                            blen = (int)s2.computeSize();
                        }
                        byte[] dst = new byte[blen];
                        bbuff.get(dst, 0, blen);
                        String cval = this.makeAttString(dst);
                        fld.data.setObject(i, (Object)cval);
                        continue block12;
                    }
                    case 1: 
                    case 7: {
                        byte bval = bbuff.get(pos);
                        fld.data.setByte(i, bval);
                        continue block12;
                    }
                    case 3: 
                    case 8: {
                        short sval = bbuff.getShort(pos);
                        fld.data.setShort(i, sval);
                        continue block12;
                    }
                    case 4: 
                    case 9: {
                        int ival = bbuff.getInt(pos);
                        fld.data.setInt(i, ival);
                        continue block12;
                    }
                    case 10: 
                    case 11: {
                        long lval = bbuff.getLong(pos);
                        fld.data.setLong(i, lval);
                        continue block12;
                    }
                    case 5: {
                        float fval = bbuff.getFloat(pos);
                        fld.data.setFloat(i, fval);
                        continue block12;
                    }
                    case 6: {
                        double dval = bbuff.getDouble(pos);
                        fld.data.setDouble(i, dval);
                        continue block12;
                    }
                    case 12: {
                        long lval = Nc4Iosp.getNativeAddr(pos, bbuff);
                        Pointer p = new Pointer(lval);
                        String strval = p.getString(0L, "UTF-8");
                        fld.data.setObject(i, (Object)strval);
                        continue block12;
                    }
                }
                UserType subUserType = this.userTypes.get(fld.fldtypeid);
                if (subUserType == null) {
                    throw new IOException("Unknown compound user type == " + fld);
                }
                if (subUserType.typeClass != 15) {
                    if (subUserType.typeClass == 13) {
                        this.decodeVlenField(fld, subUserType, pos, i, bbuff);
                        continue;
                    }
                    if (subUserType.typeClass == 14 || subUserType.typeClass == 16) {
                        // empty if block
                    }
                }
                log.warn("UNSUPPORTED compound fld.fldtypeid= " + fld.fldtypeid);
            }
        }
    }

    private void makeVariables(Group4 g4) throws IOException {
        IntByReference nvarsp = new IntByReference();
        int ret = nc4.nc_inq_nvars(g4.grpid, nvarsp);
        if (ret != 0) {
            throw new IOException(ret + ": " + nc4.nc_strerror(ret));
        }
        int nvars = nvarsp.getValue();
        log.debug("nvars= {}", (Object)nvars);
        int[] varids = new int[nvars];
        ret = nc4.nc_inq_varids(g4.grpid, nvarsp, varids);
        if (ret != 0) {
            throw new IOException(ret + ": " + nc4.nc_strerror(ret));
        }
        for (int i = 0; i < varids.length; ++i) {
            IntByReference nattsp;
            int[] dimids;
            IntByReference ndimsp;
            IntByReference xtypep;
            byte[] name;
            int varno = varids[i];
            if (varno != i) {
                log.error("makeVariables varno={} is not equal to {}", (Object)varno, (Object)i);
            }
            if ((ret = nc4.nc_inq_var(g4.grpid, varno, name = new byte[257], xtypep = new IntByReference(), ndimsp = new IntByReference(), dimids = new int[1024], nattsp = new IntByReference())) != 0) {
                throw new IOException(nc4.nc_strerror(ret));
            }
            int typeid = xtypep.getValue();
            String vname = this.makeString(name);
            Vinfo vinfo = new Vinfo(g4, varno, typeid);
            String dimList = this.makeDimList(g4.grpid, ndimsp.getValue(), dimids);
            UserType utype = this.userTypes.get(typeid);
            if (utype != null) {
                vinfo.utype = utype;
                if (utype.typeClass == 13) {
                    dimList = dimList + " *";
                }
            }
            Variable v = this.makeVariable(g4.g, null, vname, typeid, dimList);
            this.ncfile.addVariable(g4.g, v);
            v.setSPobject(vinfo);
            List<Attribute> atts = this.makeAttributes(g4.grpid, varno, nattsp.getValue(), v);
            for (Attribute att : atts) {
                v.addAttribute(att);
            }
            log.debug("added Variable {}", (Object)v);
        }
    }

    private Variable makeVariable(Group g2, Structure parent, String vname, int typeid, String dimList) throws IOException {
        Variable v;
        ConvertedType cvttype = this.convertDataType(typeid);
        DataType dtype = cvttype.dt;
        UserType utype = this.userTypes.get(typeid);
        if (dtype != DataType.STRUCTURE) {
            v = new Variable(this.ncfile, g2, parent, vname, dtype, dimList);
        } else if (utype != null) {
            Structure s2 = new Structure(this.ncfile, g2, parent, vname);
            s2.setDimensions(dimList);
            v = s2;
            if (utype.flds == null) {
                utype.readFields();
            }
            for (Field f : utype.flds) {
                s2.addMemberVariable(f.makeMemberVariable(g2, s2));
            }
        } else {
            throw new IllegalStateException("Dunno what to with " + (Object)((Object)dtype));
        }
        if (dtype.isEnum()) {
            EnumTypedef enumTypedef = g2.findEnumeration(utype.name);
            v.setEnumTypedef(enumTypedef);
        } else if (dtype != DataType.OPAQUE || this.markreserved) {
            // empty if block
        }
        return v;
    }

    private String makeDimList(int grpid, int ndimsp, int[] dims) throws IOException {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < ndimsp; ++i) {
            byte[] name = new byte[257];
            int ret = nc4.nc_inq_dimname(grpid, dims[i], name);
            if (ret != 0) {
                throw new IOException(ret + ": " + nc4.nc_strerror(ret));
            }
            String dname = this.makeString(name);
            sb.append(dname);
            sb.append(" ");
        }
        return sb.toString();
    }

    private boolean nc_inq_var(Formatter f, int grpid, int varno) throws IOException {
        byte[] name = new byte[257];
        IntByReference xtypep = new IntByReference();
        IntByReference ndimsp = new IntByReference();
        int[] dimids = new int[1024];
        IntByReference nattsp = new IntByReference();
        int ret = nc4.nc_inq_var(grpid, varno, name, xtypep, ndimsp, dimids, nattsp);
        if (ret != 0) {
            return false;
        }
        String vname = this.makeString(name);
        int typeid = xtypep.getValue();
        ConvertedType cvt = this.convertDataType(typeid);
        for (int i = 0; i < ndimsp.getValue(); ++i) {
            f.format("%d ", dimids[i]);
        }
        String dimList = this.makeDimList(grpid, ndimsp.getValue(), dimids);
        f.format(") dims=(%s)%n", dimList);
        return true;
    }

    private String nc_inq_var_name(int grpid, int varno) throws IOException {
        byte[] name = new byte[257];
        IntByReference xtypep = new IntByReference();
        IntByReference ndimsp = new IntByReference();
        IntByReference nattsp = new IntByReference();
        int ret = nc4.nc_inq_var(grpid, varno, name, xtypep, ndimsp, null, nattsp);
        if (ret != 0) {
            throw new IOException("nc_inq_var faild: code=" + ret);
        }
        return this.makeString(name);
    }

    private void makeUserTypes(int grpid, Group g2) throws IOException {
        IntByReference ntypesp = new IntByReference();
        int ret = nc4.nc_inq_typeids(grpid, ntypesp, null);
        if (ret != 0) {
            throw new IOException(ret + ": " + nc4.nc_strerror(ret));
        }
        int ntypes = ntypesp.getValue();
        if (ntypes == 0) {
            return;
        }
        int[] xtypes = new int[ntypes];
        ret = nc4.nc_inq_typeids(grpid, ntypesp, xtypes);
        if (ret != 0) {
            throw new IOException(ret + ": " + nc4.nc_strerror(ret));
        }
        for (int typeid : xtypes) {
            byte[] nameb = new byte[257];
            SizeTByReference sizep = new SizeTByReference();
            IntByReference baseType = new IntByReference();
            SizeTByReference nfieldsp = new SizeTByReference();
            IntByReference classp = new IntByReference();
            ret = nc4.nc_inq_user_type(grpid, typeid, nameb, sizep, baseType, nfieldsp, classp);
            if (ret != 0) {
                throw new IOException(ret + ": " + nc4.nc_strerror(ret));
            }
            String name = this.makeString(nameb);
            int utype = classp.getValue();
            log.debug("user type id={} name={} size={} baseType={} nfields={} class={}", typeid, name, sizep.getValue().longValue(), baseType.getValue(), nfieldsp.getValue().longValue(), utype);
            UserType ut = new UserType(grpid, typeid, name, sizep.getValue().longValue(), baseType.getValue(), nfieldsp.getValue().longValue(), utype);
            this.userTypes.put(typeid, ut);
            if (utype == 15) {
                Map<Integer, String> map = this.makeEnum(grpid, typeid);
                ut.e = new EnumTypedef(name, map, ut.getEnumBaseType());
                g2.addEnumeration(ut.e);
                continue;
            }
            if (utype != 14) continue;
            byte[] nameo = new byte[257];
            SizeTByReference sizep2 = new SizeTByReference();
            ret = nc4.nc_inq_opaque(grpid, typeid, nameo, sizep2);
            if (ret != 0) {
                throw new IOException(ret + ": " + nc4.nc_strerror(ret));
            }
            ut.setSize(sizep2.getValue().intValue());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void dumpbytes(byte[] bytes, int start, int len, String tag) {
        System.err.println("++++++++++ " + tag + " ++++++++++ ");
        int stop = start + len;
        try {
            for (int i = 0; i < stop; ++i) {
                byte b;
                byte ib = b = bytes[i];
                int ub = ib & 0xFF;
                char c = (char)ub;
                String s2 = Character.toString(c);
                if (c == '\r') {
                    s2 = "\\r";
                } else if (c == '\n') {
                    s2 = "\\n";
                } else if (c < ' ') {
                    s2 = "?";
                }
                System.err.printf("[%03d] %02x %03d %4d '%s'", i, ub, ub, (int)ib, s2);
                System.err.println();
                System.err.flush();
            }
        }
        catch (Exception e) {
            System.err.println("failure:" + e);
        }
        finally {
            System.err.println("++++++++++ " + tag + " ++++++++++ ");
            System.err.flush();
        }
    }

    private Map<Integer, String> makeEnum(int grpid, int xtype) throws IOException {
        byte[] nameb = new byte[257];
        IntByReference baseType = new IntByReference();
        SizeTByReference baseSize = new SizeTByReference();
        SizeTByReference numMembers = new SizeTByReference();
        int ret = nc4.nc_inq_enum(grpid, xtype, nameb, baseType, baseSize, numMembers);
        if (ret != 0) {
            throw new IOException(ret + ": " + nc4.nc_strerror(ret));
        }
        int nmembers = numMembers.getValue().intValue();
        HashMap<Integer, String> map = new HashMap<Integer, String>(2 * nmembers);
        for (int i = 0; i < nmembers; ++i) {
            byte[] mnameb = new byte[257];
            IntByReference value = new IntByReference();
            ret = nc4.nc_inq_enum_member(grpid, xtype, i, mnameb, value);
            if (ret != 0) {
                throw new IOException(ret + ": " + nc4.nc_strerror(ret));
            }
            String mname = this.makeString(mnameb);
            map.put(value.getValue(), mname);
        }
        return map;
    }

    @Override
    public Array readData(Variable v2, Section section) throws IOException, InvalidRangeException {
        int len;
        Vinfo vinfo = (Vinfo)v2.getSPobject();
        int vlen = (int)v2.getSize();
        if (vlen == (len = (int)section.computeSize())) {
            return this.readDataAll(vinfo.g4.grpid, vinfo.varid, vinfo.typeid, v2.getShapeAsSection());
        }
        return this.readDataSection(vinfo.g4.grpid, vinfo.varid, vinfo.typeid, section);
    }

    Array readDataSection(int grpid, int varid, int typeid, Section section) throws IOException, InvalidRangeException {
        Array values;
        SizeT[] origin = this.convertSizeT(section.getOrigin());
        SizeT[] shape = this.convertSizeT(section.getShape());
        SizeT[] stride = this.convertSizeT(section.getStride());
        boolean isUnsigned = this.isUnsigned(typeid);
        int len = (int)section.computeSize();
        switch (typeid) {
            case 1: 
            case 7: {
                int ret;
                byte[] valb = new byte[len];
                int n = ret = isUnsigned ? nc4.nc_get_vars_uchar(grpid, varid, origin, shape, stride, valb) : nc4.nc_get_vars_schar(grpid, varid, origin, shape, stride, valb);
                if (ret != 0) {
                    throw new IOException(ret + ": " + nc4.nc_strerror(ret));
                }
                values = Array.factory(DataType.BYTE, section.getShape(), (Object)valb);
                break;
            }
            case 2: {
                byte[] valc = new byte[len];
                int ret = nc4.nc_get_vars_text(grpid, varid, origin, shape, stride, valc);
                if (ret != 0) {
                    throw new IOException(ret + ": " + nc4.nc_strerror(ret));
                }
                values = Array.factory(DataType.CHAR, section.getShape(), (Object)IospHelper.convertByteToChar(valc));
                break;
            }
            case 6: {
                double[] vald = new double[len];
                int ret = nc4.nc_get_vars_double(grpid, varid, origin, shape, stride, vald);
                if (ret != 0) {
                    throw new IOException(ret + ": " + nc4.nc_strerror(ret));
                }
                values = Array.factory(DataType.DOUBLE, section.getShape(), (Object)vald);
                break;
            }
            case 5: {
                float[] valf = new float[len];
                int ret = nc4.nc_get_vars_float(grpid, varid, origin, shape, stride, valf);
                if (ret != 0) {
                    throw new IOException(ret + ": " + nc4.nc_strerror(ret));
                }
                values = Array.factory(DataType.FLOAT, section.getShape(), (Object)valf);
                break;
            }
            case 4: 
            case 9: {
                int ret;
                int[] vali = new int[len];
                int n = ret = isUnsigned ? nc4.nc_get_vars_uint(grpid, varid, origin, shape, stride, vali) : nc4.nc_get_vars_int(grpid, varid, origin, shape, stride, vali);
                if (ret != 0) {
                    throw new IOException(ret + ": " + nc4.nc_strerror(ret));
                }
                values = Array.factory(DataType.INT, section.getShape(), (Object)vali);
                break;
            }
            case 10: 
            case 11: {
                int ret;
                long[] vall = new long[len];
                int n = ret = isUnsigned ? nc4.nc_get_vars_ulonglong(grpid, varid, origin, shape, stride, vall) : nc4.nc_get_vars_longlong(grpid, varid, origin, shape, stride, vall);
                if (ret != 0) {
                    throw new IOException(ret + ": " + nc4.nc_strerror(ret));
                }
                values = Array.factory(DataType.LONG, section.getShape(), (Object)vall);
                break;
            }
            case 3: 
            case 8: {
                int ret;
                short[] vals = new short[len];
                int n = ret = isUnsigned ? nc4.nc_get_vars_ushort(grpid, varid, origin, shape, stride, vals) : nc4.nc_get_vars_short(grpid, varid, origin, shape, stride, vals);
                if (ret != 0) {
                    throw new IOException(ret + ": " + nc4.nc_strerror(ret));
                }
                values = Array.factory(DataType.SHORT, section.getShape(), (Object)vals);
                break;
            }
            case 12: {
                String[] valss = new String[len];
                int ret = nc4.nc_get_vars_string(grpid, varid, origin, shape, stride, valss);
                if (ret != 0) {
                    throw new IOException(ret + ": " + nc4.nc_strerror(ret));
                }
                if (transcodeStrings) {
                    valss = this.transcodeString(valss);
                }
                return Array.factory(DataType.STRING, section.getShape(), (Object)valss);
            }
            default: {
                UserType userType = this.userTypes.get(typeid);
                if (userType == null) {
                    throw new IOException("Unknown userType == " + typeid);
                }
                if (userType.typeClass == 15) {
                    return this.readDataSection(grpid, varid, userType.baseTypeid, section);
                }
                if (userType.typeClass == 13) {
                    return this.readVlen(grpid, varid, userType, section);
                }
                if (userType.typeClass == 14) {
                    return this.readOpaque(grpid, varid, section, userType.size);
                }
                if (userType.typeClass == 16) {
                    return this.readCompound(grpid, varid, section, userType);
                }
                throw new IOException("Unsupported userType = " + typeid + " userType= " + userType);
            }
        }
        return values;
    }

    private Array readDataAll(int grpid, int varid, int typeid, Section section) throws IOException, InvalidRangeException {
        int len = (int)section.computeSize();
        int[] shape = section.getShape();
        switch (typeid) {
            case 7: {
                byte[] valbu = new byte[len];
                int ret = nc4.nc_get_var_ubyte(grpid, varid, valbu);
                if (ret != 0) {
                    throw new IOException(ret + ": " + nc4.nc_strerror(ret));
                }
                return Array.factory(DataType.UBYTE, shape, (Object)valbu);
            }
            case 1: {
                byte[] valb = new byte[len];
                int ret = nc4.nc_get_var_schar(grpid, varid, valb);
                if (ret != 0) {
                    throw new IOException(ret + ": " + nc4.nc_strerror(ret));
                }
                return Array.factory(DataType.BYTE, shape, (Object)valb);
            }
            case 2: {
                byte[] valc = new byte[len];
                int ret = nc4.nc_get_var_text(grpid, varid, valc);
                if (ret != 0) {
                    throw new IOException(ret + ": " + nc4.nc_strerror(ret));
                }
                char[] cvals = IospHelper.convertByteToChar(valc);
                return Array.factory(DataType.CHAR, shape, (Object)cvals);
            }
            case 6: {
                double[] vald = new double[len];
                int ret = nc4.nc_get_var_double(grpid, varid, vald);
                if (ret != 0) {
                    throw new IOException(ret + ": " + nc4.nc_strerror(ret));
                }
                return Array.factory(DataType.DOUBLE, shape, (Object)vald);
            }
            case 5: {
                float[] valf = new float[len];
                int ret = nc4.nc_get_var_float(grpid, varid, valf);
                if (ret != 0) {
                    throw new IOException(ret + ": " + nc4.nc_strerror(ret));
                }
                return Array.factory(DataType.FLOAT, shape, (Object)valf);
            }
            case 4: {
                int[] vali = new int[len];
                int ret = nc4.nc_get_var_int(grpid, varid, vali);
                if (ret != 0) {
                    throw new IOException(ret + ": " + nc4.nc_strerror(ret));
                }
                return Array.factory(DataType.INT, shape, (Object)vali);
            }
            case 10: {
                long[] vall = new long[len];
                int ret = nc4.nc_get_var_longlong(grpid, varid, vall);
                if (ret != 0) {
                    throw new IOException(ret + ": " + nc4.nc_strerror(ret));
                }
                return Array.factory(DataType.LONG, shape, (Object)vall);
            }
            case 11: {
                long[] vallu = new long[len];
                int ret = nc4.nc_get_var_ulonglong(grpid, varid, vallu);
                if (ret != 0) {
                    throw new IOException(ret + ": " + nc4.nc_strerror(ret));
                }
                return Array.factory(DataType.ULONG, shape, (Object)vallu);
            }
            case 3: {
                short[] vals = new short[len];
                int ret = nc4.nc_get_var_short(grpid, varid, vals);
                if (ret != 0) {
                    throw new IOException(ret + ": " + nc4.nc_strerror(ret));
                }
                return Array.factory(DataType.SHORT, shape, (Object)vals);
            }
            case 8: {
                short[] valsu = new short[len];
                int ret = nc4.nc_get_var_ushort(grpid, varid, valsu);
                if (ret != 0) {
                    throw new IOException(ret + ": " + nc4.nc_strerror(ret));
                }
                return Array.factory(DataType.USHORT, shape, (Object)valsu);
            }
            case 9: {
                int[] valiu = new int[len];
                int ret = nc4.nc_get_var_uint(grpid, varid, valiu);
                if (ret != 0) {
                    throw new IOException(ret + ": " + nc4.nc_strerror(ret));
                }
                return Array.factory(DataType.UINT, shape, (Object)valiu);
            }
            case 12: {
                String[] valss = new String[len];
                int ret = nc4.nc_get_var_string(grpid, varid, valss);
                if (ret != 0) {
                    throw new IOException(ret + ": " + nc4.nc_strerror(ret));
                }
                if (transcodeStrings) {
                    valss = this.transcodeString(valss);
                }
                return Array.factory(DataType.STRING, shape, (Object)valss);
            }
        }
        UserType userType = this.userTypes.get(typeid);
        if (userType == null) {
            throw new IOException("Unknown userType == " + typeid);
        }
        if (userType.typeClass == 15) {
            int buffSize = len * userType.size;
            byte[] bbuff = new byte[buffSize];
            int ret = nc4.nc_get_var(grpid, varid, bbuff);
            if (ret != 0) {
                throw new IOException(ret + ": " + nc4.nc_strerror(ret));
            }
            ByteBuffer bb = ByteBuffer.wrap(bbuff);
            bb.order(ByteOrder.nativeOrder());
            switch (userType.baseTypeid) {
                case 1: {
                    return Array.factory(DataType.BYTE, shape, bb);
                }
                case 7: {
                    return Array.factory(DataType.UBYTE, shape, bb);
                }
                case 3: {
                    return Array.factory(DataType.SHORT, shape, bb);
                }
                case 8: {
                    return Array.factory(DataType.USHORT, shape, bb);
                }
                case 4: {
                    return Array.factory(DataType.INT, shape, bb);
                }
                case 9: {
                    return Array.factory(DataType.UINT, shape, bb);
                }
            }
            throw new IOException("unknown type " + userType.baseTypeid);
        }
        if (userType.typeClass == 13) {
            return this.readVlen(grpid, varid, userType, section);
        }
        if (userType.typeClass == 14) {
            return this.readOpaque(grpid, varid, section, userType.size);
        }
        if (userType.typeClass == 16) {
            return this.readCompound(grpid, varid, section, userType);
        }
        throw new IOException("Unsupported userType = " + typeid + " userType= " + userType);
    }

    private Array readCompound(int grpid, int varid, Section section, UserType userType) throws IOException {
        int len;
        int buffSize;
        byte[] bbuff;
        SizeT[] stride;
        SizeT[] shape;
        SizeT[] origin = this.convertSizeT(section.getOrigin());
        int ret = nc4.nc_get_vars(grpid, varid, origin, shape = this.convertSizeT(section.getShape()), stride = this.convertSizeT(section.getStride()), bbuff = new byte[buffSize = (len = (int)section.computeSize()) * userType.size]);
        if (ret != 0) {
            throw new IOException(ret + ": " + nc4.nc_strerror(ret));
        }
        ByteBuffer bb = ByteBuffer.wrap(bbuff);
        bb.order(ByteOrder.nativeOrder());
        String vname = this.nc_inq_var_name(grpid, varid);
        StructureMembers sm = this.createStructureMembers(userType, vname);
        ArrayStructureBB asbb = new ArrayStructureBB(sm, section.getShape(), bb, 0);
        int destPos = 0;
        for (int i = 0; i < len; ++i) {
            this.convertHeap(asbb, destPos, sm);
            destPos += userType.size;
        }
        return asbb;
    }

    private StructureMembers createStructureMembers(UserType userType, String varname) {
        StructureMembers.Builder sm = StructureMembers.builder().setName(varname);
        for (Field fld : userType.flds) {
            StructureMembers.MemberBuilder mb = sm.addMember(fld.name, null, null, fld.ctype.dt, fld.dims);
            mb.setDataParam(fld.offset);
            if (fld.ctype.dt != DataType.STRUCTURE) continue;
            UserType nested_utype = this.userTypes.get(fld.fldtypeid);
            String partfqn = EscapeStrings.backslashEscapeCDMString(varname, ".") + "." + EscapeStrings.backslashEscapeCDMString(fld.name, ".");
            StructureMembers nested_sm = this.createStructureMembers(nested_utype, partfqn);
            mb.setStructureMembers(nested_sm);
        }
        sm.setStructureSize(userType.size);
        return sm.build();
    }

    private void convertHeap(ArrayStructureBB asbb, int pos, StructureMembers sm) throws IOException {
        ByteBuffer bb = asbb.getByteBuffer();
        for (StructureMembers.Member m3 : sm.getMembers()) {
            Array result;
            int prefixrank;
            if (m3.getDataType() == DataType.STRING) {
                int size = m3.getSize();
                int destPos = pos + m3.getDataParam();
                String[] result2 = new String[size];
                for (int i = 0; i < size; ++i) {
                    long addr = Nc4Iosp.getNativeAddr(pos, bb);
                    Pointer p = new Pointer(addr);
                    result2[i] = p.getString(0L, "UTF-8");
                }
                int index = asbb.addObjectToHeap(result2);
                bb.putInt(destPos, index);
                continue;
            }
            if (!m3.isVariableLength()) continue;
            int nc_vlen_t_size = new Nc4prototypes.Vlen_t().size();
            int startPos = pos + m3.getDataParam();
            int[] fieldshape = m3.getShape();
            int size = 1;
            for (prefixrank = 0; prefixrank < fieldshape.length && fieldshape[prefixrank] >= 0; ++prefixrank) {
                size *= fieldshape[prefixrank];
            }
            assert (size == m3.getSize()) : "Internal error: field size mismatch";
            Array[] fieldarray = new Array[size];
            int destPos = startPos;
            for (int i = 0; i < size; ++i) {
                Array vlenArray;
                fieldarray[i] = vlenArray = this.decodeVlen(m3.getDataType(), destPos, bb);
                destPos += nc_vlen_t_size;
            }
            if (prefixrank == 0) {
                result = fieldarray[0];
            } else {
                int[] newshape = new int[prefixrank];
                System.arraycopy(fieldshape, 0, newshape, 0, prefixrank);
                result = Array.makeVlenArray(newshape, fieldarray);
            }
            int index = asbb.addObjectToHeap(result);
            bb.order(ByteOrder.nativeOrder());
            bb.putInt(startPos, index);
        }
    }

    private void decodeVlenField(Field fld, UserType userType, int pos, int idx, ByteBuffer bbuff) throws IOException {
        ConvertedType cvt = this.convertDataType(userType.baseTypeid);
        Array array = this.decodeVlen(cvt.dt, pos, bbuff);
        fld.data.setObject(idx, (Object)array);
    }

    private Array decodeVlen(DataType dt, int pos, ByteBuffer bbuff) throws IOException {
        Object[] data;
        int n = (int)bbuff.getLong(pos);
        long addr = Nc4Iosp.getNativeAddr(pos + Native.POINTER_SIZE, bbuff);
        Pointer p = new Pointer(addr);
        switch (dt) {
            case ENUM1: 
            case BOOLEAN: 
            case BYTE: {
                data = p.getByteArray(0L, n);
                break;
            }
            case ENUM2: 
            case SHORT: {
                data = p.getShortArray(0L, n);
                break;
            }
            case ENUM4: 
            case INT: {
                data = p.getIntArray(0L, n);
                break;
            }
            case LONG: {
                data = p.getLongArray(0L, n);
                break;
            }
            case FLOAT: {
                data = p.getFloatArray(0L, n);
                break;
            }
            case DOUBLE: {
                data = p.getDoubleArray(0L, n);
                break;
            }
            case CHAR: {
                data = p.getCharArray(0L, n);
                break;
            }
            case STRING: {
                String[] stringdata = new String[n];
                for (int i = 0; i < n; ++i) {
                    stringdata[i] = p.getString(i * 8);
                }
                data = stringdata;
                break;
            }
            default: {
                throw new IllegalStateException();
            }
        }
        Array array = Array.factory(dt, new int[]{n}, (Object)data);
        return array;
    }

    Array readVlen(int grpid, int varid, UserType userType, Section section) throws IOException {
        int prefixrank;
        int len = (int)section.computeSize();
        Nc4prototypes.Vlen_t[] vlen = new Nc4prototypes.Vlen_t[len];
        int ret = nc4.nc_get_var(grpid, varid, vlen);
        if (ret != 0) {
            throw new IOException(ret + ": " + nc4.nc_strerror(ret));
        }
        for (prefixrank = 0; prefixrank < section.getRank() && section.getRange(prefixrank) != Range.VLEN; ++prefixrank) {
        }
        ConvertedType ctype = this.convertDataType(userType.baseTypeid);
        Array[] data = new Array[len];
        switch (userType.baseTypeid) {
            case 4: 
            case 9: {
                Object[] ba;
                int slen;
                int i;
                for (i = 0; i < len; ++i) {
                    slen = vlen[i].len;
                    ba = vlen[i].p.getIntArray(0L, slen);
                    data[i] = Array.factory(ctype.dt, new int[]{slen}, (Object)ba);
                }
                break;
            }
            case 3: 
            case 8: {
                Object[] ba;
                int slen;
                int i;
                for (i = 0; i < len; ++i) {
                    slen = vlen[i].len;
                    ba = vlen[i].p.getShortArray(0L, slen);
                    data[i] = Array.factory(ctype.dt, new int[]{slen}, (Object)ba);
                }
                break;
            }
            case 5: {
                Object[] ba;
                int slen;
                int i;
                for (i = 0; i < len; ++i) {
                    slen = vlen[i].len;
                    ba = vlen[i].p.getFloatArray(0L, slen);
                    data[i] = Array.factory(DataType.FLOAT, new int[]{slen}, (Object)ba);
                }
                break;
            }
            default: {
                throw new UnsupportedOperationException("Vlen type " + userType.baseTypeid + " = " + ctype);
            }
        }
        if (prefixrank == 0) {
            return data[0];
        }
        int[] shape = new int[prefixrank];
        for (int i = 0; i < prefixrank; ++i) {
            shape[i] = section.getRange(i).length();
        }
        Array ndimarray = Array.makeVlenArray(shape, data);
        return ndimarray;
    }

    private Array readOpaque(int grpid, int varid, Section section, int size) throws IOException {
        int[] intshape;
        int len;
        byte[] bbuff;
        SizeT[] stride;
        SizeT[] shape;
        SizeT[] origin = this.convertSizeT(section.getOrigin());
        int ret = nc4.nc_get_vars(grpid, varid, origin, shape = this.convertSizeT(section.getShape()), stride = this.convertSizeT(section.getStride()), bbuff = new byte[(len = (int)section.computeSize()) * size]);
        if (ret != 0) {
            throw new IOException(ret + ": " + nc4.nc_strerror(ret));
        }
        if (shape != null) {
            intshape = new int[shape.length];
            for (int i = 0; i < intshape.length; ++i) {
                intshape[i] = shape[i].intValue();
            }
        } else {
            intshape = new int[]{1};
        }
        Array values = Array.factory(DataType.OPAQUE, intshape);
        int count = 0;
        IndexIterator ii = values.getIndexIterator();
        while (ii.hasNext()) {
            ii.setObjectNext(ByteBuffer.wrap(bbuff, count * size, size));
            ++count;
        }
        return values;
    }

    private boolean isUnsigned(int type) {
        return type == 7 || type == 8 || type == 9 || type == 11;
    }

    private boolean isVlen(int type) {
        UserType userType = this.userTypes.get(type);
        return userType != null && userType.typeClass == 13;
    }

    private boolean isStride1(int[] strides) {
        if (strides == null) {
            return true;
        }
        for (int stride : strides) {
            if (stride == 1) continue;
            return false;
        }
        return true;
    }

    private SizeT[] convertSizeT(int[] from) {
        if (from.length == 0) {
            return null;
        }
        SizeT[] to = new SizeT[from.length];
        for (int i = 0; i < from.length; ++i) {
            to[i] = new SizeT((long)from[i]);
        }
        return to;
    }

    public static String show(SizeT[] inta) {
        if (inta == null) {
            return "null";
        }
        Formatter f = new Formatter();
        for (SizeT i : inta) {
            f.format("%d, ", i.longValue());
        }
        return f.toString();
    }

    private int convertDataType(DataType dt) {
        switch (dt) {
            case BYTE: {
                return 1;
            }
            case UBYTE: {
                return 7;
            }
            case CHAR: {
                return 2;
            }
            case DOUBLE: {
                return 6;
            }
            case FLOAT: {
                return 5;
            }
            case INT: {
                return 4;
            }
            case UINT: {
                return 9;
            }
            case LONG: {
                return 10;
            }
            case ULONG: {
                return 11;
            }
            case SHORT: {
                return 3;
            }
            case USHORT: {
                return 8;
            }
            case STRING: {
                return 12;
            }
            case ENUM1: 
            case ENUM2: 
            case ENUM4: {
                return 15;
            }
            case OPAQUE: {
                log.warn("Skipping Opaque Type");
                return -1;
            }
            case STRUCTURE: {
                return 16;
            }
        }
        throw new IllegalArgumentException("unimplemented type == " + (Object)((Object)dt));
    }

    private ConvertedType convertDataType(int type) {
        switch (type) {
            case 1: {
                return new ConvertedType(DataType.BYTE);
            }
            case 7: {
                return new ConvertedType(DataType.UBYTE);
            }
            case 2: {
                return new ConvertedType(DataType.CHAR);
            }
            case 3: {
                return new ConvertedType(DataType.SHORT);
            }
            case 8: {
                return new ConvertedType(DataType.USHORT);
            }
            case 4: {
                return new ConvertedType(DataType.INT);
            }
            case 9: {
                return new ConvertedType(DataType.UINT);
            }
            case 10: {
                return new ConvertedType(DataType.LONG);
            }
            case 11: {
                return new ConvertedType(DataType.ULONG);
            }
            case 5: {
                return new ConvertedType(DataType.FLOAT);
            }
            case 6: {
                return new ConvertedType(DataType.DOUBLE);
            }
            case 15: {
                return new ConvertedType(DataType.ENUM1);
            }
            case 12: {
                return new ConvertedType(DataType.STRING);
            }
        }
        UserType userType = this.userTypes.get(type);
        if (userType == null) {
            throw new IllegalArgumentException("unknown type == " + type);
        }
        switch (userType.typeClass) {
            case 15: {
                switch (userType.size) {
                    case 1: {
                        return new ConvertedType(DataType.ENUM1);
                    }
                    case 2: {
                        return new ConvertedType(DataType.ENUM2);
                    }
                    case 4: {
                        return new ConvertedType(DataType.ENUM4);
                    }
                }
                throw new IllegalArgumentException("enum unknown size == " + userType);
            }
            case 16: {
                return new ConvertedType(DataType.STRUCTURE);
            }
            case 14: {
                return new ConvertedType(DataType.OPAQUE);
            }
            case 13: {
                ConvertedType result = this.convertDataType(userType.baseTypeid);
                result.isVlen = true;
                return result;
            }
        }
        throw new IllegalArgumentException("unknown type == " + type);
    }

    private String getDataTypeName(int type) {
        switch (type) {
            case 1: {
                return "byte";
            }
            case 7: {
                return "ubyte";
            }
            case 2: {
                return "char";
            }
            case 3: {
                return "short";
            }
            case 8: {
                return "ushort";
            }
            case 4: {
                return "int";
            }
            case 9: {
                return "uint";
            }
            case 10: {
                return "long";
            }
            case 11: {
                return "ulong";
            }
            case 5: {
                return "float";
            }
            case 6: {
                return "double";
            }
            case 15: {
                return "enum";
            }
            case 12: {
                return "string";
            }
            case 16: {
                return "struct";
            }
            case 14: {
                return "opaque";
            }
            case 13: {
                return "vlen";
            }
        }
        UserType userType = this.userTypes.get(type);
        if (userType == null) {
            return "unknown type " + type;
        }
        switch (userType.typeClass) {
            case 15: {
                return "userType-enum";
            }
            case 16: {
                return "userType-struct";
            }
            case 14: {
                return "userType-opaque";
            }
            case 13: {
                return "userType-vlen";
            }
        }
        return "unknown userType " + userType.typeClass;
    }

    @Override
    public void create(String filename, NetcdfFile ncfile, int extra, long preallocateSize, boolean largeFile) throws IOException {
        if (!Nc4Iosp.isClibraryPresent()) {
            throw new UnsupportedOperationException("Couldn't load NetCDF C library (see log for details).");
        }
        this.ncfile = ncfile;
        ncfile.finish();
        log.debug("create {}", (Object)ncfile.getLocation());
        IntByReference ncidp = new IntByReference();
        int ret = nc4.nc_create(filename, this.createMode(), ncidp);
        if (ret != 0) {
            throw new IOException(ret + ": " + nc4.nc_strerror(ret));
        }
        this.isClosed = false;
        this.ncid = ncidp.getValue();
        this._setFill();
        this.createGroup(new Group4(this.ncid, ncfile.getRootGroup(), null));
        nc4.nc_enddef(this.ncid);
    }

    private int createMode() {
        int ret = 0;
        switch (this.version) {
            case netcdf4: {
                ret |= 0x1000;
                break;
            }
            case netcdf4_classic: {
                ret |= 0x1100;
            }
        }
        return ret;
    }

    private int defineFormat() {
        switch (this.version) {
            case netcdf4: {
                return 3;
            }
            case netcdf4_classic: {
                return 4;
            }
            case netcdf3c: {
                return 1;
            }
            case netcdf3c64: {
                return 2;
            }
        }
        throw new IllegalStateException("version = " + (Object)((Object)this.version));
    }

    private void createGroup(Group4 g4) throws IOException {
        this.groupHash.put(g4.g, g4.grpid);
        g4.dimHash = new HashMap<Dimension, Integer>();
        for (Attribute att : g4.g.attributes()) {
            this.writeAttribute(g4.grpid, -1, att, null);
        }
        for (Dimension dim : g4.g.getDimensions()) {
            int dimLength = dim.isUnlimited() ? 0 : dim.getLength();
            int dimid = this.addDimension(g4.grpid, dim.getShortName(), dimLength);
            g4.dimHash.put(dim, dimid);
        }
        for (EnumTypedef en : g4.g.getEnumTypedefs()) {
            this.createEnumType(g4, en);
        }
        for (Variable v : g4.g.getVariables()) {
            if (v.getDataType() != DataType.STRUCTURE) continue;
            this.createCompoundType(g4, (Structure)v);
        }
        for (Variable v : g4.g.getVariables()) {
            this.createVariable(g4, v);
        }
        for (Group nested : g4.g.getGroups()) {
            IntByReference grpidp = new IntByReference();
            int ret = nc4.nc_def_grp(g4.grpid, nested.getShortName(), grpidp);
            if (ret != 0) {
                throw new IOException(ret + ": " + nc4.nc_strerror(ret));
            }
            int nestedId = grpidp.getValue();
            this.createGroup(new Group4(nestedId, nested, g4));
        }
    }

    private void createVariable(Group4 g4, Variable v) throws IOException {
        int varid;
        int typid;
        Vinfo vinfo;
        int[] dimids = new int[v.getRank()];
        int count = 0;
        for (Dimension d : v.getDimensions()) {
            int dimid = !d.isShared() ? this.addDimension(g4.grpid, v.getShortName() + "_Dim" + count, d.getLength()) : this.findDimensionId(g4, d).intValue();
            dimids[count++] = dimid;
        }
        if (v instanceof Structure) {
            vinfo = (Vinfo)v.getSPobject();
            typid = vinfo.typeid;
        } else if (v.getDataType().isEnum()) {
            EnumTypedef en = v.getEnumTypedef();
            UserType ut = (UserType)en.annotation(UserType.class);
            typid = ut.typeid;
            vinfo = new Vinfo(g4, -1, typid);
        } else if (v.getDataType() == DataType.OPAQUE) {
            typid = this.convertDataType(v.getDataType());
            if (typid < 0) {
                return;
            }
            vinfo = new Vinfo(g4, -1, typid);
        } else {
            typid = this.convertDataType(v.getDataType());
            if (typid < 0) {
                return;
            }
            vinfo = new Vinfo(g4, -1, typid);
        }
        IntByReference varidp = new IntByReference();
        int ret = nc4.nc_def_var(g4.grpid, v.getShortName(), new SizeT((long)typid), dimids.length, dimids, varidp);
        if (ret != 0) {
            throw new IOException("ret=" + ret + " err='" + nc4.nc_strerror(ret) + "' on\n" + v);
        }
        vinfo.varid = varid = varidp.getValue();
        if (this.version.isNetdf4format() && v.getRank() > 0) {
            SizeT[] chunking;
            int storage;
            boolean isChunked = this.chunker.isChunked(v);
            int n = storage = isChunked ? 0 : 1;
            if (isChunked) {
                long[] lchunks = this.chunker.computeChunking(v);
                chunking = new SizeT[lchunks.length];
                for (int i = 0; i < lchunks.length; ++i) {
                    chunking[i] = new SizeT(lchunks[i]);
                }
            } else {
                chunking = new SizeT[v.getRank()];
            }
            if ((ret = nc4.nc_def_var_chunking(g4.grpid, varid, storage, chunking)) != 0) {
                throw new IOException(nc4.nc_strerror(ret) + " nc_def_var_chunking on variable " + v.getFullName());
            }
            if (isChunked) {
                int shuffle;
                int deflateLevel = this.chunker.getDeflateLevel(v);
                int deflate = deflateLevel > 0 ? 1 : 0;
                int n2 = shuffle = this.chunker.isShuffle(v) ? 1 : 0;
                if (deflateLevel > 0 && (ret = nc4.nc_def_var_deflate(g4.grpid, varid, shuffle, deflate, deflateLevel)) != 0) {
                    throw new IOException(nc4.nc_strerror(ret));
                }
            }
        }
        v.setSPobject(vinfo);
        if (v instanceof Structure) {
            this.createCompoundMemberAtts(g4.grpid, varid, (Structure)v);
        }
        for (Attribute att : v.attributes()) {
            this.writeAttribute(g4.grpid, varid, att, v);
        }
    }

    private void createEnumType(Group4 g4, EnumTypedef en) throws IOException {
        IntByReference typeidp = new IntByReference();
        String name = en.getShortName();
        DataType enumbase = en.getBaseType();
        int basetype = 0;
        if (enumbase == DataType.ENUM1) {
            basetype = 1;
        } else if (enumbase == DataType.ENUM2) {
            basetype = 3;
        } else if (enumbase == DataType.ENUM4) {
            basetype = 4;
        }
        int ret = nc4.nc_def_enum(g4.grpid, basetype, name, typeidp);
        if (ret != 0) {
            throw new IOException(nc4.nc_strerror(ret) + " on\n" + en);
        }
        int typeid = typeidp.getValue();
        ImmutableMap<Integer, String> emap = en.getMap();
        for (Map.Entry entry : emap.entrySet()) {
            IntByReference val = new IntByReference((Integer)entry.getKey());
            ret = nc4.nc_insert_enum(g4.grpid, typeid, (String)entry.getValue(), val);
            if (ret == 0) continue;
            throw new IOException(nc4.nc_strerror(ret) + " on\n" + (String)entry.getValue());
        }
        UserType ut = new UserType(g4.grpid, typeid, name, en.getBaseType().getSize(), basetype, emap.size(), 15);
        this.userTypes.put(typeid, ut);
        en.annotate(UserType.class, ut);
    }

    private void createCompoundType(Group4 g4, Structure s2) throws IOException {
        String name;
        IntByReference typeidp = new IntByReference();
        long size = s2.getElementSize();
        int ret = nc4.nc_def_compound(g4.grpid, new SizeT(size), name = s2.getShortName() + "_t", typeidp);
        if (ret != 0) {
            throw new IOException(nc4.nc_strerror(ret) + " on\n" + s2);
        }
        int typeid = typeidp.getValue();
        ArrayList<Field> flds = new ArrayList<Field>();
        int fldidx = 0;
        long offset = 0L;
        for (Variable v : s2.getVariables()) {
            if (v.getDataType() == DataType.STRING) continue;
            int field_typeid = this.convertDataType(v.getDataType());
            ret = v.isScalar() ? nc4.nc_insert_compound(g4.grpid, typeid, v.getShortName(), new SizeT(offset), field_typeid) : nc4.nc_insert_array_compound(g4.grpid, typeid, v.getShortName(), new SizeT(offset), field_typeid, v.getRank(), v.getShape());
            if (ret != 0) {
                throw new IOException(nc4.nc_strerror(ret) + " on\n" + s2.getShortName());
            }
            Field fld = new Field(g4.grpid, typeid, fldidx, v.getShortName(), (int)offset, field_typeid, v.getRank(), v.getShape());
            flds.add(fld);
            offset += (long)v.getElementSize() * v.getSize();
            ++fldidx;
        }
        s2.setSPobject(new Vinfo(g4, -1, typeidp.getValue()));
        UserType ut = new UserType(g4.grpid, typeid, name, size, 0, fldidx, 16);
        this.userTypes.put(typeid, ut);
        ut.setFields(flds);
    }

    private void createCompoundMemberAtts(int grpid, int varid, Structure s2) throws IOException {
        int sizeAtts = 0;
        for (Variable m3 : s2.getVariables()) {
            for (Attribute att : m3.attributes()) {
                int elemSize;
                if (att.isString()) {
                    String val = att.getStringValue();
                    elemSize = val.getBytes(StandardCharsets.UTF_8).length;
                    if (elemSize == 0) {
                        elemSize = 1;
                    }
                } else {
                    elemSize = att.getDataType().getSize() * att.getLength();
                }
                sizeAtts += elemSize;
            }
        }
        if (sizeAtts == 0) {
            return;
        }
        IntByReference typeidp = new IntByReference();
        String typeName = "_" + s2.getShortName() + "_field_atts_t";
        int ret = nc4.nc_def_compound(grpid, new SizeT((long)sizeAtts), typeName, typeidp);
        if (ret != 0) {
            throw new IOException(nc4.nc_strerror(ret) + " on\n" + s2);
        }
        int typeid = typeidp.getValue();
        ByteBuffer bb = ByteBuffer.allocate(sizeAtts);
        bb.order(ByteOrder.nativeOrder());
        for (Variable m4 : s2.getVariables()) {
            for (Attribute att : m4.attributes()) {
                String val;
                int field_typeid;
                String memberName = m4.getShortName() + ":" + att.getShortName();
                int n = field_typeid = att.isString() ? 2 : this.convertDataType(att.getDataType());
                if (att.isString()) {
                    val = att.getStringValue();
                    int len = val.getBytes(StandardCharsets.UTF_8).length;
                    if (len == 0) {
                        len = 1;
                    }
                    ret = nc4.nc_insert_array_compound(grpid, typeid, memberName, new SizeT((long)bb.position()), field_typeid, 1, new int[]{len});
                } else {
                    ret = !att.isArray() ? nc4.nc_insert_compound(grpid, typeid, memberName, new SizeT((long)bb.position()), field_typeid) : nc4.nc_insert_array_compound(grpid, typeid, memberName, new SizeT((long)bb.position()), field_typeid, 1, new int[]{att.getLength()});
                }
                if (ret != 0) {
                    throw new IOException(nc4.nc_strerror(ret) + " on\n" + s2.getShortName());
                }
                if (att.isString()) {
                    byte[] sby;
                    val = att.getStringValue();
                    for (byte b : sby = val.getBytes(StandardCharsets.UTF_8)) {
                        bb.put(b);
                    }
                    if (sby.length != 0) continue;
                    bb.put((byte)0);
                    continue;
                }
                block14: for (int i = 0; i < att.getLength(); ++i) {
                    switch (att.getDataType()) {
                        case BYTE: {
                            bb.put(att.getNumericValue(i).byteValue());
                            continue block14;
                        }
                        case CHAR: {
                            bb.put(att.getNumericValue(i).byteValue());
                            continue block14;
                        }
                        case DOUBLE: {
                            bb.putDouble(att.getNumericValue(i).doubleValue());
                            continue block14;
                        }
                        case FLOAT: {
                            bb.putFloat(att.getNumericValue(i).floatValue());
                            continue block14;
                        }
                        case INT: {
                            bb.putInt(att.getNumericValue(i).intValue());
                            continue block14;
                        }
                        case LONG: {
                            bb.putLong(att.getNumericValue(i).longValue());
                            continue block14;
                        }
                        case SHORT: {
                            bb.putShort(att.getNumericValue(i).shortValue());
                            continue block14;
                        }
                        default: {
                            throw new IllegalStateException("Att type " + (Object)((Object)att.getDataType()) + " not found");
                        }
                    }
                }
            }
        }
        String attName = "_field_atts";
        ret = nc4.nc_put_att(grpid, varid, attName, typeid, new SizeT(1L), bb.array());
        if (ret != 0) {
            throw new IOException(nc4.nc_strerror(ret) + " on\n" + s2.getShortName());
        }
    }

    private Integer findDimensionId(Group4 g4, Dimension d) {
        if (g4 == null) {
            return null;
        }
        Integer dimid = g4.dimHash.get(d);
        if (dimid == null) {
            dimid = this.findDimensionId(g4.parent, d);
        }
        return dimid;
    }

    private int addDimension(int grpid, String name, int length) throws IOException {
        IntByReference dimidp = new IntByReference();
        int ret = nc4.nc_def_dim(grpid, name, new SizeT((long)length), dimidp);
        if (ret != 0) {
            throw new IOException(ret + ": " + nc4.nc_strerror(ret));
        }
        return dimidp.getValue();
    }

    private void writeAttribute(int grpid, int varid, Attribute att, Variable v) throws IOException {
        if (v != null && att.getShortName().equals("_FillValue")) {
            if (att.getLength() != 1) {
                log.warn("_FillValue length must be one on var = {}", (Object)v.getFullName());
                return;
            }
            if (att.getDataType() != v.getDataType() && (att.getDataType() != DataType.STRING || v.getDataType() != DataType.CHAR)) {
                log.warn("_FillValue type ({}) does not agree with variable '{}' type ({}).", new Object[]{att.getDataType(), v.getFullName(), v.getDataType()});
                return;
            }
        }
        if (att.getShortName().equals("CLASS")) {
            return;
        }
        if (att.getShortName().equals("DIMENSION_LIST")) {
            return;
        }
        if (att.getShortName().equals("DIMENSION_SCALE")) {
            return;
        }
        if (att.getShortName().equals("DIMENSION_LABELS")) {
            return;
        }
        if (att.getShortName().equals("_ChunkSizes")) {
            return;
        }
        if (att.getShortName().equals("_Compress")) {
            return;
        }
        if (att.getShortName().equals("_NCProperties")) {
            return;
        }
        if (att.getShortName().equals("_IsNetcdf4")) {
            return;
        }
        int ret = 0;
        Array values = att.getValues();
        Object arrayStorage = null;
        if (values != null) {
            arrayStorage = values.getStorage();
        }
        switch (att.getDataType()) {
            case STRING: {
                if (v != null && att.getShortName().equals("_FillValue") && att.getLength() == 1 && v.getDataType() == DataType.CHAR) {
                    byte[] svalb = att.getStringValue().getBytes(StandardCharsets.UTF_8);
                    if (svalb.length == 0) {
                        svalb = new byte[]{0};
                    }
                    ret = nc4.nc_put_att_text(grpid, varid, att.getShortName(), new SizeT((long)svalb.length), svalb);
                    break;
                }
                if (this.version != NetcdfFileWriter.Version.netcdf4) {
                    StringBuilder text = new StringBuilder();
                    for (int i = 0; i < att.getLength(); ++i) {
                        text.append(att.getStringValue(i));
                    }
                    byte[] svalb = text.toString().getBytes(StandardCharsets.UTF_8);
                    if (svalb.length == 0) {
                        svalb = new byte[]{0};
                    }
                    ret = nc4.nc_put_att_text(grpid, varid, att.getShortName(), new SizeT((long)svalb.length), svalb);
                    break;
                }
                String[] svalues = new String[att.getLength()];
                for (int i = 0; i < att.getLength(); ++i) {
                    svalues[i] = (String)att.getValue(i);
                }
                ret = nc4.nc_put_att_string(grpid, varid, att.getShortName(), new SizeT((long)att.getLength()), svalues);
                break;
            }
            case UBYTE: {
                ret = nc4.nc_put_att_uchar(grpid, varid, att.getShortName(), 7, new SizeT((long)att.getLength()), (byte[])arrayStorage);
                break;
            }
            case BYTE: {
                ret = nc4.nc_put_att_schar(grpid, varid, att.getShortName(), 1, new SizeT((long)att.getLength()), (byte[])arrayStorage);
                break;
            }
            case CHAR: {
                ret = nc4.nc_put_att_text(grpid, varid, att.getShortName(), new SizeT((long)att.getLength()), IospHelper.convertCharToByte((char[])arrayStorage));
                break;
            }
            case DOUBLE: {
                ret = nc4.nc_put_att_double(grpid, varid, att.getShortName(), 6, new SizeT((long)att.getLength()), (double[])arrayStorage);
                break;
            }
            case FLOAT: {
                ret = nc4.nc_put_att_float(grpid, varid, att.getShortName(), 5, new SizeT((long)att.getLength()), (float[])arrayStorage);
                break;
            }
            case UINT: {
                ret = nc4.nc_put_att_uint(grpid, varid, att.getShortName(), 9, new SizeT((long)att.getLength()), (int[])arrayStorage);
                break;
            }
            case INT: {
                ret = nc4.nc_put_att_int(grpid, varid, att.getShortName(), 4, new SizeT((long)att.getLength()), (int[])arrayStorage);
                break;
            }
            case ULONG: {
                ret = nc4.nc_put_att_ulonglong(grpid, varid, att.getShortName(), 11, new SizeT((long)att.getLength()), (long[])arrayStorage);
                break;
            }
            case LONG: {
                ret = nc4.nc_put_att_longlong(grpid, varid, att.getShortName(), 10, new SizeT((long)att.getLength()), (long[])arrayStorage);
                break;
            }
            case USHORT: {
                ret = nc4.nc_put_att_ushort(grpid, varid, att.getShortName(), 8, new SizeT((long)att.getLength()), (short[])arrayStorage);
                break;
            }
            case SHORT: {
                ret = nc4.nc_put_att_short(grpid, varid, att.getShortName(), 3, new SizeT((long)att.getLength()), (short[])arrayStorage);
            }
        }
        if (ret != 0) {
            String where = v != null ? "var " + v.getFullName() : "global or group attribute";
            throw new IOException(ret + " (" + nc4.nc_strerror(ret) + ") on attribute '" + att + "' on " + where);
        }
    }

    @Override
    public void writeData(Variable v2, Section section, Array values) throws IOException, InvalidRangeException {
        Vinfo vinfo = (Vinfo)v2.getSPobject();
        if (vinfo == null) {
            log.error("vinfo null for " + v2);
            throw new IllegalStateException("vinfo null for " + v2.getFullName());
        }
        this.writeData(v2, vinfo.g4.grpid, vinfo.varid, vinfo.typeid, section, values);
    }

    private void writeData(Variable v, int grpid, int varid, int typeid, Section section, Array values) throws IOException, InvalidRangeException {
        SizeT[] origin = this.convertSizeT(section.getOrigin());
        SizeT[] shape = this.convertSizeT(section.getShape());
        SizeT[] stride = this.convertSizeT(section.getStride());
        boolean isUnsigned = this.isUnsigned(typeid);
        int sectionLen = (int)section.computeSize();
        Object data = values.get1DJavaArray(values.getDataType());
        block0 : switch (typeid) {
            case 1: 
            case 7: {
                int ret;
                byte[] valb = (byte[])data;
                assert (valb.length == sectionLen);
                int n = ret = isUnsigned ? nc4.nc_put_vars_uchar(grpid, varid, origin, shape, stride, valb) : nc4.nc_put_vars_schar(grpid, varid, origin, shape, stride, valb);
                if (ret == 0) break;
                throw new IOException(ret + ": " + nc4.nc_strerror(ret));
            }
            case 2: {
                char[] valc = (char[])data;
                assert (valc.length == sectionLen);
                byte[] valb = IospHelper.convertCharToByte(valc);
                int ret = nc4.nc_put_vars_text(grpid, varid, origin, shape, stride, valb);
                if (ret == 0) break;
                throw new IOException(nc4.nc_strerror(ret));
            }
            case 6: {
                double[] vald = (double[])data;
                assert (vald.length == sectionLen);
                int ret = nc4.nc_put_vars_double(grpid, varid, origin, shape, stride, vald);
                if (ret == 0) break;
                throw new IOException(ret + ": " + nc4.nc_strerror(ret));
            }
            case 5: {
                float[] valf = (float[])data;
                assert (valf.length == sectionLen);
                int ret = nc4.nc_put_vars_float(grpid, varid, origin, shape, stride, valf);
                if (ret == 0) break;
                throw new IOException(nc4.nc_strerror(ret));
            }
            case 4: 
            case 9: {
                int ret;
                int[] vali = (int[])data;
                assert (vali.length == sectionLen);
                int n = ret = isUnsigned ? nc4.nc_put_vars_uint(grpid, varid, origin, shape, stride, vali) : nc4.nc_put_vars_int(grpid, varid, origin, shape, stride, vali);
                if (ret == 0) break;
                throw new IOException(nc4.nc_strerror(ret));
            }
            case 10: 
            case 11: {
                int ret;
                long[] vall = (long[])data;
                assert (vall.length == sectionLen);
                int n = ret = isUnsigned ? nc4.nc_put_vars_ulonglong(grpid, varid, origin, shape, stride, vall) : nc4.nc_put_vars_longlong(grpid, varid, origin, shape, stride, vall);
                if (ret == 0) break;
                throw new IOException(ret + ": " + nc4.nc_strerror(ret));
            }
            case 3: 
            case 8: {
                int ret;
                short[] vals = (short[])data;
                assert (vals.length == sectionLen);
                int n = ret = isUnsigned ? nc4.nc_put_vars_ushort(grpid, varid, origin, shape, stride, vals) : nc4.nc_put_vars_short(grpid, varid, origin, shape, stride, vals);
                if (ret == 0) break;
                throw new IOException(ret + ": " + nc4.nc_strerror(ret));
            }
            case 12: {
                String[] valss = this.convertStringData(data);
                assert (valss.length == sectionLen);
                int ret = nc4.nc_put_vars_string(grpid, varid, origin, shape, stride, valss);
                if (ret == 0) break;
                throw new IOException(ret + ": " + nc4.nc_strerror(ret));
            }
            default: {
                UserType userType = this.userTypes.get(typeid);
                if (userType == null) {
                    throw new IOException("Unknown userType == " + typeid);
                }
                switch (userType.typeClass) {
                    case 15: {
                        int ret = this.writeEnumData(v, userType, grpid, varid, typeid, section, values);
                        if (ret == 0) break block0;
                        throw new IOException(nc4.nc_strerror(ret));
                    }
                    case 16: {
                        this.writeCompoundData((Structure)v, userType, grpid, varid, typeid, section, (ArrayStructure)values);
                        return;
                    }
                    default: {
                        throw new IOException("Unsupported writing of userType= " + userType);
                    }
                }
            }
        }
    }

    private int writeEnumData(Variable v, UserType userType, int grpid, int varid, int typeid, Section section, Array values) throws IOException, InvalidRangeException {
        int ret = 0;
        SizeT[] origin = this.convertSizeT(section.getOrigin());
        SizeT[] shape = this.convertSizeT(section.getShape());
        boolean isUnsigned = this.isUnsigned(typeid);
        int sectionLen = (int)section.computeSize();
        assert (values.getSize() == (long)sectionLen);
        int[] secStride = section.getStride();
        boolean stride1 = this.isStride1(secStride);
        ByteBuffer bb = values.getDataAsByteBuffer(ByteOrder.nativeOrder());
        byte[] data = bb.array();
        if (stride1) {
            ret = nc4.nc_put_vara(grpid, varid, origin, shape, data);
        } else {
            SizeT[] stride = this.convertSizeT(secStride);
            ret = nc4.nc_put_vars(grpid, varid, origin, shape, stride, data);
        }
        return ret;
    }

    private void writeCompoundData(Structure s2, UserType userType, int grpid, int varid, int typeid, Section section, ArrayStructure values) throws IOException, InvalidRangeException {
        SizeT[] origin = this.convertSizeT(section.getOrigin());
        SizeT[] shape = this.convertSizeT(section.getShape());
        SizeT[] stride = this.convertSizeT(section.getStride());
        ArrayStructureBB valuesBB = StructureDataDeep.copyToArrayBB(s2, values, ByteOrder.nativeOrder());
        ByteBuffer bbuff = valuesBB.getByteBuffer();
        int ret = section.isStrided() ? nc4.nc_put_vars(grpid, varid, origin, shape, stride, bbuff.array()) : nc4.nc_put_vara(grpid, varid, origin, shape, bbuff.array());
        if (ret != 0) {
            throw new IOException(this.errMessage("nc_put_vars", ret, grpid, varid));
        }
    }

    @Override
    public int appendStructureData(Structure s2, StructureData sdata) throws IOException, InvalidRangeException {
        SizeTByReference lenp;
        Vinfo vinfo = (Vinfo)s2.getSPobject();
        Dimension dim = s2.getDimension(0);
        int dimid = vinfo.g4.dimHash.get(dim);
        int ret = nc4.nc_inq_dimlen(vinfo.g4.grpid, dimid, lenp = new SizeTByReference());
        if (ret != 0) {
            throw new IOException(this.errMessage("nc_inq_dimlen", ret, vinfo.g4.grpid, dimid));
        }
        SizeT[] origin = new SizeT[]{lenp.getValue()};
        SizeT[] shape = new SizeT[]{new SizeT(1L)};
        SizeT[] stride = new SizeT[]{new SizeT(1L)};
        ByteBuffer bbuff = this.makeBB(s2, sdata);
        ret = nc4.nc_put_vars(vinfo.g4.grpid, vinfo.varid, origin, shape, stride, bbuff.array());
        if (ret != 0) {
            throw new IOException(this.errMessage("appendStructureData (nc_put_vars)", ret, vinfo.g4.grpid, vinfo.varid));
        }
        return origin[0].intValue();
    }

    private String errMessage(String what, int ret, int grpid, int varid) {
        Formatter f = new Formatter();
        f.format("%s: %d: %s grpid=%d objid=%d", what, ret, nc4.nc_strerror(ret), grpid, varid);
        return f.toString();
    }

    private ByteBuffer makeBB(Structure s2, StructureData sdata) {
        int size = s2.getElementSize();
        ByteBuffer bb = ByteBuffer.allocate(size);
        bb.order(ByteOrder.nativeOrder());
        long offset = 0L;
        for (Variable v : s2.getVariables()) {
            if (v.getDataType() == DataType.STRING) continue;
            StructureMembers.Member m3 = sdata.findMember(v.getShortName());
            if (m3 == null) {
                log.warn("WARN Nc4Iosp.makeBB() cant find {}", (Object)v.getShortName());
                bb.position((int)(offset + (long)v.getElementSize() * v.getSize()));
            } else {
                this.copy(sdata, m3, bb);
            }
            offset += (long)v.getElementSize() * v.getSize();
        }
        return bb;
    }

    private void copy(StructureData sdata, StructureMembers.Member m3, ByteBuffer bb) {
        block26: {
            DataType dtype;
            block25: {
                dtype = m3.getDataType();
                if (!m3.isScalar()) break block25;
                switch (dtype) {
                    case FLOAT: {
                        bb.putFloat(sdata.getScalarFloat(m3));
                        break block26;
                    }
                    case DOUBLE: {
                        bb.putDouble(sdata.getScalarDouble(m3));
                        break block26;
                    }
                    case ENUM4: 
                    case INT: {
                        bb.putInt(sdata.getScalarInt(m3));
                        break block26;
                    }
                    case ENUM2: 
                    case SHORT: {
                        bb.putShort(sdata.getScalarShort(m3));
                        break block26;
                    }
                    case ENUM1: 
                    case BYTE: {
                        bb.put(sdata.getScalarByte(m3));
                        break block26;
                    }
                    case CHAR: {
                        bb.put((byte)sdata.getScalarChar(m3));
                        break block26;
                    }
                    case LONG: {
                        bb.putLong(sdata.getScalarLong(m3));
                        break block26;
                    }
                    default: {
                        throw new IllegalStateException("scalar " + (Object)((Object)dtype));
                    }
                }
            }
            int n = m3.getSize();
            switch (dtype) {
                case FLOAT: {
                    float[] fdata = sdata.getJavaArrayFloat(m3);
                    for (int i = 0; i < n; ++i) {
                        bb.putFloat(fdata[i]);
                    }
                    break;
                }
                case DOUBLE: {
                    double[] ddata = sdata.getJavaArrayDouble(m3);
                    for (int i = 0; i < n; ++i) {
                        bb.putDouble(ddata[i]);
                    }
                    break;
                }
                case ENUM4: 
                case INT: {
                    int[] idata = sdata.getJavaArrayInt(m3);
                    for (int i = 0; i < n; ++i) {
                        bb.putInt(idata[i]);
                    }
                    break;
                }
                case ENUM2: 
                case SHORT: {
                    short[] shdata = sdata.getJavaArrayShort(m3);
                    for (int i = 0; i < n; ++i) {
                        bb.putShort(shdata[i]);
                    }
                    break;
                }
                case ENUM1: 
                case BYTE: {
                    byte[] bdata = sdata.getJavaArrayByte(m3);
                    for (int i = 0; i < n; ++i) {
                        bb.put(bdata[i]);
                    }
                    break;
                }
                case CHAR: {
                    char[] cdata = sdata.getJavaArrayChar(m3);
                    bb.put(IospHelper.convertCharToByte(cdata));
                    break;
                }
                case LONG: {
                    long[] ldata = sdata.getJavaArrayLong(m3);
                    for (int i = 0; i < n; ++i) {
                        bb.putLong(ldata[i]);
                    }
                    break;
                }
                default: {
                    throw new IllegalStateException("array " + (Object)((Object)dtype));
                }
                case SEQUENCE: 
            }
        }
    }

    private String[] convertStringData(Object org) throws IOException {
        if (org instanceof String[]) {
            return (String[])org;
        }
        if (org instanceof Object[]) {
            Object[] oo = (Object[])org;
            String[] result = new String[oo.length];
            int count = 0;
            for (Object s2 : oo) {
                result[count++] = (String)s2;
            }
            return result;
        }
        throw new IOException("convertStringData failed on class = " + org.getClass().getName());
    }

    @Override
    public void flush() throws IOException {
        if (nc4 == null || this.ncid < 0) {
            return;
        }
        int ret = nc4.nc_sync(this.ncid);
        if (ret != 0) {
            throw new IOException(ret + ": " + nc4.nc_strerror(ret));
        }
        this.updateDimensions(this.ncfile.getRootGroup());
    }

    public Nc4Iosp setAddReserved(boolean tf) {
        this.markreserved = tf;
        return this;
    }

    @Override
    public void setFill(boolean fill) {
        this.fill = fill;
        try {
            this._setFill();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private void _setFill() throws IOException {
        IntByReference old_modep;
        if (nc4 == null || this.ncid < 0) {
            return;
        }
        int ret = nc4.nc_set_fill(this.ncid, this.fill ? 0 : 256, old_modep = new IntByReference());
        if (ret != 0) {
            throw new IOException(ret + ": " + nc4.nc_strerror(ret));
        }
    }

    @Override
    public boolean rewriteHeader(boolean largeFile) throws IOException {
        return false;
    }

    @Override
    public void updateAttribute(Variable v2, Attribute att) throws IOException {
        if (nc4 == null || this.ncid < 0) {
            return;
        }
        if (v2 == null) {
            this.writeAttribute(this.ncid, -1, att, null);
        } else {
            Vinfo vinfo = (Vinfo)v2.getSPobject();
            this.writeAttribute(vinfo.g4.grpid, vinfo.varid, att, v2);
        }
    }

    public static long getNativeAddr(int pos, ByteBuffer buf) {
        return Platform.is64Bit() ? buf.getLong(pos) : (long)buf.getInt(pos);
    }

    @Override
    public Object sendIospMessage(Object message) {
        if (message instanceof Map) {
            Map map = (Map)message;
            for (Object okey : map.keySet()) {
                String key = okey.toString();
                if (!key.equalsIgnoreCase(TRANSLATECONTROL)) continue;
                String value = map.get(okey).toString();
                if (value.equalsIgnoreCase(TRANSLATE_NONE)) {
                    this.markreserved = false;
                    continue;
                }
                if (!value.equalsIgnoreCase(TRANSLATE_NC4)) continue;
                this.markreserved = true;
            }
        }
        if (message.equals("NetcdfFileFormat")) {
            return this.version;
        }
        return super.sendIospMessage(message);
    }

    private static class ConvertedType {
        DataType dt;
        boolean isVlen;

        ConvertedType(DataType dt) {
            this.dt = dt;
        }
    }

    private class Field {
        int grpid;
        int typeid;
        int fldidx;
        String name;
        int offset;
        int fldtypeid;
        int ndims;
        int[] dims;
        ConvertedType ctype;
        Array data;

        Field(int grpid, int typeid, int fldidx, String name, int offset, int fldtypeid, int ndims, int[] dimz) {
            this.grpid = grpid;
            this.typeid = typeid;
            this.fldidx = fldidx;
            this.name = name;
            this.offset = offset;
            this.fldtypeid = fldtypeid;
            this.ndims = ndims;
            this.dims = new int[ndims];
            System.arraycopy(dimz, 0, this.dims, 0, ndims);
            this.ctype = Nc4Iosp.this.convertDataType(fldtypeid);
            if (Nc4Iosp.this.isVlen(fldtypeid)) {
                int[] edims = new int[ndims + 1];
                if (ndims > 0) {
                    System.arraycopy(dimz, 0, edims, 0, ndims);
                }
                edims[ndims] = -1;
                this.dims = edims;
                ++this.ndims;
            }
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Field field = (Field)o;
            return this.grpid == field.grpid && this.typeid == field.typeid && this.fldidx == field.fldidx && this.offset == field.offset && this.fldtypeid == field.fldtypeid && this.ndims == field.ndims && Objects.equals(this.name, field.name) && Arrays.equals(this.dims, field.dims);
        }

        public int hashCode() {
            return Objects.hash(this.grpid, this.typeid, this.fldidx, this.name, this.offset, this.fldtypeid, this.ndims, this.dims);
        }

        public String toString2() {
            return "name='" + this.name + " fldtypeid=" + Nc4Iosp.this.getDataTypeName(this.fldtypeid) + " ndims=" + this.ndims + " offset=" + this.offset;
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            sb.append("Field");
            sb.append("{grpid=").append(this.grpid);
            sb.append(", typeid=").append(this.typeid);
            sb.append(", fldidx=").append(this.fldidx);
            sb.append(", name='").append(this.name).append('\'');
            sb.append(", offset=").append(this.offset);
            sb.append(", fldtypeid=").append(this.fldtypeid);
            sb.append(", ndims=").append(this.ndims);
            sb.append(", dims=").append(this.dims == null ? "null" : "");
            for (int i = 0; this.dims != null && i < this.dims.length; ++i) {
                sb.append(i == 0 ? "" : ", ").append(this.dims[i]);
            }
            sb.append(", dtype=").append((Object)this.ctype.dt);
            if (this.ctype.isVlen) {
                sb.append("(vlen)");
            }
            sb.append('}');
            return sb.toString();
        }

        Variable makeMemberVariable(Group g2, Structure parent) throws IOException {
            Variable v = Nc4Iosp.this.makeVariable(g2, parent, this.name, this.fldtypeid, "");
            try {
                v.setDimensionsAnonymous(this.dims);
            }
            catch (InvalidRangeException e) {
                e.printStackTrace();
            }
            return v;
        }
    }

    private class UserType {
        int grpid;
        int typeid;
        String name;
        int size;
        int baseTypeid;
        long nfields;
        int typeClass;
        EnumTypedef e;
        List<Field> flds;

        UserType(int grpid, int typeid, String name, long size, int baseTypeid, long nfields, int typeClass) throws IOException {
            this.grpid = grpid;
            this.typeid = typeid;
            this.name = name;
            this.size = (int)size;
            this.baseTypeid = baseTypeid;
            this.nfields = nfields;
            this.typeClass = typeClass;
            if (typeClass == 16) {
                this.readFields();
            }
        }

        public UserType setSize(int size) {
            this.size = size;
            return this;
        }

        DataType getEnumBaseType() {
            if (this.baseTypeid > 0 && this.baseTypeid <= 12) {
                DataType cdmtype;
                switch (this.baseTypeid) {
                    case 1: 
                    case 2: 
                    case 7: {
                        cdmtype = DataType.ENUM1;
                        break;
                    }
                    case 3: 
                    case 8: {
                        cdmtype = DataType.ENUM2;
                        break;
                    }
                    default: {
                        cdmtype = DataType.ENUM4;
                    }
                }
                return cdmtype;
            }
            return null;
        }

        void addField(Field fld) {
            if (this.flds == null) {
                this.flds = new ArrayList<Field>(10);
            }
            this.flds.add(fld);
        }

        void setFields(List<Field> flds) {
            this.flds = flds;
        }

        public String toString2() {
            return "name='" + this.name + "' id=" + Nc4Iosp.this.getDataTypeName(this.typeid) + " userType=" + Nc4Iosp.this.getDataTypeName(this.typeClass) + " baseType=" + Nc4Iosp.this.getDataTypeName(this.baseTypeid);
        }

        public String toString() {
            return "UserType{grpid=" + this.grpid + ", typeid=" + this.typeid + ", name='" + this.name + '\'' + ", size=" + this.size + ", baseTypeid=" + this.baseTypeid + ", nfields=" + this.nfields + ", typeClass=" + this.typeClass + ", e=" + this.e + '}';
        }

        void readFields() throws IOException {
            int fldidx = 0;
            while ((long)fldidx < this.nfields) {
                byte[] fldname = new byte[257];
                IntByReference field_typeidp = new IntByReference();
                IntByReference ndimsp = new IntByReference();
                SizeTByReference offsetp = new SizeTByReference();
                int[] dims = new int[1024];
                int ret = nc4.nc_inq_compound_field(this.grpid, this.typeid, fldidx, fldname, offsetp, field_typeidp, ndimsp, dims);
                if (ret != 0) {
                    throw new IOException(ret + ": " + nc4.nc_strerror(ret));
                }
                Field fld = new Field(this.grpid, this.typeid, fldidx, Nc4Iosp.this.makeString(fldname), offsetp.getValue().intValue(), field_typeidp.getValue(), ndimsp.getValue(), dims);
                this.addField(fld);
                ++fldidx;
            }
        }
    }

    private static class Group4 {
        final int grpid;
        final Group g;
        final Group4 parent;
        Map<Dimension, Integer> dimHash;

        Group4(int grpid, Group g2, Group4 parent) {
            this.grpid = grpid;
            this.g = g2;
            this.parent = parent;
        }
    }

    private static class Vinfo {
        final Group4 g4;
        int varid;
        int typeid;
        UserType utype;

        Vinfo(Group4 g4, int varid, int typeid) {
            this.g4 = g4;
            this.varid = varid;
            this.typeid = typeid;
        }
    }
}

