/*
 * Decompiled with CFR 0.152.
 */
package opendap.dap.Server;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import opendap.dap.Server.AbstractClause;
import opendap.dap.Server.DAP2ServerSideException;
import opendap.dap.Server.Operator;
import opendap.dap.Server.SubClause;
import opendap.dap.Server.TopLevelClause;
import opendap.dap.parser.ExprParserConstants;

public class RelOpClause
extends AbstractClause
implements TopLevelClause {
    protected boolean value;
    protected int operator;
    protected SubClause lhs;
    protected List rhs;

    protected RelOpClause(int operator, SubClause lhs, List rhs) throws DAP2ServerSideException {
        this.operator = operator;
        this.lhs = lhs;
        this.rhs = rhs;
        this.children = new ArrayList();
        this.children.add(lhs);
        this.children.addAll(rhs);
        this.constant = true;
        for (SubClause current : this.children) {
            current.setParent(this);
            if (current.isConstant()) continue;
            this.constant = false;
        }
        if (this.constant) {
            this.evaluate();
        }
    }

    public boolean getValue() {
        return this.value;
    }

    public boolean evaluate() throws DAP2ServerSideException {
        if (this.constant && this.defined) {
            return this.value;
        }
        if (this.rhs.size() == 1) {
            this.value = Operator.op(this.operator, this.lhs.evaluate(), ((SubClause)this.rhs.get(0)).evaluate());
        } else {
            this.value = false;
            Iterator it = this.rhs.iterator();
            while (it.hasNext() && !this.value) {
                if (!Operator.op(this.operator, this.lhs.evaluate(), ((SubClause)it.next()).evaluate())) continue;
                this.value = true;
            }
        }
        this.defined = true;
        return this.value;
    }

    public SubClause getLHS() {
        return this.lhs;
    }

    public List getRHS() {
        return this.rhs;
    }

    public int getOperator() {
        return this.operator;
    }

    public String toString() {
        StringBuffer buf = new StringBuffer();
        buf.append(this.lhs.toString());
        String op = ExprParserConstants.tokenImage[this.operator];
        op = op.substring(1, op.length() - 1);
        buf.append(op);
        if (this.rhs.size() == 1) {
            buf.append(this.rhs.get(0).toString());
        } else {
            buf.append("{");
            Iterator it = this.rhs.iterator();
            buf.append(it.next());
            while (it.hasNext()) {
                buf.append(",");
                buf.append(it.next().toString());
            }
            buf.append("}");
        }
        return buf.toString();
    }
}

