/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.hssf.record.formula;

import org.apache.poi.hssf.record.RecordInputStream;
import org.apache.poi.hssf.record.formula.OperandPtg;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.util.LittleEndian;

public final class NameXPtg
extends OperandPtg {
    public static final short sid = 57;
    private static final int SIZE = 7;
    private short field_1_ixals;
    private short field_2_ilbl;
    private short field_3_reserved;

    public NameXPtg(RecordInputStream in) {
        this.field_1_ixals = in.readShort();
        this.field_2_ilbl = in.readShort();
        this.field_3_reserved = in.readShort();
    }

    public void writeBytes(byte[] array, int offset) {
        array[offset + 0] = (byte)(57 + this.getPtgClass());
        LittleEndian.putShort(array, offset + 1, this.field_1_ixals);
        LittleEndian.putShort(array, offset + 3, this.field_2_ilbl);
        LittleEndian.putShort(array, offset + 5, this.field_3_reserved);
    }

    public int getSize() {
        return 7;
    }

    public String toFormulaString(HSSFWorkbook book) {
        return book.resolveNameXText(this.field_1_ixals, this.field_2_ilbl - 1);
    }

    public byte getDefaultOperandClass() {
        return 32;
    }
}

