/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.hssf.record.formula.functions;

import org.apache.poi.hssf.record.formula.eval.AreaEval;
import org.apache.poi.hssf.record.formula.eval.BlankEval;
import org.apache.poi.hssf.record.formula.eval.Eval;
import org.apache.poi.hssf.record.formula.eval.NumericValueEval;
import org.apache.poi.hssf.record.formula.eval.Ref2DEval;
import org.apache.poi.hssf.record.formula.eval.ValueEval;
import org.apache.poi.hssf.record.formula.eval.ValueEvalToNumericXlator;
import org.apache.poi.hssf.record.formula.functions.NumericFunction;

public abstract class MultiOperandNumericFunction
extends NumericFunction {
    static final double[] EMPTY_DOUBLE_ARRAY = new double[0];
    private static final int DEFAULT_MAX_NUM_OPERANDS = 30;

    protected abstract ValueEvalToNumericXlator getXlator();

    protected int getMaxNumOperands() {
        return 30;
    }

    protected double[] getNumberArray(Eval[] operands, int srcRow, short srcCol) {
        if (operands.length > this.getMaxNumOperands()) {
            return null;
        }
        DoubleList retval = new DoubleList();
        int iSize = operands.length;
        for (int i = 0; i < iSize; ++i) {
            double[] temp = this.getNumberArray(operands[i], srcRow, srcCol);
            if (temp == null) {
                return null;
            }
            retval.add(temp);
        }
        return retval.toArray();
    }

    protected double[] getNumberArray(Eval operand, int srcRow, short srcCol) {
        if (operand instanceof AreaEval) {
            AreaEval ae = (AreaEval)operand;
            ValueEval[] values = ae.getValues();
            DoubleList retval = new DoubleList();
            int jSize = values.length;
            for (int j = 0; j < jSize; ++j) {
                Ref2DEval re = new Ref2DEval(null, values[j]);
                ValueEval ve = this.singleOperandEvaluate(re, srcRow, srcCol);
                if (ve instanceof NumericValueEval) {
                    NumericValueEval nve = (NumericValueEval)ve;
                    retval.add(nve.getNumberValue());
                    continue;
                }
                if (ve instanceof BlankEval) continue;
                return null;
            }
            return retval.toArray();
        }
        ValueEval ve = this.singleOperandEvaluate(operand, srcRow, srcCol);
        if (ve instanceof NumericValueEval) {
            NumericValueEval nve = (NumericValueEval)ve;
            return new double[]{nve.getNumberValue()};
        }
        if (ve instanceof BlankEval) {
            return EMPTY_DOUBLE_ARRAY;
        }
        return null;
    }

    protected static final boolean areSubArraysConsistent(double[][] values) {
        if (values == null || values.length < 1) {
            return true;
        }
        if (values[0] == null) {
            return false;
        }
        int outerMax = values.length;
        int innerMax = values[0].length;
        for (int i = 1; i < outerMax; ++i) {
            double[] subArr = values[i];
            if (subArr == null) {
                return false;
            }
            if (innerMax == subArr.length) continue;
            return false;
        }
        return true;
    }

    private static class DoubleList {
        private double[] _array = new double[8];
        private int _count = 0;

        public double[] toArray() {
            if (this._count < 1) {
                return EMPTY_DOUBLE_ARRAY;
            }
            double[] result = new double[this._count];
            System.arraycopy(this._array, 0, result, 0, this._count);
            return result;
        }

        public void add(double[] values) {
            int addLen = values.length;
            this.ensureCapacity(this._count + addLen);
            System.arraycopy(values, 0, this._array, this._count, addLen);
            this._count += addLen;
        }

        private void ensureCapacity(int reqSize) {
            if (reqSize > this._array.length) {
                int newSize = reqSize * 3 / 2;
                double[] newArr = new double[newSize];
                System.arraycopy(this._array, 0, newArr, 0, this._count);
                this._array = newArr;
            }
        }

        public void add(double value) {
            this.ensureCapacity(this._count + 1);
            this._array[this._count] = value;
            ++this._count;
        }
    }
}

