/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.hslf;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import org.apache.poi.POIDocument;
import org.apache.poi.hslf.EncryptedSlideShow;
import org.apache.poi.hslf.exceptions.CorruptPowerPointFileException;
import org.apache.poi.hslf.exceptions.EncryptedPowerPointFileException;
import org.apache.poi.hslf.exceptions.HSLFException;
import org.apache.poi.hslf.record.CurrentUserAtom;
import org.apache.poi.hslf.record.ExOleObjStg;
import org.apache.poi.hslf.record.PersistPtrHolder;
import org.apache.poi.hslf.record.PersistRecord;
import org.apache.poi.hslf.record.PositionDependentRecord;
import org.apache.poi.hslf.record.Record;
import org.apache.poi.hslf.record.UserEditAtom;
import org.apache.poi.hslf.usermodel.ObjectData;
import org.apache.poi.hslf.usermodel.PictureData;
import org.apache.poi.poifs.filesystem.DirectoryNode;
import org.apache.poi.poifs.filesystem.DocumentEntry;
import org.apache.poi.poifs.filesystem.DocumentInputStream;
import org.apache.poi.poifs.filesystem.POIFSFileSystem;
import org.apache.poi.util.LittleEndian;
import org.apache.poi.util.POILogFactory;
import org.apache.poi.util.POILogger;

public class HSLFSlideShow
extends POIDocument {
    private POILogger logger = POILogFactory.getLogger(((Object)((Object)this)).getClass());
    private InputStream istream;
    private CurrentUserAtom currentUser;
    private byte[] _docstream;
    private Record[] _records;
    private PictureData[] _pictures;
    private ObjectData[] _objects;
    static /* synthetic */ Class class$org$apache$poi$hslf$HSLFSlideShow;

    protected POIFSFileSystem getPOIFSFileSystem() {
        return this.filesystem;
    }

    public HSLFSlideShow(String fileName) throws IOException {
        this(new FileInputStream(fileName));
    }

    public HSLFSlideShow(InputStream inputStream) throws IOException {
        this(new POIFSFileSystem(inputStream));
        this.istream = inputStream;
    }

    public HSLFSlideShow(POIFSFileSystem filesystem) throws IOException {
        this(filesystem.getRoot(), filesystem);
    }

    public HSLFSlideShow(DirectoryNode dir, POIFSFileSystem filesystem) throws IOException {
        super(dir, filesystem);
        this.readCurrentUserStream();
        this.readPowerPointStream();
        boolean encrypted = EncryptedSlideShow.checkIfEncrypted(this);
        if (encrypted) {
            throw new EncryptedPowerPointFileException("Encrypted PowerPoint files are not supported");
        }
        this.buildRecords();
        this.readProperties();
        this.readOtherStreams();
        this.readPictures();
    }

    public HSLFSlideShow() throws IOException {
        this((class$org$apache$poi$hslf$HSLFSlideShow == null ? (class$org$apache$poi$hslf$HSLFSlideShow = HSLFSlideShow.class$("org.apache.poi.hslf.HSLFSlideShow")) : class$org$apache$poi$hslf$HSLFSlideShow).getResourceAsStream("/org/apache/poi/hslf/data/empty.ppt"));
    }

    public void close() throws IOException {
        if (this.istream != null) {
            this.istream.close();
        }
        this.filesystem = null;
    }

    private void readPowerPointStream() throws IOException {
        DocumentEntry docProps = (DocumentEntry)this.directory.getEntry("PowerPoint Document");
        this._docstream = new byte[docProps.getSize()];
        this.directory.createDocumentInputStream("PowerPoint Document").read(this._docstream);
    }

    private void buildRecords() {
        this._records = this.read(this._docstream, (int)this.currentUser.getCurrentEditOffset());
    }

    private Record[] read(byte[] docstream, int usrOffset) {
        Integer id;
        ArrayList<Integer> lst = new ArrayList<Integer>();
        HashMap<Integer, Integer> offset2id = new HashMap<Integer, Integer>();
        while (usrOffset != 0) {
            UserEditAtom usr = (UserEditAtom)Record.buildRecordAtOffset(docstream, usrOffset);
            lst.add(new Integer(usrOffset));
            int psrOffset = usr.getPersistPointersOffset();
            PersistPtrHolder ptr = (PersistPtrHolder)Record.buildRecordAtOffset(docstream, psrOffset);
            lst.add(new Integer(psrOffset));
            Hashtable entries = ptr.getSlideLocationsLookup();
            Iterator it = entries.keySet().iterator();
            while (it.hasNext()) {
                id = (Integer)it.next();
                Integer offset = (Integer)entries.get(id);
                lst.add(offset);
                offset2id.put(offset, id);
            }
            usrOffset = usr.getLastUserEditAtomOffset();
        }
        Object[] a = lst.toArray();
        Arrays.sort(a);
        Record[] rec = new Record[lst.size()];
        for (int i = 0; i < a.length; ++i) {
            Integer offset = (Integer)a[i];
            rec[i] = Record.buildRecordAtOffset(docstream, offset);
            if (!(rec[i] instanceof PersistRecord)) continue;
            PersistRecord psr = (PersistRecord)((Object)rec[i]);
            id = (Integer)offset2id.get(offset);
            psr.setPersistId(id);
        }
        return rec;
    }

    private void readCurrentUserStream() {
        try {
            this.currentUser = new CurrentUserAtom(this.directory);
        }
        catch (IOException ie) {
            this.logger.log(7, (Object)("Error finding Current User Atom:\n" + ie));
            this.currentUser = new CurrentUserAtom();
        }
    }

    private void readOtherStreams() {
    }

    private void readPictures() throws IOException {
        int imgsize;
        byte[] pictstream;
        try {
            DocumentEntry entry = (DocumentEntry)this.directory.getEntry("Pictures");
            pictstream = new byte[entry.getSize()];
            DocumentInputStream is = this.directory.createDocumentInputStream("Pictures");
            is.read(pictstream);
        }
        catch (FileNotFoundException e) {
            return;
        }
        ArrayList<PictureData> p = new ArrayList<PictureData>();
        for (int pos = 0; pos <= pictstream.length - 8; pos += imgsize) {
            int offset = pos;
            int signature = LittleEndian.getUShort((byte[])pictstream, (int)pos);
            int type = LittleEndian.getUShort((byte[])pictstream, (int)(pos += 2));
            imgsize = LittleEndian.getInt((byte[])pictstream, (int)(pos += 2));
            pos += 4;
            if (imgsize < 0) {
                throw new CorruptPowerPointFileException("The file contains a picture, at position " + p.size() + ", which has a negatively sized data length, so we can't trust any of the picture data");
            }
            if (type == 0) {
                this.logger.log(7, (Object)("Problem reading picture: Invalid image type 0, on picture with length " + imgsize + ".\nYou document will probably become corrupted if you save it!"));
                this.logger.log(7, (Object)("" + pos));
                continue;
            }
            byte[] imgdata = new byte[imgsize];
            if (imgsize > 0) {
                System.arraycopy(pictstream, pos, imgdata, 0, imgdata.length);
            }
            try {
                PictureData pict = PictureData.create(type - 61464);
                pict.setRawData(imgdata);
                pict.setOffset(offset);
                p.add(pict);
                continue;
            }
            catch (IllegalArgumentException e) {
                this.logger.log(7, (Object)("Problem reading picture: " + e + "\nYou document will probably become corrupted if you save it!"));
            }
        }
        this._pictures = p.toArray(new PictureData[p.size()]);
    }

    public void write(OutputStream out) throws IOException {
        this.write(out, false);
    }

    public void write(OutputStream out, boolean preserveNodes) throws IOException {
        PositionDependentRecord pdr;
        int i;
        POIFSFileSystem outFS = new POIFSFileSystem();
        ArrayList<String> writtenEntries = new ArrayList<String>(1);
        this.writeProperties(outFS, writtenEntries);
        Hashtable<Integer, Integer> oldToNewPositions = new Hashtable<Integer, Integer>();
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        for (i = 0; i < this._records.length; ++i) {
            if (this._records[i] instanceof PositionDependentRecord) {
                pdr = (PositionDependentRecord)((Object)this._records[i]);
                int oldPos = pdr.getLastOnDiskOffset();
                int newPos = baos.size();
                pdr.setLastOnDiskOffset(newPos);
                oldToNewPositions.put(new Integer(oldPos), new Integer(newPos));
            }
            this._records[i].writeOut(baos);
        }
        baos.reset();
        for (i = 0; i < this._records.length; ++i) {
            if (this._records[i] instanceof PositionDependentRecord) {
                pdr = (PositionDependentRecord)((Object)this._records[i]);
                pdr.updateOtherRecordReferences(oldToNewPositions);
            }
            this._records[i].writeOut(baos);
        }
        this._docstream = baos.toByteArray();
        ByteArrayInputStream bais = new ByteArrayInputStream(baos.toByteArray());
        outFS.createDocument((InputStream)bais, "PowerPoint Document");
        writtenEntries.add("PowerPoint Document");
        int oldLastUserEditAtomPos = (int)this.currentUser.getCurrentEditOffset();
        Integer newLastUserEditAtomPos = (Integer)oldToNewPositions.get(new Integer(oldLastUserEditAtomPos));
        if (newLastUserEditAtomPos == null) {
            throw new HSLFException("Couldn't find the new location of the UserEditAtom that used to be at " + oldLastUserEditAtomPos);
        }
        this.currentUser.setCurrentEditOffset(newLastUserEditAtomPos.intValue());
        this.currentUser.writeToFS(outFS);
        writtenEntries.add("Current User");
        if (this._pictures != null) {
            ByteArrayOutputStream pict = new ByteArrayOutputStream();
            for (int i2 = 0; i2 < this._pictures.length; ++i2) {
                this._pictures[i2].write(pict);
            }
            outFS.createDocument((InputStream)new ByteArrayInputStream(pict.toByteArray()), "Pictures");
            writtenEntries.add("Pictures");
        }
        if (preserveNodes) {
            this.copyNodes(this.filesystem, outFS, writtenEntries);
        }
        outFS.writeFilesystem(out);
    }

    public synchronized int appendRootLevelRecord(Record newRecord) {
        int addedAt = -1;
        Record[] r = new Record[this._records.length + 1];
        boolean added = false;
        for (int i = this._records.length - 1; i >= 0; --i) {
            if (added) {
                r[i] = this._records[i];
                continue;
            }
            r[i + 1] = this._records[i];
            if (!(this._records[i] instanceof PersistPtrHolder)) continue;
            r[i] = newRecord;
            added = true;
            addedAt = i;
        }
        this._records = r;
        return addedAt;
    }

    public void addPicture(PictureData img) {
        PictureData[] lst;
        if (this._pictures == null) {
            lst = new PictureData[1];
        } else {
            lst = new PictureData[this._pictures.length + 1];
            System.arraycopy(this._pictures, 0, lst, 0, this._pictures.length);
        }
        lst[lst.length - 1] = img;
        this._pictures = lst;
    }

    public Record[] getRecords() {
        return this._records;
    }

    public byte[] getUnderlyingBytes() {
        return this._docstream;
    }

    public CurrentUserAtom getCurrentUserAtom() {
        return this.currentUser;
    }

    public PictureData[] getPictures() {
        return this._pictures;
    }

    public ObjectData[] getEmbeddedObjects() {
        if (this._objects == null) {
            ArrayList<ObjectData> objects = new ArrayList<ObjectData>();
            for (int i = 0; i < this._records.length; ++i) {
                if (!(this._records[i] instanceof ExOleObjStg)) continue;
                objects.add(new ObjectData((ExOleObjStg)this._records[i]));
            }
            this._objects = objects.toArray(new ObjectData[objects.size()]);
        }
        return this._objects;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

