/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.hwpf.usermodel;

import org.apache.poi.hwpf.model.PAPX;
import org.apache.poi.hwpf.sprm.SprmBuffer;
import org.apache.poi.hwpf.sprm.TableSprmCompressor;
import org.apache.poi.hwpf.usermodel.BorderCode;
import org.apache.poi.hwpf.usermodel.DropCapSpecifier;
import org.apache.poi.hwpf.usermodel.LineSpacingDescriptor;
import org.apache.poi.hwpf.usermodel.ParagraphProperties;
import org.apache.poi.hwpf.usermodel.Range;
import org.apache.poi.hwpf.usermodel.ShadingDescriptor;
import org.apache.poi.hwpf.usermodel.Table;
import org.apache.poi.hwpf.usermodel.TableProperties;

public class Paragraph
extends Range
implements Cloneable {
    public static final short SPRM_JC = 9219;
    public static final short SPRM_FSIDEBYSIDE = 9220;
    public static final short SPRM_FKEEP = 9221;
    public static final short SPRM_FKEEPFOLLOW = 9222;
    public static final short SPRM_FPAGEBREAKBEFORE = 9223;
    public static final short SPRM_BRCL = 9224;
    public static final short SPRM_BRCP = 9225;
    public static final short SPRM_ILVL = 9738;
    public static final short SPRM_ILFO = 17931;
    public static final short SPRM_FNOLINENUMB = 9228;
    public static final short SPRM_CHGTABSPAPX = -14835;
    public static final short SPRM_DXARIGHT = -31730;
    public static final short SPRM_DXALEFT = -31729;
    public static final short SPRM_DXALEFT1 = -31727;
    public static final short SPRM_DYALINE = 25618;
    public static final short SPRM_DYABEFORE = -23533;
    public static final short SPRM_DYAAFTER = -23532;
    public static final short SPRM_CHGTABS = -14827;
    public static final short SPRM_FINTABLE = 9238;
    public static final short SPRM_FTTP = 9239;
    public static final short SPRM_DXAABS = -31720;
    public static final short SPRM_DYAABS = -31719;
    public static final short SPRM_DXAWIDTH = -31718;
    public static final short SPRM_PC = 9755;
    public static final short SPRM_WR = 9251;
    public static final short SPRM_BRCTOP = 25636;
    public static final short SPRM_BRCLEFT = 25637;
    public static final short SPRM_BRCBOTTOM = 25638;
    public static final short SPRM_BRCRIGHT = 25639;
    public static final short SPRM_BRCBAR = 26153;
    public static final short SPRM_FNOAUTOHYPH = 9258;
    public static final short SPRM_WHEIGHTABS = 17451;
    public static final short SPRM_DCS = 17452;
    public static final short SPRM_SHD = 17453;
    public static final short SPRM_DYAFROMTEXT = -31698;
    public static final short SPRM_DXAFROMTEXT = -31697;
    public static final short SPRM_FLOCKED = 9264;
    public static final short SPRM_FWIDOWCONTROL = 9265;
    public static final short SPRM_RULER = -14798;
    public static final short SPRM_FKINSOKU = 9267;
    public static final short SPRM_FWORDWRAP = 9268;
    public static final short SPRM_FOVERFLOWPUNCT = 9269;
    public static final short SPRM_FTOPLINEPUNCT = 9270;
    public static final short SPRM_AUTOSPACEDE = 9271;
    public static final short SPRM_AUTOSPACEDN = 9272;
    public static final short SPRM_WALIGNFONT = 17465;
    public static final short SPRM_FRAMETEXTFLOW = 17466;
    public static final short SPRM_ANLD = -14786;
    public static final short SPRM_PROPRMARK = -14785;
    public static final short SPRM_OUTLVL = 9792;
    public static final short SPRM_FBIDI = 9281;
    public static final short SPRM_FNUMRMLNS = 9283;
    public static final short SPRM_CRLF = 9284;
    public static final short SPRM_NUMRM = -14779;
    public static final short SPRM_USEPGSUSETTINGS = 9287;
    public static final short SPRM_FADJUSTRIGHT = 9288;
    protected short _istd;
    protected ParagraphProperties _props;
    protected SprmBuffer _papx;

    protected Paragraph(int startIdx, int endIdx, Table parent) {
        super(startIdx, endIdx, 0, parent);
        PAPX papx = (PAPX)this._paragraphs.get(this._parEnd - 1);
        this._props = papx.getParagraphProperties(this._doc.getStyleSheet());
        this._papx = papx.getSprmBuf();
        this._istd = papx.getIstd();
    }

    protected Paragraph(PAPX papx, Range parent) {
        super(Math.max(parent._start, papx.getStart()), Math.min(parent._end, papx.getEnd()), parent);
        this._props = papx.getParagraphProperties(this._doc.getStyleSheet());
        this._papx = papx.getSprmBuf();
        this._istd = papx.getIstd();
    }

    public short getStyleIndex() {
        return this._istd;
    }

    public int type() {
        return 0;
    }

    public boolean isInTable() {
        return this._props.getFInTable() != 0;
    }

    public boolean isTableRowEnd() {
        return this._props.getFTtp() != 0 || this._props.getFTtpEmbedded() != 0;
    }

    public int getTableLevel() {
        return this._props.getTableLevel();
    }

    public boolean isEmbeddedCellMark() {
        return this._props.getEmbeddedCellMark() != 0;
    }

    public int getJustification() {
        return this._props.getJc();
    }

    public void setJustification(byte jc) {
        this._props.setJc(jc);
        this._papx.updateSprm((short)9219, jc);
    }

    public boolean keepOnPage() {
        return this._props.getFKeep() != 0;
    }

    public void setKeepOnPage(boolean fKeep) {
        byte keep = (byte)(fKeep ? 1 : 0);
        this._props.setFKeep(keep);
        this._papx.updateSprm((short)9221, keep);
    }

    public boolean keepWithNext() {
        return this._props.getFKeepFollow() != 0;
    }

    public void setKeepWithNext(boolean fKeepFollow) {
        byte keepFollow = (byte)(fKeepFollow ? 1 : 0);
        this._props.setFKeepFollow(keepFollow);
        this._papx.updateSprm((short)9222, keepFollow);
    }

    public boolean pageBreakBefore() {
        return this._props.getFPageBreakBefore() != 0;
    }

    public void setPageBreakBefore(boolean fPageBreak) {
        byte pageBreak = (byte)(fPageBreak ? 1 : 0);
        this._props.setFPageBreakBefore(pageBreak);
        this._papx.updateSprm((short)9223, pageBreak);
    }

    public boolean isLineNotNumbered() {
        return this._props.getFNoLnn() != 0;
    }

    public void setLineNotNumbered(boolean fNoLnn) {
        byte noLnn = (byte)(fNoLnn ? 1 : 0);
        this._props.setFNoLnn(noLnn);
        this._papx.updateSprm((short)9228, noLnn);
    }

    public boolean isSideBySide() {
        return this._props.getFSideBySide() != 0;
    }

    public void setSideBySide(boolean fSideBySide) {
        byte sideBySide = (byte)(fSideBySide ? 1 : 0);
        this._props.setFSideBySide(sideBySide);
        this._papx.updateSprm((short)9220, sideBySide);
    }

    public boolean isAutoHyphenated() {
        return this._props.getFNoAutoHyph() == 0;
    }

    public void setAutoHyphenated(boolean autoHyph) {
        byte auto = (byte)(!autoHyph ? 1 : 0);
        this._props.setFNoAutoHyph(auto);
        this._papx.updateSprm((short)9258, auto);
    }

    public boolean isWidowControlled() {
        return this._props.getFWidowControl() != 0;
    }

    public void setWidowControl(boolean widowControl) {
        byte widow = (byte)(widowControl ? 1 : 0);
        this._props.setFWidowControl(widow);
        this._papx.updateSprm((short)9265, widow);
    }

    public int getIndentFromRight() {
        return this._props.getDxaRight();
    }

    public void setIndentFromRight(int dxaRight) {
        this._props.setDxaRight(dxaRight);
        this._papx.updateSprm((short)-31730, (short)dxaRight);
    }

    public int getIndentFromLeft() {
        return this._props.getDxaLeft();
    }

    public void setIndentFromLeft(int dxaLeft) {
        this._props.setDxaLeft(dxaLeft);
        this._papx.updateSprm((short)-31729, (short)dxaLeft);
    }

    public int getFirstLineIndent() {
        return this._props.getDxaLeft1();
    }

    public void setFirstLineIndent(int first) {
        this._props.setDxaLeft1(first);
        this._papx.updateSprm((short)-31727, (short)first);
    }

    public LineSpacingDescriptor getLineSpacing() {
        return this._props.getLspd();
    }

    public void setLineSpacing(LineSpacingDescriptor lspd) {
        this._props.setLspd(lspd);
        this._papx.updateSprm((short)25618, lspd.toInt());
    }

    public int getSpacingBefore() {
        return this._props.getDyaBefore();
    }

    public void setSpacingBefore(int before) {
        this._props.setDyaBefore(before);
        this._papx.updateSprm((short)-23533, (short)before);
    }

    public int getSpacingAfter() {
        return this._props.getDyaAfter();
    }

    public void setSpacingAfter(int after) {
        this._props.setDyaAfter(after);
        this._papx.updateSprm((short)-23532, (short)after);
    }

    public boolean isKinsoku() {
        return this._props.getFKinsoku() != 0;
    }

    public void setKinsoku(boolean kinsoku) {
        byte kin = (byte)(kinsoku ? 1 : 0);
        this._props.setFKinsoku(kin);
        this._papx.updateSprm((short)9267, kin);
    }

    public boolean isWordWrapped() {
        return this._props.getFWordWrap() != 0;
    }

    public void setWordWrapped(boolean wrap) {
        byte wordWrap = (byte)(wrap ? 1 : 0);
        this._props.setFWordWrap(wordWrap);
        this._papx.updateSprm((short)9268, wordWrap);
    }

    public int getFontAlignment() {
        return this._props.getWAlignFont();
    }

    public void setFontAlignment(int align) {
        this._props.setWAlignFont(align);
        this._papx.updateSprm((short)17465, (short)align);
    }

    public boolean isVertical() {
        return this._props.isFVertical();
    }

    public void setVertical(boolean vertical) {
        this._props.setFVertical(vertical);
        this._papx.updateSprm((short)17466, this.getFrameTextFlow());
    }

    public boolean isBackward() {
        return this._props.isFBackward();
    }

    public void setBackward(boolean bward) {
        this._props.setFBackward(bward);
        this._papx.updateSprm((short)17466, this.getFrameTextFlow());
    }

    public BorderCode getTopBorder() {
        return this._props.getBrcTop();
    }

    public void setTopBorder(BorderCode top) {
        this._props.setBrcTop(top);
        this._papx.updateSprm((short)25636, top.toInt());
    }

    public BorderCode getLeftBorder() {
        return this._props.getBrcLeft();
    }

    public void setLeftBorder(BorderCode left) {
        this._props.setBrcLeft(left);
        this._papx.updateSprm((short)25637, left.toInt());
    }

    public BorderCode getBottomBorder() {
        return this._props.getBrcBottom();
    }

    public void setBottomBorder(BorderCode bottom) {
        this._props.setBrcBottom(bottom);
        this._papx.updateSprm((short)25638, bottom.toInt());
    }

    public BorderCode getRightBorder() {
        return this._props.getBrcRight();
    }

    public void setRightBorder(BorderCode right) {
        this._props.setBrcRight(right);
        this._papx.updateSprm((short)25639, right.toInt());
    }

    public BorderCode getBarBorder() {
        return this._props.getBrcBar();
    }

    public void setBarBorder(BorderCode bar) {
        this._props.setBrcBar(bar);
        this._papx.updateSprm((short)26153, bar.toInt());
    }

    public ShadingDescriptor getShading() {
        return this._props.getShd();
    }

    public void setShading(ShadingDescriptor shd) {
        this._props.setShd(shd);
        this._papx.updateSprm((short)17453, shd.toShort());
    }

    public DropCapSpecifier getDropCap() {
        return this._props.getDcs();
    }

    public void setDropCap(DropCapSpecifier dcs) {
        this._props.setDcs(dcs);
        this._papx.updateSprm((short)17452, dcs.toShort());
    }

    public int getIlfo() {
        return this._props.getIlfo();
    }

    public int getIlvl() {
        return this._props.getIlvl();
    }

    void setTableRowEnd(TableProperties props) {
        this.setTableRowEnd((byte)1);
        byte[] grpprl = TableSprmCompressor.compressTableProperty(props);
        this._papx.append(grpprl);
    }

    private void setTableRowEnd(byte val) {
        this._props.setFTtp(val);
        this._papx.updateSprm((short)9239, val);
    }

    public ParagraphProperties cloneProperties() {
        try {
            return (ParagraphProperties)this._props.clone();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public Object clone() throws CloneNotSupportedException {
        Paragraph p = (Paragraph)super.clone();
        p._props = (ParagraphProperties)this._props.clone();
        p._papx = new SprmBuffer();
        return p;
    }

    private short getFrameTextFlow() {
        short retVal = 0;
        if (this._props.isFVertical()) {
            retVal = (short)(retVal | 1);
        }
        if (this._props.isFBackward()) {
            retVal = (short)(retVal | 2);
        }
        if (this._props.isFRotateFont()) {
            retVal = (short)(retVal | 4);
        }
        return retVal;
    }
}

