/*
 * Decompiled with CFR 0.152.
 */
package proguard.io;

import java.io.IOException;
import java.io.OutputStream;
import java.util.HashSet;
import java.util.Set;
import java.util.jar.JarOutputStream;
import java.util.jar.Manifest;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import proguard.io.DataEntry;
import proguard.io.DataEntryWriter;
import proguard.io.Finisher;

public class JarWriter
implements DataEntryWriter,
Finisher {
    private final DataEntryWriter dataEntryWriter;
    private final Manifest manifest;
    private final String comment;
    private OutputStream currentParentOutputStream;
    private ZipOutputStream currentJarOutputStream;
    private Finisher currentFinisher;
    private DataEntry currentDataEntry;
    private final Set jarEntryNames = new HashSet();

    public JarWriter(DataEntryWriter dataEntryWriter) {
        this(dataEntryWriter, null, null);
    }

    public JarWriter(DataEntryWriter dataEntryWriter, Manifest manifest, String string) {
        this.dataEntryWriter = dataEntryWriter;
        this.manifest = manifest;
        this.comment = string;
    }

    @Override
    public OutputStream getOutputStream(DataEntry dataEntry) throws IOException {
        return this.getOutputStream(dataEntry, null);
    }

    @Override
    public OutputStream getOutputStream(DataEntry dataEntry, Finisher finisher) throws IOException {
        OutputStream outputStream = this.dataEntryWriter.getOutputStream(dataEntry.getParent(), this);
        if (outputStream == null) {
            return null;
        }
        if (this.currentParentOutputStream == null) {
            this.currentParentOutputStream = outputStream;
            ZipOutputStream zipOutputStream = this.currentJarOutputStream = this.manifest != null ? new JarOutputStream(outputStream, this.manifest) : new ZipOutputStream(outputStream);
            if (this.comment != null) {
                this.currentJarOutputStream.setComment(this.comment);
            }
        }
        if (!dataEntry.equals(this.currentDataEntry)) {
            this.closeEntry();
            String string = dataEntry.getName();
            if (!this.jarEntryNames.add(string)) {
                throw new IOException("Duplicate zip entry [" + dataEntry + "]");
            }
            this.currentJarOutputStream.putNextEntry(new ZipEntry(string));
            this.currentFinisher = finisher;
            this.currentDataEntry = dataEntry;
        }
        return this.currentJarOutputStream;
    }

    @Override
    public void finish() throws IOException {
        if (this.currentJarOutputStream != null) {
            this.closeEntry();
            this.currentJarOutputStream.finish();
            this.currentJarOutputStream = null;
            this.currentParentOutputStream = null;
            this.jarEntryNames.clear();
        }
    }

    @Override
    public void close() throws IOException {
        this.dataEntryWriter.close();
    }

    private void closeEntry() throws IOException {
        if (this.currentDataEntry != null) {
            if (this.currentFinisher != null) {
                this.currentFinisher.finish();
                this.currentFinisher = null;
            }
            this.currentJarOutputStream.closeEntry();
            this.currentDataEntry = null;
        }
    }
}

