/*
 * Decompiled with CFR 0.152.
 */
package proguard.optimize.peephole;

import proguard.classfile.Clazz;
import proguard.classfile.Method;
import proguard.classfile.attribute.CodeAttribute;
import proguard.classfile.constant.Constant;
import proguard.classfile.constant.visitor.ConstantVisitor;
import proguard.classfile.editor.CodeAttributeEditor;
import proguard.classfile.instruction.BranchInstruction;
import proguard.classfile.instruction.ConstantInstruction;
import proguard.classfile.instruction.Instruction;
import proguard.classfile.instruction.LookUpSwitchInstruction;
import proguard.classfile.instruction.SimpleInstruction;
import proguard.classfile.instruction.TableSwitchInstruction;
import proguard.classfile.instruction.VariableInstruction;
import proguard.classfile.instruction.visitor.InstructionVisitor;
import proguard.classfile.util.InstructionSequenceMatcher;
import proguard.classfile.util.SimplifiedVisitor;
import proguard.optimize.peephole.BranchTargetFinder;

public class InstructionSequenceReplacer
extends SimplifiedVisitor
implements InstructionVisitor,
ConstantVisitor {
    private static final boolean DEBUG = false;
    private final InstructionSequenceMatcher instructionSequenceMatcher;
    private final Instruction[] replacementInstructions;
    private final BranchTargetFinder branchTargetFinder;
    private final CodeAttributeEditor codeAttributeEditor;
    private final InstructionVisitor extraInstructionVisitor;
    private final MyReplacementInstructionFactory replacementInstructionFactory = new MyReplacementInstructionFactory();

    public InstructionSequenceReplacer(Constant[] constantArray, Instruction[] instructionArray, Instruction[] instructionArray2, BranchTargetFinder branchTargetFinder, CodeAttributeEditor codeAttributeEditor) {
        this(constantArray, instructionArray, instructionArray2, branchTargetFinder, codeAttributeEditor, null);
    }

    public InstructionSequenceReplacer(Constant[] constantArray, Instruction[] instructionArray, Instruction[] instructionArray2, BranchTargetFinder branchTargetFinder, CodeAttributeEditor codeAttributeEditor, InstructionVisitor instructionVisitor) {
        this.instructionSequenceMatcher = new InstructionSequenceMatcher(constantArray, instructionArray);
        this.replacementInstructions = instructionArray2;
        this.branchTargetFinder = branchTargetFinder;
        this.codeAttributeEditor = codeAttributeEditor;
        this.extraInstructionVisitor = instructionVisitor;
    }

    @Override
    public void visitAnyInstruction(Clazz clazz, Method method, CodeAttribute codeAttribute, int n, Instruction instruction) {
        if (this.branchTargetFinder.isTarget(n) || this.codeAttributeEditor.isModified(n)) {
            this.instructionSequenceMatcher.reset();
        }
        instruction.accept(clazz, method, codeAttribute, n, this.instructionSequenceMatcher);
        if (this.instructionSequenceMatcher.isMatching() && this.matchedInstructionsUnmodified()) {
            int n2;
            for (n2 = 0; n2 < this.replacementInstructions.length; ++n2) {
                this.codeAttributeEditor.replaceInstruction(this.instructionSequenceMatcher.matchedInstructionOffset(n2), this.replacementInstructionFactory.create(n2).shrink());
            }
            for (n2 = this.replacementInstructions.length; n2 < this.instructionSequenceMatcher.instructionCount(); ++n2) {
                this.codeAttributeEditor.deleteInstruction(this.instructionSequenceMatcher.matchedInstructionOffset(n2));
            }
            if (this.extraInstructionVisitor != null) {
                instruction.accept(clazz, method, codeAttribute, n, this.extraInstructionVisitor);
            }
        }
    }

    private boolean matchedInstructionsUnmodified() {
        for (int i = 0; i < this.instructionSequenceMatcher.instructionCount(); ++i) {
            if (!this.codeAttributeEditor.isModified(this.instructionSequenceMatcher.matchedInstructionOffset(i))) continue;
            return false;
        }
        return true;
    }

    private class MyReplacementInstructionFactory
    implements InstructionVisitor {
        private Instruction replacementInstruction;

        private MyReplacementInstructionFactory() {
        }

        public Instruction create(int n) {
            InstructionSequenceReplacer.this.replacementInstructions[n].accept(null, null, null, InstructionSequenceReplacer.this.instructionSequenceMatcher.matchedInstructionOffset(n), this);
            return this.replacementInstruction.shrink();
        }

        @Override
        public void visitSimpleInstruction(Clazz clazz, Method method, CodeAttribute codeAttribute, int n, SimpleInstruction simpleInstruction) {
            this.replacementInstruction = new SimpleInstruction(simpleInstruction.opcode, InstructionSequenceReplacer.this.instructionSequenceMatcher.matchedArgument(simpleInstruction.constant));
        }

        @Override
        public void visitVariableInstruction(Clazz clazz, Method method, CodeAttribute codeAttribute, int n, VariableInstruction variableInstruction) {
            this.replacementInstruction = new VariableInstruction(variableInstruction.opcode, InstructionSequenceReplacer.this.instructionSequenceMatcher.matchedArgument(variableInstruction.variableIndex), InstructionSequenceReplacer.this.instructionSequenceMatcher.matchedArgument(variableInstruction.constant));
        }

        @Override
        public void visitConstantInstruction(Clazz clazz, Method method, CodeAttribute codeAttribute, int n, ConstantInstruction constantInstruction) {
            this.replacementInstruction = new ConstantInstruction(constantInstruction.opcode, InstructionSequenceReplacer.this.instructionSequenceMatcher.matchedConstantIndex(constantInstruction.constantIndex), InstructionSequenceReplacer.this.instructionSequenceMatcher.matchedArgument(constantInstruction.constant));
        }

        @Override
        public void visitBranchInstruction(Clazz clazz, Method method, CodeAttribute codeAttribute, int n, BranchInstruction branchInstruction) {
            this.replacementInstruction = new BranchInstruction(branchInstruction.opcode, InstructionSequenceReplacer.this.instructionSequenceMatcher.matchedBranchOffset(n, branchInstruction.branchOffset));
        }

        @Override
        public void visitTableSwitchInstruction(Clazz clazz, Method method, CodeAttribute codeAttribute, int n, TableSwitchInstruction tableSwitchInstruction) {
            this.replacementInstruction = new TableSwitchInstruction(tableSwitchInstruction.opcode, InstructionSequenceReplacer.this.instructionSequenceMatcher.matchedBranchOffset(n, tableSwitchInstruction.defaultOffset), InstructionSequenceReplacer.this.instructionSequenceMatcher.matchedArgument(tableSwitchInstruction.lowCase), InstructionSequenceReplacer.this.instructionSequenceMatcher.matchedArgument(tableSwitchInstruction.highCase), InstructionSequenceReplacer.this.instructionSequenceMatcher.matchedJumpOffsets(n, tableSwitchInstruction.jumpOffsets));
        }

        @Override
        public void visitLookUpSwitchInstruction(Clazz clazz, Method method, CodeAttribute codeAttribute, int n, LookUpSwitchInstruction lookUpSwitchInstruction) {
            this.replacementInstruction = new LookUpSwitchInstruction(lookUpSwitchInstruction.opcode, InstructionSequenceReplacer.this.instructionSequenceMatcher.matchedBranchOffset(n, lookUpSwitchInstruction.defaultOffset), InstructionSequenceReplacer.this.instructionSequenceMatcher.matchedArguments(lookUpSwitchInstruction.cases), InstructionSequenceReplacer.this.instructionSequenceMatcher.matchedJumpOffsets(n, lookUpSwitchInstruction.jumpOffsets));
        }
    }
}

