/*
 * Decompiled with CFR 0.152.
 */
package proguard.shrink;

import java.io.PrintStream;
import proguard.classfile.LibraryClass;
import proguard.classfile.LibraryField;
import proguard.classfile.LibraryMethod;
import proguard.classfile.ProgramClass;
import proguard.classfile.ProgramField;
import proguard.classfile.ProgramMember;
import proguard.classfile.ProgramMethod;
import proguard.classfile.VisitorAccepter;
import proguard.classfile.util.ClassUtil;
import proguard.classfile.visitor.ClassVisitor;
import proguard.classfile.visitor.MemberVisitor;
import proguard.shrink.ShortestUsageMark;
import proguard.shrink.ShortestUsageMarker;

public class ShortestUsagePrinter
implements ClassVisitor,
MemberVisitor {
    private final ShortestUsageMarker shortestUsageMarker;
    private final boolean verbose;
    private final PrintStream ps;

    public ShortestUsagePrinter(ShortestUsageMarker shortestUsageMarker) {
        this(shortestUsageMarker, true);
    }

    public ShortestUsagePrinter(ShortestUsageMarker shortestUsageMarker, boolean bl) {
        this(shortestUsageMarker, bl, System.out);
    }

    public ShortestUsagePrinter(ShortestUsageMarker shortestUsageMarker, boolean bl, PrintStream printStream) {
        this.shortestUsageMarker = shortestUsageMarker;
        this.verbose = bl;
        this.ps = printStream;
    }

    @Override
    public void visitProgramClass(ProgramClass programClass) {
        this.ps.println(ClassUtil.externalClassName(programClass.getName()));
        this.printReason(programClass);
    }

    @Override
    public void visitLibraryClass(LibraryClass libraryClass) {
        this.ps.println(ClassUtil.externalClassName(libraryClass.getName()));
        this.ps.println("  is a library class.\n");
    }

    @Override
    public void visitProgramField(ProgramClass programClass, ProgramField programField) {
        String string = programField.getName(programClass);
        String string2 = programField.getDescriptor(programClass);
        this.ps.println(ClassUtil.externalClassName(programClass.getName()) + (this.verbose ? ": " + ClassUtil.externalFullFieldDescription(0, string, string2) : "." + string) + ShortestUsagePrinter.lineNumberRange(programClass, programField));
        this.printReason(programField);
    }

    @Override
    public void visitProgramMethod(ProgramClass programClass, ProgramMethod programMethod) {
        String string = programMethod.getName(programClass);
        String string2 = programMethod.getDescriptor(programClass);
        this.ps.println(ClassUtil.externalClassName(programClass.getName()) + (this.verbose ? ": " + ClassUtil.externalFullMethodDescription(programClass.getName(), 0, string, string2) : "." + string) + ShortestUsagePrinter.lineNumberRange(programClass, programMethod));
        this.printReason(programMethod);
    }

    @Override
    public void visitLibraryField(LibraryClass libraryClass, LibraryField libraryField) {
        String string = libraryField.getName(libraryClass);
        String string2 = libraryField.getDescriptor(libraryClass);
        this.ps.println(ClassUtil.externalClassName(libraryClass.getName()) + (this.verbose ? ": " + ClassUtil.externalFullFieldDescription(0, string, string2) : "." + string));
        this.ps.println("  is a library field.\n");
    }

    @Override
    public void visitLibraryMethod(LibraryClass libraryClass, LibraryMethod libraryMethod) {
        String string = libraryMethod.getName(libraryClass);
        String string2 = libraryMethod.getDescriptor(libraryClass);
        this.ps.println(ClassUtil.externalClassName(libraryClass.getName()) + (this.verbose ? ": " + ClassUtil.externalFullMethodDescription(libraryClass.getName(), 0, string, string2) : "." + string));
        this.ps.println("  is a library method.\n");
    }

    private void printReason(VisitorAccepter visitorAccepter) {
        if (this.shortestUsageMarker.isUsed(visitorAccepter)) {
            ShortestUsageMark shortestUsageMark = this.shortestUsageMarker.getShortestUsageMark(visitorAccepter);
            this.ps.print("  " + shortestUsageMark.getReason());
            shortestUsageMark.acceptClassVisitor(this);
            shortestUsageMark.acceptMemberVisitor(this);
        } else {
            this.ps.println("  is not being kept.\n");
        }
    }

    private static String lineNumberRange(ProgramClass programClass, ProgramMember programMember) {
        String string = programMember.getLineNumberRange(programClass);
        return string != null ? " (" + string + ")" : "";
    }
}

