/*
 * Decompiled with CFR 0.152.
 */
package test;

import java.util.Optional;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.das2.datum.Units;
import org.das2.sdi.Adapter;
import org.das2.sdi.BinnedData2DAdapter;
import org.das2.sdi.Operations;
import org.das2.sdi.XYDataAdapter;
import org.das2.sdi.XYZDataAdapter;
import org.virbo.autoplot.ScriptContext;
import org.virbo.dataset.DataSetOps;
import org.virbo.dataset.QDataSet;
import org.virbo.dataset.SemanticOps;
import org.virbo.dataset.examples.Schemes;
import org.virbo.dsops.Ops;
import sdi.data.BinnedData1D;
import sdi.data.BinnedData2D;
import sdi.data.ContiguousBinnedData1D;
import sdi.data.FillDetector;
import sdi.data.SimpleXYData;
import sdi.data.UncertaintyProvider;
import sdi.data.UncertaintyProvider2D;
import sdi.data.XYData;
import sdi.data.XYMetadata;
import sdi.data.XYZData;
import sdi.data.XYZMetadata;

class Test {
    Test() {
    }

    private static void test1() {
        System.err.println("==test1==");
        QDataSet ds = Schemes.simpleSpectrogram().slice(0).trim(0, 10);
        SimpleXYData xyds = Adapter.adaptSimpleXYData(ds);
        for (int i = 0; i < xyds.size(); ++i) {
            System.err.printf("%f %f\n", xyds.getX(i), xyds.getY(i));
        }
    }

    private static void test2() {
        System.err.println("==test2==");
        QDataSet ds = Schemes.scalarTimeSeries().trim(0, 10);
        XYData xyds = Adapter.adaptXYData(ds);
        XYMetadata m = xyds.getMetadata();
        Units u = Units.lookupUnits((String)m.getXUnits().getName());
        for (int i = 0; i < xyds.size(); ++i) {
            System.err.printf("%s %f\n", u.createDatum(xyds.getX(i)), xyds.getY(i));
        }
    }

    private static XYData demoXY() {
        XYData data = new XYData(){
            double[] xx = new double[]{1.0, 2.0, 3.0, 4.0, 5.0, 6.0, 7.0, 8.0, 9.0};
            double[] yy = new double[]{1.5, 3.0, 4.5, 3.6, 99.0, 3.0, 4.0, 3.5, 3.7};
            double[] dyyPlus = new double[]{0.9, 1.0, 1.0, 1.0, 1.0, 2.0, 2.0, 1.0, 1.0};
            double[] dyyMinus = new double[]{1.1, 1.0, 1.0, 2.0, 2.0, 2.0, 1.0, 1.0, 1.0};

            public Optional<FillDetector> getFillDetector() {
                return Optional.of(index -> this.yy[index] > 98.0);
            }

            public Optional<UncertaintyProvider> getXUncertProvider() {
                return Optional.empty();
            }

            public Optional<UncertaintyProvider> getYUncertProvider() {
                return Optional.of(new UncertaintyProvider(){

                    public double getUncertPlus(int i) {
                        return yy[i] + dyyPlus[i];
                    }

                    public double getUncertMinus(int i) {
                        return yy[i] - dyyMinus[i];
                    }
                });
            }

            public XYMetadata getMetadata() {
                return new XYMetadata(){

                    public sdi.data.Units getXUnits() {
                        return new sdi.data.Units("hours since 2015-03-21");
                    }

                    public sdi.data.Units getYUnits() {
                        return new sdi.data.Units("# * cm^-3");
                    }

                    public String getXName() {
                        return "exampleX";
                    }

                    public String getYName() {
                        return "exampleY";
                    }

                    public String getXLabel() {
                        return "Example X";
                    }

                    public String getYLabel() {
                        return "Example Y";
                    }

                    public String getName() {
                        return "ExampleData";
                    }
                };
            }

            public int size() {
                return this.xx.length;
            }

            public double getX(int i) {
                return this.xx[i];
            }

            public double getY(int i) {
                return this.yy[i];
            }
        };
        return data;
    }

    private static void printMetadataXY(XYMetadata xy) {
        System.err.println("xname:  " + xy.getXName());
        System.err.println("xlabel: " + xy.getXLabel());
        System.err.println("xunits: " + xy.getXUnits());
        System.err.println("yname:  " + xy.getYName());
        System.err.println("ylabel: " + xy.getYLabel());
        System.err.println("yunits: " + xy.getYUnits());
    }

    private static void printXYData(XYData xyds) {
        XYMetadata m = xyds.getMetadata();
        Test.printMetadataXY(m);
        Optional oup = xyds.getYUncertProvider();
        Optional ofd = xyds.getFillDetector();
        FillDetector fd = ofd.isPresent() ? (FillDetector)ofd.get() : index -> false;
        Units u = Units.lookupUnits((String)m.getXUnits().getName());
        if (oup.isPresent()) {
            UncertaintyProvider up = (UncertaintyProvider)oup.get();
            for (int i = 0; i < xyds.size(); ++i) {
                if (fd.isFill(i)) {
                    System.err.printf("%s *** (***-***)\n", u.createDatum(xyds.getX(i)), xyds.getY(i), up.getUncertMinus(i), up.getUncertPlus(i));
                    continue;
                }
                System.err.printf("%s %s (%f-%f)\n", u.createDatum(xyds.getX(i)), xyds.getY(i), up.getUncertMinus(i), up.getUncertPlus(i));
            }
        } else {
            for (int i = 0; i < xyds.size(); ++i) {
                System.err.printf("%s %s\n", u.createDatum(xyds.getX(i)), fd.isFill(i) ? "***" : Double.valueOf(xyds.getY(i)));
            }
        }
    }

    private static void printQDataSet(QDataSet y) {
        QDataSet x = (QDataSet)y.property("DEPEND_0");
        QDataSet dymn = (QDataSet)y.property("DELTA_MINUS");
        QDataSet dyup = (QDataSet)y.property("DELTA_PLUS");
        QDataSet wds = SemanticOps.weightsDataSet((QDataSet)y);
        Units u = SemanticOps.getUnits((QDataSet)x);
        if (dymn != null && dyup != null) {
            for (int i = 0; i < y.length(); ++i) {
                if (wds.value(i) == 0.0) {
                    System.err.printf("%s *** (***-***)\n", u.createDatum(x.value(i)));
                    continue;
                }
                System.err.printf("%s %s (%f-%f)\n", u.createDatum(x.value(i)), y.value(i), y.value(i) - dymn.value(i), y.value(i) + dyup.value(i));
            }
        } else {
            for (int i = 0; i < y.length(); ++i) {
                System.err.printf("%s %s\n", u.createDatum(x.value(i)), wds.value(i) == 0.0 ? "***" : Double.valueOf(y.value(i)));
            }
        }
    }

    private static void test4() {
        System.err.println("== test4 ==");
        XYData data = Test.demoXY();
        Test.printXYData(data);
        QDataSet ds = XYDataAdapter.adapt(data);
        System.err.println("== xydata -> qdataset ==");
        Test.printQDataSet(ds);
        System.err.println("== qdataset -> xydata ==");
        XYData xyds = Adapter.adaptXYData(ds);
        Test.printXYData(xyds);
    }

    private static void printMetadataXYZ(XYZMetadata xyz) {
        System.err.println("xname:  " + xyz.getXName());
        System.err.println("xlabel: " + xyz.getXLabel());
        System.err.println("xunits: " + xyz.getXUnits());
        System.err.println("yname:  " + xyz.getYName());
        System.err.println("ylabel: " + xyz.getYLabel());
        System.err.println("yunits: " + xyz.getYUnits());
        System.err.println("zname:  " + xyz.getZName());
        System.err.println("zlabel: " + xyz.getZLabel());
        System.err.println("zunits: " + xyz.getZUnits());
    }

    private static void printBinnedData2D(BinnedData2D d) {
        Test.printMetadataXYZ(d.getMetadata());
        System.err.printf("%30s ", "");
        for (int j = 0; j < d.sizeY(); ++j) {
            System.err.printf("%9.2f ", d.getYBin(j).getReference());
        }
        Units x = Units.lookupUnits((String)d.getMetadata().getXUnits().getName());
        System.err.println("");
        for (int i = 0; i < d.sizeX(); ++i) {
            System.err.printf("%30s ", x.createDatum(d.getXBin(i).getReference()));
            for (int j = 0; j < d.sizeY(); ++j) {
                System.err.printf("%9.2e ", d.getZ(i, j));
            }
            System.err.println("");
        }
    }

    private static void printBinnedData2DQDataSet(QDataSet ds) {
        System.err.printf("%30s ", "");
        QDataSet y = (QDataSet)ds.property("DEPEND_1");
        QDataSet x = (QDataSet)ds.property("DEPEND_0");
        for (int j = 0; j < y.length(); ++j) {
            System.err.printf("%9.2f ", y.value(j));
        }
        System.err.println("");
        for (int i = 0; i < x.length(); ++i) {
            System.err.printf("%30s ", x.slice(i));
            for (int j = 0; j < y.length(); ++j) {
                System.err.printf("%9.2e ", ds.slice(i).slice(j).value());
            }
            System.err.println("");
        }
    }

    private static void test5() {
        System.err.println("== test5 ==");
        QDataSet rank2ds = Schemes.simpleSpectrogramTimeSeries();
        rank2ds = DataSetOps.leafTrim((QDataSet)rank2ds, (int)0, (int)8);
        rank2ds = rank2ds.trim(0, 12);
        BinnedData2D bd2d = Adapter.adaptBinnedData2D(rank2ds);
        System.err.println("== qdataset -> BinnedData2D ==");
        Test.printBinnedData2D(bd2d);
        QDataSet ds = BinnedData2DAdapter.adapt(bd2d);
        System.err.println("== BinnedData2D -> QDataSet ==");
        Test.printBinnedData2DQDataSet(ds);
    }

    private static void printXYZData(XYZData xyzdata) {
        Units xu = Units.lookupUnits((String)xyzdata.getMetadata().getXUnits().getName());
        Units yu = Units.lookupUnits((String)xyzdata.getMetadata().getYUnits().getName());
        Units zu = Units.lookupUnits((String)xyzdata.getMetadata().getZUnits().getName());
        Test.printMetadataXYZ(xyzdata.getMetadata());
        for (int i = 0; i < xyzdata.size(); ++i) {
            System.err.println(String.format("%s %s %s", xu.createDatum(xyzdata.getX(i)), yu.createDatum(xyzdata.getY(i)), zu.createDatum(xyzdata.getZ(i))));
        }
    }

    private static void printXYZDataQDataSet(QDataSet ds) {
        QDataSet x = SemanticOps.xtagsDataSet((QDataSet)ds);
        QDataSet y = SemanticOps.ytagsDataSet((QDataSet)ds);
        QDataSet z = SemanticOps.getDependentDataSet((QDataSet)ds);
        Units xu = SemanticOps.getUnits((QDataSet)x);
        Units yu = SemanticOps.getUnits((QDataSet)y);
        Units zu = SemanticOps.getUnits((QDataSet)z);
        for (int i = 0; i < x.length(); ++i) {
            System.err.println(String.format("%s %s %s", xu.createDatum(x.value(i)), yu.createDatum(y.value(i)), zu.createDatum(z.value(i))));
        }
    }

    private static void test6() {
        System.err.println("== test6 ==");
        QDataSet rank2ds = Ops.ripplesVectorTimeSeries((int)10);
        XYZData bd2d = Adapter.adaptXYZData(rank2ds);
        System.err.println("== QDataSet -> XYZData ==");
        Test.printXYZData(bd2d);
        QDataSet ds = XYZDataAdapter.adapt(bd2d);
        System.err.println("== XYZData -> QDataSet ==");
        Test.printXYZDataQDataSet(ds);
    }

    private static BinnedData2D exampleBinned2D() {
        try {
            QDataSet z = Ops.multiply((Object)Ops.findgen((int)4, (int)5), (Object)0.5);
            z = Ops.putProperty((QDataSet)z, (String)"DELTA_MINUS", (Object)Ops.dataset((Object)0.3));
            z = Ops.putProperty((QDataSet)z, (String)"DELTA_PLUS", (Object)Ops.dataset((Object)0.4));
            QDataSet x = Ops.timegen((String)"2014-03-25T06:48", (String)"1s", (int)4);
            QDataSet y = Ops.findgen((int)5);
            BinnedData2D bd2d = Adapter.adaptBinnedData2D(x, y, z);
            return bd2d;
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
    }

    public static void test7() {
        BinnedData2D bd2d = Test.exampleBinned2D();
        UncertaintyProvider2D dbd2d = (UncertaintyProvider2D)bd2d.getZUncertProvider().get();
        for (int i = 0; i < bd2d.sizeX(); ++i) {
            for (int j = 0; j < bd2d.sizeY(); ++j) {
                System.err.println(String.format("%d %d: ", i, j) + bd2d.getZ(i, j) + " (" + dbd2d.getUncertMinus(i, j) + " - " + dbd2d.getUncertPlus(i, j) + ")");
            }
        }
    }

    public static void printBinnedData1D(BinnedData1D data) {
        Units xu = Units.lookupUnits((String)data.getMetadata().getXUnits().getName());
        Units yu = Units.lookupUnits((String)data.getMetadata().getYUnits().getName());
        for (int i = 0; i < data.size(); ++i) {
            System.err.println(xu.createDatum(data.getXBin(i).getReference()) + " " + yu.createDatum(data.getY(i)));
        }
    }

    public static void test8() {
        BinnedData2D data = Test.exampleBinned2D();
        Test.printBinnedData2D(data);
        BinnedData1D data1d = Operations.sliceAtX(data, 1);
        Test.printBinnedData1D(data1d);
    }

    public static void test9() {
        try {
            QDataSet sample = Ops.randn((int)300);
            QDataSet hist = Ops.autoHistogram((QDataSet)sample);
            ScriptContext.createGui();
            ScriptContext.plot((QDataSet)hist);
            ContiguousBinnedData1D ds = Adapter.adaptContiguousBinnedData1D(hist);
            for (int i = 0; i < ds.size(); ++i) {
                System.err.printf(" %3d: %f - %f %d\n", i, ds.getXBinLo(i), i == ds.size() - 1 ? ds.getLastXBinHi() : ds.getXBinLo(i + 1), (int)ds.getY(i));
            }
        }
        catch (InterruptedException ex) {
            Logger.getLogger(Test.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    public static void main(String[] args) throws Exception {
        Test.test1();
        Test.test2();
        Test.test4();
        Test.test5();
        Test.test6();
        Test.test7();
        Test.test8();
        Test.test9();
    }
}

