
package org.das2.components.propertyeditor;

import java.awt.Component;
import java.awt.Cursor;
import java.awt.Desktop;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JOptionPane;
import org.das2.util.LoggerManager;
import org.das2.util.StringSchemeEditor;

/**
 * Editor for uri template strings like $Y-$m-$d or $(m;Y=2025)-$d
 * @author jbf
 */
public class UriTemplatesStringSchemeEditor extends javax.swing.JPanel implements StringSchemeEditor {

    URI uri;
    
    private static final Logger logger= LoggerManager.getLogger("das2.gui");
    
    /**
     * Creates new form UriTemplatesStringSchemeEditor
     */
    public UriTemplatesStringSchemeEditor() {
        initComponents();
        jLabel1.addMouseListener( myMouseListener() );
        try {
            uri= new URI("https://github.com/uri-templates-time/uri-templates-time-specification/blob/main/specification-1.1.0.md");
        } catch (URISyntaxException ex) {
            logger.log(Level.SEVERE, null, ex);
        }
    }

    /**
     * This method is called from within the constructor to initialize the form. WARNING: Do NOT modify this code. The content of
     * this method is always regenerated by the Form Editor.
     */
    @SuppressWarnings("unchecked")
    // <editor-fold defaultstate="collapsed" desc="Generated Code">//GEN-BEGIN:initComponents
    private void initComponents() {

        subsecPanel = new javax.swing.JPanel();
        subsecDecimalPlacesLabel = new javax.swing.JLabel();
        subsecPlacesTF = new javax.swing.JFormattedTextField();
        templTextField = new javax.swing.JTextField();
        jLabel1 = new javax.swing.JLabel();
        yearButton = new javax.swing.JButton();
        monthButton = new javax.swing.JButton();
        dayButton = new javax.swing.JButton();
        doyButton = new javax.swing.JButton();
        yrButton = new javax.swing.JButton();
        hourButton = new javax.swing.JButton();
        minuteButton = new javax.swing.JButton();
        secondButton = new javax.swing.JButton();
        subsecButton = new javax.swing.JButton();
        dashButton = new javax.swing.JButton();
        slashButton = new javax.swing.JButton();
        colonButton = new javax.swing.JButton();
        periodButton = new javax.swing.JButton();

        subsecDecimalPlacesLabel.setText("Number of Decimal Places (1-9):");

        subsecPlacesTF.setText("6");

        javax.swing.GroupLayout subsecPanelLayout = new javax.swing.GroupLayout(subsecPanel);
        subsecPanel.setLayout(subsecPanelLayout);
        subsecPanelLayout.setHorizontalGroup(
            subsecPanelLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(subsecPanelLayout.createSequentialGroup()
                .addContainerGap()
                .addGroup(subsecPanelLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                    .addGroup(subsecPanelLayout.createSequentialGroup()
                        .addGap(12, 12, 12)
                        .addComponent(subsecPlacesTF, javax.swing.GroupLayout.PREFERRED_SIZE, 44, javax.swing.GroupLayout.PREFERRED_SIZE))
                    .addComponent(subsecDecimalPlacesLabel))
                .addContainerGap(javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE))
        );
        subsecPanelLayout.setVerticalGroup(
            subsecPanelLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(subsecPanelLayout.createSequentialGroup()
                .addContainerGap()
                .addComponent(subsecDecimalPlacesLabel)
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addComponent(subsecPlacesTF, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
                .addContainerGap(31, Short.MAX_VALUE))
        );

        templTextField.setText("jTextField1");

        jLabel1.setText("<html>A URI Template describes how a time range is to be formatted into a string, such as a filename or tick format.  Edit the string below using your keyboard or the buttons to insert time components.  The URI_Templates specification can be found here: <a href=\"https://github.com/uri-templates-time/uri-templates-time-specification/blob/main/specification-1.1.0.md\">https://github.com/uri-templates-time/</a>");
        jLabel1.setVerticalAlignment(javax.swing.SwingConstants.TOP);

        yearButton.setText("Year");
        yearButton.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                yearButtonActionPerformed(evt);
            }
        });

        monthButton.setText("Month");
        monthButton.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                monthButtonActionPerformed(evt);
            }
        });

        dayButton.setText("Day");
        dayButton.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                dayButtonActionPerformed(evt);
            }
        });

        doyButton.setText("Day of Year");
        doyButton.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                doyButtonActionPerformed(evt);
            }
        });

        yrButton.setText("Two-Digit Year");
        yrButton.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                yrButtonActionPerformed(evt);
            }
        });

        hourButton.setText("Hour");
        hourButton.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                hourButtonActionPerformed(evt);
            }
        });

        minuteButton.setText("Minute");
        minuteButton.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                minuteButtonActionPerformed(evt);
            }
        });

        secondButton.setText("Second");
        secondButton.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                secondButtonActionPerformed(evt);
            }
        });

        subsecButton.setText("Sub-Second...");
        subsecButton.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                subsecButtonActionPerformed(evt);
            }
        });

        dashButton.setText("-");
        dashButton.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                dashButtonActionPerformed(evt);
            }
        });

        slashButton.setText("/");
        slashButton.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                slashButtonActionPerformed(evt);
            }
        });

        colonButton.setText(":");
        colonButton.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                colonButtonActionPerformed(evt);
            }
        });

        periodButton.setText(".");
        periodButton.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                periodButtonActionPerformed(evt);
            }
        });

        javax.swing.GroupLayout layout = new javax.swing.GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(
            layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(layout.createSequentialGroup()
                .addContainerGap()
                .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                    .addComponent(jLabel1, javax.swing.GroupLayout.PREFERRED_SIZE, 0, Short.MAX_VALUE)
                    .addGroup(layout.createSequentialGroup()
                        .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                            .addGroup(layout.createSequentialGroup()
                                .addComponent(monthButton)
                                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.UNRELATED)
                                .addComponent(dashButton)
                                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                                .addComponent(slashButton))
                            .addGroup(layout.createSequentialGroup()
                                .addComponent(yearButton)
                                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                                .addComponent(yrButton))
                            .addGroup(layout.createSequentialGroup()
                                .addComponent(dayButton)
                                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                                .addComponent(doyButton))
                            .addGroup(layout.createSequentialGroup()
                                .addComponent(hourButton)
                                .addGap(18, 18, 18)
                                .addComponent(colonButton)
                                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                                .addComponent(periodButton))
                            .addComponent(minuteButton)
                            .addGroup(layout.createSequentialGroup()
                                .addComponent(secondButton)
                                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                                .addComponent(subsecButton)))
                        .addGap(0, 248, Short.MAX_VALUE))
                    .addComponent(templTextField))
                .addContainerGap())
        );
        layout.setVerticalGroup(
            layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(layout.createSequentialGroup()
                .addContainerGap()
                .addComponent(jLabel1, javax.swing.GroupLayout.PREFERRED_SIZE, 86, javax.swing.GroupLayout.PREFERRED_SIZE)
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addComponent(templTextField, javax.swing.GroupLayout.PREFERRED_SIZE, 19, javax.swing.GroupLayout.PREFERRED_SIZE)
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.UNRELATED)
                .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.BASELINE)
                    .addComponent(yearButton)
                    .addComponent(yrButton))
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.BASELINE)
                    .addComponent(monthButton)
                    .addComponent(dashButton)
                    .addComponent(slashButton))
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.BASELINE)
                    .addComponent(dayButton)
                    .addComponent(doyButton))
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.BASELINE)
                    .addComponent(hourButton)
                    .addComponent(colonButton)
                    .addComponent(periodButton))
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addComponent(minuteButton)
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.BASELINE)
                    .addComponent(secondButton)
                    .addComponent(subsecButton))
                .addContainerGap(64, Short.MAX_VALUE))
        );
    }// </editor-fold>//GEN-END:initComponents

    private void yearButtonActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_yearButtonActionPerformed
        insertText("$Y");
    }//GEN-LAST:event_yearButtonActionPerformed

    private void yrButtonActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_yrButtonActionPerformed
        insertText("$y");
    }//GEN-LAST:event_yrButtonActionPerformed

    private void monthButtonActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_monthButtonActionPerformed
        insertText("$m");
    }//GEN-LAST:event_monthButtonActionPerformed

    private void dayButtonActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_dayButtonActionPerformed
        insertText("$d");
    }//GEN-LAST:event_dayButtonActionPerformed

    private void doyButtonActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_doyButtonActionPerformed
        insertText("$j");
    }//GEN-LAST:event_doyButtonActionPerformed

    private void hourButtonActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_hourButtonActionPerformed
        insertText("$H");
    }//GEN-LAST:event_hourButtonActionPerformed

    private void minuteButtonActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_minuteButtonActionPerformed
        insertText("$M");
    }//GEN-LAST:event_minuteButtonActionPerformed

    private void secondButtonActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_secondButtonActionPerformed
        insertText("$S");
    }//GEN-LAST:event_secondButtonActionPerformed

    private void subsecButtonActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_subsecButtonActionPerformed
        if ( JOptionPane.OK_OPTION==JOptionPane.showConfirmDialog( this, subsecPanel, "subsec options", JOptionPane.OK_CANCEL_OPTION ) ) {
            try {
                int places= Integer.parseInt( subsecPlacesTF.getText() );
                insertText( String.format( "$(subsec;places=%d)", places ) );
            } catch ( NumberFormatException ex ) {
                ex.printStackTrace();
            }
        }
        
    }//GEN-LAST:event_subsecButtonActionPerformed

    private void dashButtonActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_dashButtonActionPerformed
        insertText("-");
    }//GEN-LAST:event_dashButtonActionPerformed

    private void slashButtonActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_slashButtonActionPerformed
        insertText("/");
    }//GEN-LAST:event_slashButtonActionPerformed

    private void colonButtonActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_colonButtonActionPerformed
        insertText(":");
    }//GEN-LAST:event_colonButtonActionPerformed

    private void periodButtonActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_periodButtonActionPerformed
        insertText(".");
    }//GEN-LAST:event_periodButtonActionPerformed

    @Override
    public void setValue(String v) {
        this.templTextField.setText(v);
    }

    @Override
    public String getValue() {
        return this.templTextField.getText();
    }

    @Override
    public Component getComponent() {
        return this;
    }

    @Override
    public void setContext(Object o) {
        
    }


    // Variables declaration - do not modify//GEN-BEGIN:variables
    private javax.swing.JButton colonButton;
    private javax.swing.JButton dashButton;
    private javax.swing.JButton dayButton;
    private javax.swing.JButton doyButton;
    private javax.swing.JButton hourButton;
    private javax.swing.JLabel jLabel1;
    private javax.swing.JButton minuteButton;
    private javax.swing.JButton monthButton;
    private javax.swing.JButton periodButton;
    private javax.swing.JButton secondButton;
    private javax.swing.JButton slashButton;
    private javax.swing.JButton subsecButton;
    private javax.swing.JLabel subsecDecimalPlacesLabel;
    private javax.swing.JPanel subsecPanel;
    private javax.swing.JFormattedTextField subsecPlacesTF;
    private javax.swing.JTextField templTextField;
    private javax.swing.JButton yearButton;
    private javax.swing.JButton yrButton;
    // End of variables declaration//GEN-END:variables

    private void insertText( String s ) {
        String t= templTextField.getText();
        int i= templTextField.getCaretPosition();
        t= t.substring(0,i) + s + t.substring(i);
        templTextField.setText(t);
    }
    
    private MouseListener myMouseListener() {
        return new MouseListener() {
            @Override
            public void mouseClicked(MouseEvent e) {
                if ( uri!=null ) {
                    try {
                        Desktop.getDesktop().browse( uri );
                    } catch (IOException ex) {
                        logger.log(Level.SEVERE, null, ex);
                    }
                }
            }

            @Override
            public void mousePressed(MouseEvent e) {
                
            }

            @Override
            public void mouseReleased(MouseEvent e) {
                
            }

            @Override
            public void mouseEntered(MouseEvent e) {
                if ( uri!=null ) {
                    UriTemplatesStringSchemeEditor.this.setCursor(Cursor.getPredefinedCursor(Cursor.HAND_CURSOR));
                    setToolTipText( uri.toString() );
                }
            }

            @Override
            public void mouseExited(MouseEvent e) {
                if ( uri!=null ) {
                    UriTemplatesStringSchemeEditor.this.setCursor(Cursor.getPredefinedCursor(Cursor.DEFAULT_CURSOR));
                    setToolTipText( null );
                }
            }
            
        };
    }

    
    public static void main(String[] args) {
        UriTemplatesStringSchemeEditor edit= new UriTemplatesStringSchemeEditor();
        edit.setValue("$Y-$m-$d");
        if ( JOptionPane.OK_OPTION==JOptionPane.showConfirmDialog(null,edit) ) {
            System.err.println(edit.getValue());
        }
    }

    @Override
    public String getLabel() {
        return "URI Templates Editor";
    }

}
