/*
 * To change this license header, choose License Headers in Project Properties.
 * To change this template file, choose Tools | Templates
 * and open the template in the editor.
 */

package org.das2.qds.filters;

import java.util.regex.Matcher;
import java.util.regex.Pattern;

/**
 *
 * @author mmclouth
 */
public class FftPowerFilterEditorPanel extends AbstractFilterEditorPanel {
    private String slide;

    /**
     * Creates new form FftPowerFilterEditorPanel
     */
    public FftPowerFilterEditorPanel() {
        initComponents();
    }

    /**
     * This method is called from within the constructor to initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is always
     * regenerated by the Form Editor.
     */
    @SuppressWarnings("unchecked")
    // <editor-fold defaultstate="collapsed" desc="Generated Code">//GEN-BEGIN:initComponents
    private void initComponents() {

        jLabel1 = new javax.swing.JLabel();
        jLabel2 = new javax.swing.JLabel();
        jLabel3 = new javax.swing.JLabel();
        slideCB = new javax.swing.JComboBox();
        sizeTF = new javax.swing.JTextField();
        windowCB = new javax.swing.JComboBox();

        jLabel1.setText("Window Size: ");

        jLabel2.setText("Slide: ");

        jLabel3.setText("Window: ");

        slideCB.setModel(new javax.swing.DefaultComboBoxModel(new String[] { "No Overlap", "1/2 Overlap", "2/3 Overlap", "3/4 Overlap", "7/8 Overlap" }));
        slideCB.setMinimumSize(new java.awt.Dimension(125, 27));
        slideCB.setPreferredSize(new java.awt.Dimension(125, 27));

        sizeTF.setText("512");
        sizeTF.setPreferredSize(new java.awt.Dimension(90, 27));

        windowCB.setModel(new javax.swing.DefaultComboBoxModel(new String[] { "Hanning (Hann)", "TenPercentEdgeCosine", "Unity (Boxcar)" }));
        windowCB.setPreferredSize(new java.awt.Dimension(125, 27));

        org.jdesktop.layout.GroupLayout layout = new org.jdesktop.layout.GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(
            layout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
            .add(layout.createSequentialGroup()
                .addContainerGap()
                .add(layout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
                    .add(jLabel2)
                    .add(jLabel1)
                    .add(jLabel3))
                .addPreferredGap(org.jdesktop.layout.LayoutStyle.RELATED)
                .add(layout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
                    .add(sizeTF, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE)
                    .add(slideCB, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE)
                    .add(windowCB, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, 192, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE))
                .addContainerGap(29, Short.MAX_VALUE))
        );
        layout.setVerticalGroup(
            layout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
            .add(layout.createSequentialGroup()
                .addContainerGap()
                .add(layout.createParallelGroup(org.jdesktop.layout.GroupLayout.BASELINE)
                    .add(jLabel1)
                    .add(sizeTF, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE))
                .addPreferredGap(org.jdesktop.layout.LayoutStyle.RELATED)
                .add(layout.createParallelGroup(org.jdesktop.layout.GroupLayout.BASELINE)
                    .add(jLabel2)
                    .add(slideCB, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE))
                .addPreferredGap(org.jdesktop.layout.LayoutStyle.RELATED)
                .add(layout.createParallelGroup(org.jdesktop.layout.GroupLayout.BASELINE)
                    .add(windowCB, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE)
                    .add(jLabel3))
                .addContainerGap(org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE))
        );
    }// </editor-fold>//GEN-END:initComponents


    // Variables declaration - do not modify//GEN-BEGIN:variables
    public javax.swing.JLabel jLabel1;
    public javax.swing.JLabel jLabel2;
    public javax.swing.JLabel jLabel3;
    public javax.swing.JTextField sizeTF;
    public javax.swing.JComboBox slideCB;
    public javax.swing.JComboBox windowCB;
    // End of variables declaration//GEN-END:variables

    @Override
    public void setFilter(String filter) {
        Pattern p= Pattern.compile("\\|fftPower\\((\\d+),(\\d),'?(\\w+)\\'?\\)");
        Matcher m= p.matcher(filter);
        if ( m.matches() ) {
            sizeTF.setText( m.group(1) );
            if (m.group(2).equals("1")) {
                slideCB.setSelectedIndex(0);
            } else if (m.group(2).equals("2")) {
                slideCB.setSelectedIndex(1);
            } else if (m.group(2).equals("3")) {
                slideCB.setSelectedIndex(2);
            } else if (m.group(2).equals("4")) {
                slideCB.setSelectedIndex(3);
            } else if (m.group(2).equals("8")) {
                slideCB.setSelectedIndex(4);
            } else {
                slideCB.setSelectedIndex(0);
            }
            windowCB.setSelectedItem( m.group(3) );
        }
        else {
            sizeTF.setText("512");
            slideCB.setSelectedIndex( 0 );
            windowCB.setSelectedIndex( 0 );
        }
        
    }

    @Override
    public String getFilter() {
        if (slideCB.getSelectedItem().equals("No Overlap"))  {
            slide = "1";
        } else if (slideCB.getSelectedItem().equals("1/2 Overlap")) {
            slide = "2";
        } else if (slideCB.getSelectedItem().equals("2/3 Overlap")) {
            slide = "3";
        } else if (slideCB.getSelectedItem().equals("3/4 Overlap")) {
            slide = "4";
        } else if (slideCB.getSelectedItem().equals("7/8 Overlap")) {
            slide = "8";
        }
        String window= (String)windowCB.getSelectedItem();
        if ( window.startsWith("Hanning") ) window= "Hanning"; // This is because of (Hann) in parenthesis.
        if ( window.startsWith("Unity") ) window= "Unity";
        return "|fftPower(" + sizeTF.getText() + "," + slide + ",'" + window + "')";
    }
}
