/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.text.pdf;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.Arrays;
import java.util.Comparator;

public class CompareTool {
    private String gsExec;
    private String compareExec;
    private String gsParams = " -dNOPAUSE -dBATCH -sDEVICE=png16m -r150 -sOutputFile=<outputfile> <inputfile>";
    private String compareParams = " <image1> <image2> <difference>";
    private static String cannotOpenTargetDirectory = "Cannot open target directory for <filename>.";
    private static String gsFailed = "GhostScript failed for <filename>.";
    private static String unexpectedNumberOfPages = "Unexpected number of pages for <filename>.";
    private static String differentPages = "File <filename> differs on page <pagenumber>.";
    private static String undefinedGsPath = "Path to GhostScript is not specified. Please use -DgsExec=<path_to_ghostscript> (e.g. -DgsExec=\"C:/Program Files/gs/gs8.64/bin/gswin32c.exe\")";
    private String cmpPdf;
    private String cmpPdfName;
    private String cmpImage;
    private String outPdf;
    private String outPdfName;
    private String outImage;

    public CompareTool(String outPdf, String cmpPdf) {
        this.init(outPdf, cmpPdf);
        this.gsExec = System.getProperty("gsExec");
        this.compareExec = System.getProperty("compareExec");
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public String compare(String outPath, String differenceImage) throws IOException, InterruptedException {
        int cnt;
        String line;
        File[] cmpImageFiles;
        File[] imageFiles;
        if (this.gsExec == null || !new File(this.gsExec).exists()) {
            return undefinedGsPath;
        }
        File targetDir = new File(outPath);
        if (!targetDir.exists()) {
            targetDir.mkdir();
        } else {
            for (File file : imageFiles = targetDir.listFiles(new PngFileFilter())) {
                file.delete();
            }
            for (File file : cmpImageFiles = targetDir.listFiles(new CmpPngFileFilter())) {
                file.delete();
            }
        }
        File diffFile = new File(differenceImage);
        if (diffFile.exists()) {
            diffFile.delete();
        }
        if (!targetDir.exists()) return cannotOpenTargetDirectory.replace("<filename>", this.outPdf);
        String gsParams = this.gsParams.replace("<outputfile>", outPath + this.cmpImage).replace("<inputfile>", this.cmpPdf);
        Process p = Runtime.getRuntime().exec(this.gsExec + gsParams);
        BufferedReader bri = new BufferedReader(new InputStreamReader(p.getInputStream()));
        BufferedReader bre = new BufferedReader(new InputStreamReader(p.getErrorStream()));
        while ((line = bri.readLine()) != null) {
            System.out.println(line);
        }
        bri.close();
        while ((line = bre.readLine()) != null) {
            System.out.println(line);
        }
        bre.close();
        if (p.waitFor() != 0) return gsFailed.replace("<filename>", this.cmpPdf);
        gsParams = this.gsParams.replace("<outputfile>", outPath + this.outImage).replace("<inputfile>", this.outPdf);
        p = Runtime.getRuntime().exec(this.gsExec + gsParams);
        bri = new BufferedReader(new InputStreamReader(p.getInputStream()));
        bre = new BufferedReader(new InputStreamReader(p.getErrorStream()));
        while ((line = bri.readLine()) != null) {
            System.out.println(line);
        }
        bri.close();
        while ((line = bre.readLine()) != null) {
            System.out.println(line);
        }
        bre.close();
        int exitValue = p.waitFor();
        if (exitValue != 0) return gsFailed.replace("<filename>", this.outPdf);
        imageFiles = targetDir.listFiles(new PngFileFilter());
        cmpImageFiles = targetDir.listFiles(new CmpPngFileFilter());
        boolean bUnexpectedNumberOfPages = false;
        if (imageFiles.length != cmpImageFiles.length) {
            bUnexpectedNumberOfPages = true;
        }
        if ((cnt = Math.min(imageFiles.length, cmpImageFiles.length)) < 1) {
            return "No files for comparing!!!\nThe result or sample pdf file is not processed by GhostScript.";
        }
        Arrays.sort(imageFiles, new ImageNameComparator());
        Arrays.sort(cmpImageFiles, new ImageNameComparator());
        String differentPagesFail = null;
        for (int i = 0; i < cnt; ++i) {
            System.out.print("Comparing page " + Integer.toString(i + 1) + " (" + imageFiles[i].getAbsolutePath() + ")...");
            FileInputStream is1 = new FileInputStream(imageFiles[i]);
            FileInputStream is2 = new FileInputStream(cmpImageFiles[i]);
            boolean cmpResult = this.compareStreams(is1, is2);
            is1.close();
            is2.close();
            if (!cmpResult) {
                if (new File(this.compareExec).exists()) {
                    String compareParams = this.compareParams.replace("<image1>", imageFiles[i].getAbsolutePath()).replace("<image2>", cmpImageFiles[i].getAbsolutePath()).replace("<difference>", differenceImage + Integer.toString(i + 1) + ".png");
                    p = Runtime.getRuntime().exec(this.compareExec + compareParams);
                    bre = new BufferedReader(new InputStreamReader(p.getErrorStream()));
                    while ((line = bre.readLine()) != null) {
                        System.out.println(line);
                    }
                    bre.close();
                    int cmpExitValue = p.waitFor();
                    if (cmpExitValue == 0) {
                        if (differentPagesFail == null) {
                            differentPagesFail = differentPages.replace("<filename>", this.outPdf).replace("<pagenumber>", Integer.toString(i + 1));
                            differentPagesFail = differentPagesFail + "\nPlease, examine " + differenceImage + Integer.toString(i + 1) + ".png for more details.";
                        } else {
                            differentPagesFail = "File " + this.outPdf + " differs.\nPlease, examine difference images for more details.";
                        }
                    } else {
                        differentPagesFail = differentPages.replace("<filename>", this.outPdf).replace("<pagenumber>", Integer.toString(i + 1));
                    }
                } else {
                    differentPagesFail = differentPages.replace("<filename>", this.outPdf).replace("<pagenumber>", Integer.toString(i + 1));
                    differentPagesFail = differentPagesFail + "\nYou can optionally specify path to ImageMagick compare tool (e.g. -DcompareExec=\"C:/Program Files/ImageMagick-6.5.4-2/compare.exe\") to visualize differences.";
                    break;
                }
                System.out.println(differentPagesFail);
                continue;
            }
            System.out.println("done.");
        }
        if (differentPagesFail != null) {
            return differentPagesFail;
        }
        if (!bUnexpectedNumberOfPages) return null;
        return unexpectedNumberOfPages.replace("<filename>", this.outPdf) + "\n" + differentPagesFail;
    }

    public String compare(String outPdf, String cmpPdf, String outPath, String differenceImage) throws IOException, InterruptedException {
        this.init(outPdf, cmpPdf);
        return this.compare(outPath, differenceImage);
    }

    private void init(String outPdf, String cmpPdf) {
        this.outPdf = outPdf;
        this.cmpPdf = cmpPdf;
        this.outPdfName = new File(outPdf).getName();
        this.cmpPdfName = new File(cmpPdf).getName();
        this.outImage = this.outPdfName + "-%03d.png";
        this.cmpImage = "cmp_" + this.cmpPdfName + "-%03d.png";
    }

    private boolean compareStreams(InputStream is1, InputStream is2) throws IOException {
        byte[] buffer1 = new byte[65536];
        byte[] buffer2 = new byte[65536];
        int len1 = 0;
        int len2 = 0;
        do {
            if ((len1 = is1.read(buffer1)) != (len2 = is2.read(buffer2))) {
                return false;
            }
            if (Arrays.equals(buffer1, buffer2)) continue;
            return false;
        } while (len1 != -1 && len2 != -1);
        return true;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class ImageNameComparator
    implements Comparator<File> {
        ImageNameComparator() {
        }

        @Override
        public int compare(File f1, File f2) {
            String f1Name = f1.getAbsolutePath();
            String f2Name = f2.getAbsolutePath();
            return f1Name.compareTo(f2Name);
        }
    }

    class CmpPngFileFilter
    implements FileFilter {
        CmpPngFileFilter() {
        }

        public boolean accept(File pathname) {
            String ap = pathname.getAbsolutePath();
            boolean b1 = ap.endsWith(".png");
            boolean b2 = ap.contains("cmp_");
            return b1 && b2 && ap.contains(CompareTool.this.cmpPdfName);
        }
    }

    class PngFileFilter
    implements FileFilter {
        PngFileFilter() {
        }

        public boolean accept(File pathname) {
            String ap = pathname.getAbsolutePath();
            boolean b1 = ap.endsWith(".png");
            boolean b2 = ap.contains("cmp_");
            return b1 && !b2 && ap.contains(CompareTool.this.outPdfName);
        }
    }
}

