/*
 * To change this license header, choose License Headers in Project Properties.
 * To change this template file, choose Tools | Templates
 * and open the template in the editor.
 */

package org.das2.qds.filters;

import java.util.logging.Level;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

/**
 * Clean Data filter
 * @author jbfaden
 */
public class CleanDataFilterEditorPanel extends AbstractFilterEditorPanel {

    /**
     * Creates new form SmoothFilterEditorPanel
     */
    public CleanDataFilterEditorPanel() {
        initComponents();
    }

    /**
     * This method is called from within the constructor to initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is always
     * regenerated by the Form Editor.
     */
    @SuppressWarnings("unchecked")
    // <editor-fold defaultstate="collapsed" desc="Generated Code">//GEN-BEGIN:initComponents
    private void initComponents() {
        bindingGroup = new org.jdesktop.beansbinding.BindingGroup();

        jCheckBox1 = new javax.swing.JCheckBox();
        sizeTF = new javax.swing.JTextField();
        boxCarTextField = new javax.swing.JCheckBox();
        jLabel2 = new javax.swing.JLabel();
        jLabel1 = new javax.swing.JLabel();
        nsigmaTF = new javax.swing.JTextField();

        jCheckBox1.setText("jCheckBox1");

        sizeTF.setText("3");
        sizeTF.setPreferredSize(new java.awt.Dimension(50, 27));

        org.jdesktop.beansbinding.Binding binding = org.jdesktop.beansbinding.Bindings.createAutoBinding(org.jdesktop.beansbinding.AutoBinding.UpdateStrategy.READ_WRITE, boxCarTextField, org.jdesktop.beansbinding.ELProperty.create("${selected}"), sizeTF, org.jdesktop.beansbinding.BeanProperty.create("enabled"));
        bindingGroup.addBinding(binding);

        boxCarTextField.setText("Use sliding boxcar of length:");

        jLabel2.setText("Clean data by removing points which are N stddevs away from the mean");

        jLabel1.setText("Number of stddevs:");

        nsigmaTF.setText("3.0");

        org.jdesktop.layout.GroupLayout layout = new org.jdesktop.layout.GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(
            layout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
            .add(layout.createSequentialGroup()
                .addContainerGap()
                .add(layout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
                    .add(layout.createSequentialGroup()
                        .add(12, 12, 12)
                        .add(boxCarTextField)
                        .addPreferredGap(org.jdesktop.layout.LayoutStyle.RELATED)
                        .add(sizeTF, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE)
                        .add(30, 30, 30)
                        .add(jLabel1)
                        .addPreferredGap(org.jdesktop.layout.LayoutStyle.RELATED)
                        .add(nsigmaTF, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, 49, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE))
                    .add(jLabel2))
                .addContainerGap(54, Short.MAX_VALUE))
        );
        layout.setVerticalGroup(
            layout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
            .add(layout.createSequentialGroup()
                .addContainerGap()
                .add(jLabel2)
                .addPreferredGap(org.jdesktop.layout.LayoutStyle.RELATED)
                .add(layout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
                    .add(nsigmaTF, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE)
                    .add(layout.createParallelGroup(org.jdesktop.layout.GroupLayout.BASELINE)
                        .add(sizeTF, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE)
                        .add(boxCarTextField)
                        .add(jLabel1)))
                .addContainerGap())
        );

        layout.linkSize(new java.awt.Component[] {nsigmaTF, sizeTF}, org.jdesktop.layout.GroupLayout.VERTICAL);

        bindingGroup.bind();
    }// </editor-fold>//GEN-END:initComponents


    public static final String PROP_REGEX= "\\|cleanData\\(([-\\d]*)(\\,([\\d\\.]+))?\\)";
    
    // Variables declaration - do not modify//GEN-BEGIN:variables
    public javax.swing.JCheckBox boxCarTextField;
    public javax.swing.JCheckBox jCheckBox1;
    public javax.swing.JLabel jLabel1;
    public javax.swing.JLabel jLabel2;
    public javax.swing.JTextField nsigmaTF;
    public javax.swing.JTextField sizeTF;
    private org.jdesktop.beansbinding.BindingGroup bindingGroup;
    // End of variables declaration//GEN-END:variables

    @Override
    public void setFilter(String filter) {
        Pattern p= Pattern.compile(PROP_REGEX);
        Matcher m= p.matcher(filter);
        if ( m.matches() ) {
            String size= m.group(1);
            if ( size.trim().length()>0 ) {
                sizeTF.setText( m.group(1) );
                boxCarTextField.setSelected(true);
            } else {
                sizeTF.setText( "-1" );
                boxCarTextField.setSelected(false);
            }
            if ( m.group(3)!=null ) {
                String nsigma= m.group(3).trim();
                if ( nsigma.length()==0 ) {
                    nsigmaTF.setText("3.");
                } else {
                    nsigmaTF.setText( nsigma );
                }
            } else {
                nsigmaTF.setText("3.");
            }
        }
        
    }

    @Override
    public String getFilter() {
        double nsigma=3;
        try {
            nsigma= Double.parseDouble( nsigmaTF.getText() );
        } catch ( NumberFormatException ex ) {
            logger.log(Level.WARNING, "unable to parse as double: {0}", nsigmaTF.getText());
        }
        
        if ( boxCarTextField.isSelected() ) {
            if ( nsigma==3.0 ) {
                return "|cleanData(" + sizeTF.getText() + ")";
            }else {
                return "|cleanData(" + sizeTF.getText() + ","+ nsigmaTF.getText()+ ")";
            }            
        } else {
            if ( nsigma==3.0 ) {
                return "|cleanData()";
            } else {
                return "|cleanData(-1,"+ nsigmaTF.getText() + ")";
            }
        }
    }
}
