
package org.das2.datum;

import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Map.Entry;
import javax.swing.SwingUtilities;

/**
 *
 * @author jbf
 */
public class TimeTemplatorFieldPicker extends javax.swing.JPanel {
    private String[] formatted;
    private String template;
    private int selectionStart;
    private int selectionEnd;

    /**
     * Creates new form TimeTemplatorFieldPicker
     */
    public TimeTemplatorFieldPicker() {
        initComponents();
    }
    
    public void setFormatted( String[] formatted ) {
        this.formatted= formatted;
    }

    public void setTemplate( String template ) {
        this.template= template;
        this.templateTextField.setText(template);
    }

    public String getTemplate() {
        return this.template;
    }
    
    public void setSelection( int i0, int i1 ) {
        this.selectionStart= i0;
        this.selectionEnd= i1;
        int imax= Integer.MIN_VALUE;
        int imin= Integer.MAX_VALUE;
        if ( this.formatted!=null ) {
            Map<String,Integer> other= new LinkedHashMap();
            for ( String formatted1 : formatted ) {
                try {
                    String s = formatted1.substring(i0, i1);
                    try {
                        int i=  Integer.parseInt(s);
                        imin= Math.min( imin, i );
                        imax= Math.max( imax, i );
                    } catch ( NumberFormatException ex ) {
                        Integer i= other.get(s);
                        if ( i==null ) {
                            other.put( s, 1 );
                        } else {
                            other.put( s, i+1 );
                        }
                    }
                } catch ( IndexOutOfBoundsException ex ) {
                    System.err.println("Resulted in IndexOutOfBoundsException: "+formatted1);
                }
            }
            if ( other.isEmpty() && imax>Integer.MIN_VALUE ) {
                statsLabel.setText( "Numbers vary from "+imin + " through " + imax + ".");
            } else {
                StringBuilder b= new StringBuilder();
                for ( Entry<String,Integer> s: other.entrySet() ) {
                    b.append(s.getKey());
                    b.append("(").append(s.getValue()).append(") ");
                    if ( b.length()>60 ) break;
                }
                statsLabel.setText( "Includes: "+b.toString() );
            }
            
        }
        this.templateTextField.setSelectionStart(selectionStart);
        this.templateTextField.setSelectionEnd(selectionEnd);
    }
    
    private void closeDialog() {
        SwingUtilities.getWindowAncestor(this).setVisible(false);
    }
    
    /**
     * This method is called from within the constructor to initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is always
     * regenerated by the Form Editor.
     */
    @SuppressWarnings("unchecked")
    // <editor-fold defaultstate="collapsed" desc="Generated Code">//GEN-BEGIN:initComponents
    private void initComponents() {

        templateTextField = new javax.swing.JTextField();
        statsLabel = new javax.swing.JLabel();
        capyButton = new javax.swing.JButton();
        ybutton = new javax.swing.JButton();
        jLabel2 = new javax.swing.JLabel();
        jLabel3 = new javax.swing.JLabel();
        mButton = new javax.swing.JButton();
        jLabel4 = new javax.swing.JLabel();
        dButton = new javax.swing.JButton();
        jLabel5 = new javax.swing.JLabel();
        jButton = new javax.swing.JButton();
        jLabel6 = new javax.swing.JLabel();
        caphButton = new javax.swing.JButton();
        capmButton = new javax.swing.JButton();
        capsButton = new javax.swing.JButton();
        jLabel7 = new javax.swing.JLabel();
        jLabel8 = new javax.swing.JLabel();
        jLabel9 = new javax.swing.JLabel();
        jButton9 = new javax.swing.JButton();
        jLabel10 = new javax.swing.JLabel();
        jButton10 = new javax.swing.JButton();
        jLabel11 = new javax.swing.JLabel();
        capymdButton = new javax.swing.JButton();
        caphCapmCapsButton = new javax.swing.JButton();
        jLabel1 = new javax.swing.JLabel();
        jLabel12 = new javax.swing.JLabel();
        jButton1 = new javax.swing.JButton();
        jLabel13 = new javax.swing.JLabel();

        templateTextField.setText("jTextField1");

        statsLabel.setText("jLabel1");

        capyButton.setText("$Y");
        capyButton.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                fieldButtonActionPerformed(evt);
            }
        });

        ybutton.setText("$y");
        ybutton.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                fieldButtonActionPerformed(evt);
            }
        });

        jLabel2.setText("Four-Digit Year");

        jLabel3.setText("Two-Digit Year");

        mButton.setText("$m");
        mButton.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                fieldButtonActionPerformed(evt);
            }
        });

        jLabel4.setText("Month");

        dButton.setText("$d");
        dButton.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                fieldButtonActionPerformed(evt);
            }
        });

        jLabel5.setText("Day of Month");

        jButton.setText("$j");
        jButton.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                fieldButtonActionPerformed(evt);
            }
        });

        jLabel6.setText("Day of Year");

        caphButton.setText("$H");
        caphButton.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                fieldButtonActionPerformed(evt);
            }
        });

        capmButton.setText("$M");
        capmButton.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                fieldButtonActionPerformed(evt);
            }
        });

        capsButton.setText("$S");
        capsButton.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                fieldButtonActionPerformed(evt);
            }
        });

        jLabel7.setText("Hour of day");

        jLabel8.setText("Minute of hour");

        jLabel9.setText("Second of hour");

        jButton9.setText("$x");
        jButton9.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                fieldButtonActionPerformed(evt);
            }
        });

        jLabel10.setText("Ignore");

        jButton10.setText("$v");

        jLabel11.setText("Version Number");

        capymdButton.setText("$Y$m$d");
        capymdButton.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                capymdButtonActionPerformed(evt);
            }
        });

        caphCapmCapsButton.setText("$H$M$S");
        caphCapmCapsButton.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                caphCapmCapsButtonActionPerformed(evt);
            }
        });

        jLabel1.setText("Guess date");

        jLabel12.setText("Guess time");

        jButton1.setText("$P");

        jLabel13.setText("AM/PM");

        javax.swing.GroupLayout layout = new javax.swing.GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(
            layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addComponent(templateTextField)
            .addGroup(layout.createSequentialGroup()
                .addContainerGap()
                .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                    .addComponent(statsLabel, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE)
                    .addGroup(layout.createSequentialGroup()
                        .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                            .addGroup(layout.createSequentialGroup()
                                .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                                    .addComponent(dButton, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE)
                                    .addComponent(mButton, javax.swing.GroupLayout.PREFERRED_SIZE, 41, javax.swing.GroupLayout.PREFERRED_SIZE))
                                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                                .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                                    .addComponent(jLabel4)
                                    .addComponent(jLabel5)))
                            .addGroup(layout.createSequentialGroup()
                                .addComponent(jButton)
                                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                                .addComponent(jLabel6)))
                        .addGap(50, 50, 50)
                        .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                            .addGroup(javax.swing.GroupLayout.Alignment.TRAILING, layout.createSequentialGroup()
                                .addComponent(caphCapmCapsButton)
                                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                                .addComponent(jLabel12)
                                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED, 45, Short.MAX_VALUE))
                            .addGroup(layout.createSequentialGroup()
                                .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                                    .addGroup(layout.createSequentialGroup()
                                        .addComponent(capmButton)
                                        .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                                        .addComponent(jLabel8))
                                    .addGroup(layout.createSequentialGroup()
                                        .addComponent(caphButton, javax.swing.GroupLayout.PREFERRED_SIZE, 43, javax.swing.GroupLayout.PREFERRED_SIZE)
                                        .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                                        .addComponent(jLabel7))
                                    .addGroup(layout.createSequentialGroup()
                                        .addComponent(ybutton, javax.swing.GroupLayout.PREFERRED_SIZE, 53, javax.swing.GroupLayout.PREFERRED_SIZE)
                                        .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                                        .addComponent(jLabel3))
                                    .addGroup(layout.createSequentialGroup()
                                        .addComponent(capymdButton, javax.swing.GroupLayout.PREFERRED_SIZE, 78, javax.swing.GroupLayout.PREFERRED_SIZE)
                                        .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                                        .addComponent(jLabel1))
                                    .addGroup(layout.createSequentialGroup()
                                        .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.TRAILING, false)
                                            .addComponent(jButton1, javax.swing.GroupLayout.Alignment.LEADING, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE)
                                            .addComponent(capsButton, javax.swing.GroupLayout.Alignment.LEADING, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE))
                                        .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                                        .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                                            .addComponent(jLabel9)
                                            .addComponent(jLabel13))))
                                .addGap(0, 0, Short.MAX_VALUE))))
                    .addGroup(layout.createSequentialGroup()
                        .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                            .addGroup(layout.createSequentialGroup()
                                .addComponent(capyButton, javax.swing.GroupLayout.PREFERRED_SIZE, 57, javax.swing.GroupLayout.PREFERRED_SIZE)
                                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                                .addComponent(jLabel2))
                            .addGroup(layout.createSequentialGroup()
                                .addComponent(jButton9)
                                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                                .addComponent(jLabel10))
                            .addGroup(layout.createSequentialGroup()
                                .addComponent(jButton10)
                                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                                .addComponent(jLabel11)))
                        .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED, 232, Short.MAX_VALUE)))
                .addContainerGap())
        );

        layout.linkSize(javax.swing.SwingConstants.HORIZONTAL, new java.awt.Component[] {capyButton, dButton, jButton, jButton10, jButton9, mButton});

        layout.linkSize(javax.swing.SwingConstants.HORIZONTAL, new java.awt.Component[] {caphButton, capmButton, capsButton, ybutton});

        layout.linkSize(javax.swing.SwingConstants.HORIZONTAL, new java.awt.Component[] {caphCapmCapsButton, capymdButton});

        layout.setVerticalGroup(
            layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(layout.createSequentialGroup()
                .addComponent(templateTextField, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addComponent(statsLabel)
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.BASELINE)
                    .addComponent(capyButton)
                    .addComponent(ybutton)
                    .addComponent(jLabel2)
                    .addComponent(jLabel3))
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.BASELINE)
                    .addComponent(mButton)
                    .addComponent(jLabel4)
                    .addComponent(caphButton)
                    .addComponent(jLabel7))
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.BASELINE)
                    .addComponent(dButton)
                    .addComponent(jLabel5)
                    .addComponent(capmButton)
                    .addComponent(jLabel8))
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.BASELINE)
                    .addComponent(jButton)
                    .addComponent(jLabel6)
                    .addComponent(capsButton)
                    .addComponent(jLabel9))
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.BASELINE)
                    .addComponent(jButton1)
                    .addComponent(jLabel13))
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED, 33, Short.MAX_VALUE)
                .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.BASELINE)
                    .addComponent(jButton10)
                    .addComponent(jLabel11)
                    .addComponent(capymdButton)
                    .addComponent(jLabel1))
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.BASELINE)
                    .addComponent(jButton9)
                    .addComponent(jLabel10)
                    .addComponent(caphCapmCapsButton)
                    .addComponent(jLabel12))
                .addContainerGap())
        );
    }// </editor-fold>//GEN-END:initComponents

    private void fieldButtonActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_fieldButtonActionPerformed
        String field= evt.getActionCommand();
        template= template.substring(0,selectionStart) + field+ template.substring(selectionEnd);
        closeDialog();
    }//GEN-LAST:event_fieldButtonActionPerformed

    private void capymdButtonActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_capymdButtonActionPerformed
        int nc= selectionEnd-selectionStart;
        String field;
        if ( nc==4 ) {
            field= "$Y";
        } else if ( nc==5 ) {
            field= "$y$j";
        } else if ( nc==6 ) {
            field= "$Y$m";
        } else if ( nc==7 ) {
            field= "$Y$j";
        } else if ( nc==8 ) {
            field= "$Y$m$d";
        } else {
            field= "$Y$m$d";
        }
        template= template.substring(0,selectionStart) + field+ template.substring(selectionEnd);
        closeDialog();
    }//GEN-LAST:event_capymdButtonActionPerformed

    private void caphCapmCapsButtonActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_caphCapmCapsButtonActionPerformed
        int nc= selectionEnd-selectionStart;
        String field;
        if ( nc==4 ) {
            field= "$H$M";
        } else if ( nc==6 ) {
            field= "$H$M$S";
        } else {
            field= "$H$M$S";
        }
        template= template.substring(0,selectionStart) + field+ template.substring(selectionEnd);
        closeDialog();
    }//GEN-LAST:event_caphCapmCapsButtonActionPerformed


    // Variables declaration - do not modify//GEN-BEGIN:variables
    private javax.swing.JButton caphButton;
    private javax.swing.JButton caphCapmCapsButton;
    private javax.swing.JButton capmButton;
    private javax.swing.JButton capsButton;
    private javax.swing.JButton capyButton;
    private javax.swing.JButton capymdButton;
    private javax.swing.JButton dButton;
    private javax.swing.JButton jButton;
    private javax.swing.JButton jButton1;
    private javax.swing.JButton jButton10;
    private javax.swing.JButton jButton9;
    private javax.swing.JLabel jLabel1;
    private javax.swing.JLabel jLabel10;
    private javax.swing.JLabel jLabel11;
    private javax.swing.JLabel jLabel12;
    private javax.swing.JLabel jLabel13;
    private javax.swing.JLabel jLabel2;
    private javax.swing.JLabel jLabel3;
    private javax.swing.JLabel jLabel4;
    private javax.swing.JLabel jLabel5;
    private javax.swing.JLabel jLabel6;
    private javax.swing.JLabel jLabel7;
    private javax.swing.JLabel jLabel8;
    private javax.swing.JLabel jLabel9;
    private javax.swing.JButton mButton;
    private javax.swing.JLabel statsLabel;
    private javax.swing.JTextField templateTextField;
    private javax.swing.JButton ybutton;
    // End of variables declaration//GEN-END:variables

}
