
package org.das2.components.propertyeditor;

import org.das2.util.StringSchemeEditor;
import java.awt.Component;

/**
 * Example specialized editor that creates ticks specifications
 * @author jbf
 */
public class TickValuesStringSchemeEditor extends javax.swing.JPanel implements StringSchemeEditor {

    public static final String EDITOR_TITLE= "Tick Values Editor";
    
    /**
     * Creates new form TickValuesEditor
     */
    public TickValuesStringSchemeEditor() {
        initComponents();
    }

    /**
     * This method is called from within the constructor to initialize the form. WARNING: Do NOT modify this code. The content of
     * this method is always regenerated by the Form Editor.
     */
    @SuppressWarnings("unchecked")
    // <editor-fold defaultstate="collapsed" desc="Generated Code">//GEN-BEGIN:initComponents
    private void initComponents() {
        bindingGroup = new org.jdesktop.beansbinding.BindingGroup();

        majorButtonGroup = new javax.swing.ButtonGroup();
        minorButtonGroup = new javax.swing.ButtonGroup();
        jLabel1 = new javax.swing.JLabel();
        valueTextField = new javax.swing.JTextField();
        jLabel2 = new javax.swing.JLabel();
        majorListOfLocationsRB = new javax.swing.JRadioButton();
        majorRepeatEveryRB = new javax.swing.JRadioButton();
        alsoUseMinorCB = new javax.swing.JCheckBox();
        repeatEveryCB = new javax.swing.JComboBox<>();
        majorListOfLocationsTF = new javax.swing.JTextField();
        minorPanel = new javax.swing.JPanel();
        minorListOfLocationsRB = new javax.swing.JRadioButton();
        minorListOfLocationsTF = new javax.swing.JTextField();
        minorFixedNumberIntervalsRB = new javax.swing.JRadioButton();
        fixedNumberMinorCB = new javax.swing.JComboBox<>();
        minorRepeatEveryRB = new javax.swing.JRadioButton();
        repeatEveryCB1 = new javax.swing.JComboBox<>();
        jLabel3 = new javax.swing.JLabel();

        jLabel1.setText("<html>Enter a specification of how ticks should be generated.  If empty, the default methods are used,  or this can take one of the following forms: \n<ul>\n<li>10,20,30<i> - major ticks at 10,20, and 30 </i>\n<li>+10/4<i> - major ticks every ten units </i>\n<li>*10<i> - major ticks every cycle (10,100,1000,etc) </i>\n<li>+10min/5<i> - ticks every 10 minutes, with 5 divisions </i>\n<li>10,100,1000/50,500,5000<i> -  major and minor ticks </i>\n<li>none<i> - no ticks</i><ul> ");
        jLabel1.setVerticalAlignment(javax.swing.SwingConstants.TOP);
        jLabel1.setVerticalTextPosition(javax.swing.SwingConstants.TOP);

        valueTextField.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                valueTextFieldActionPerformed(evt);
            }
        });

        jLabel2.setText("For the Major Ticks (with Labels):");

        majorButtonGroup.add(majorListOfLocationsRB);
        majorListOfLocationsRB.setSelected(true);
        majorListOfLocationsRB.setText("list of locations:");

        majorButtonGroup.add(majorRepeatEveryRB);
        majorRepeatEveryRB.setText("repeat every:");

        alsoUseMinorCB.setText("Also Use the Minor Ticks:");

        repeatEveryCB.setEditable(true);
        repeatEveryCB.setModel(new javax.swing.DefaultComboBoxModel<>(new String[] { "+10:  every ten units", "+5 days: specify with unit", "+2hr: specify with unit", "*10: every cycle on log plot", "*100: every two cycles on log plot", " " }));

        org.jdesktop.beansbinding.Binding binding = org.jdesktop.beansbinding.Bindings.createAutoBinding(org.jdesktop.beansbinding.AutoBinding.UpdateStrategy.READ_WRITE, majorRepeatEveryRB, org.jdesktop.beansbinding.ELProperty.create("${selected}"), repeatEveryCB, org.jdesktop.beansbinding.BeanProperty.create("enabled"));
        bindingGroup.addBinding(binding);

        repeatEveryCB.addFocusListener(new java.awt.event.FocusAdapter() {
            public void focusLost(java.awt.event.FocusEvent evt) {
                repeatEveryCBFocusLost(evt);
            }
        });
        repeatEveryCB.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                repeatEveryCBActionPerformed(evt);
            }
        });

        binding = org.jdesktop.beansbinding.Bindings.createAutoBinding(org.jdesktop.beansbinding.AutoBinding.UpdateStrategy.READ_WRITE, majorListOfLocationsRB, org.jdesktop.beansbinding.ELProperty.create("${selected}"), majorListOfLocationsTF, org.jdesktop.beansbinding.BeanProperty.create("enabled"));
        bindingGroup.addBinding(binding);

        majorListOfLocationsTF.addFocusListener(new java.awt.event.FocusAdapter() {
            public void focusLost(java.awt.event.FocusEvent evt) {
                majorListOfLocationsTFFocusLost(evt);
            }
        });
        majorListOfLocationsTF.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                majorListOfLocationsTFActionPerformed(evt);
            }
        });

        binding = org.jdesktop.beansbinding.Bindings.createAutoBinding(org.jdesktop.beansbinding.AutoBinding.UpdateStrategy.READ_WRITE, alsoUseMinorCB, org.jdesktop.beansbinding.ELProperty.create("${selected}"), minorPanel, org.jdesktop.beansbinding.BeanProperty.create("enabled"));
        bindingGroup.addBinding(binding);

        minorButtonGroup.add(minorListOfLocationsRB);
        minorListOfLocationsRB.setText("list of locations:");

        binding = org.jdesktop.beansbinding.Bindings.createAutoBinding(org.jdesktop.beansbinding.AutoBinding.UpdateStrategy.READ_WRITE, alsoUseMinorCB, org.jdesktop.beansbinding.ELProperty.create("${selected}"), minorListOfLocationsRB, org.jdesktop.beansbinding.BeanProperty.create("enabled"));
        bindingGroup.addBinding(binding);

        binding = org.jdesktop.beansbinding.Bindings.createAutoBinding(org.jdesktop.beansbinding.AutoBinding.UpdateStrategy.READ_WRITE, minorListOfLocationsRB, org.jdesktop.beansbinding.ELProperty.create("${selected}"), minorListOfLocationsTF, org.jdesktop.beansbinding.BeanProperty.create("enabled"));
        bindingGroup.addBinding(binding);

        minorListOfLocationsTF.addFocusListener(new java.awt.event.FocusAdapter() {
            public void focusLost(java.awt.event.FocusEvent evt) {
                minorListOfLocationsTFFocusLost(evt);
            }
        });
        minorListOfLocationsTF.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                minorListOfLocationsTFActionPerformed(evt);
            }
        });

        minorButtonGroup.add(minorFixedNumberIntervalsRB);
        minorFixedNumberIntervalsRB.setSelected(true);
        minorFixedNumberIntervalsRB.setText("fixed number of intervals per major tick interval:");

        binding = org.jdesktop.beansbinding.Bindings.createAutoBinding(org.jdesktop.beansbinding.AutoBinding.UpdateStrategy.READ_WRITE, alsoUseMinorCB, org.jdesktop.beansbinding.ELProperty.create("${selected}"), minorFixedNumberIntervalsRB, org.jdesktop.beansbinding.BeanProperty.create("enabled"));
        bindingGroup.addBinding(binding);

        fixedNumberMinorCB.setEditable(true);
        fixedNumberMinorCB.setModel(new javax.swing.DefaultComboBoxModel<>(new String[] { "2", "3", "4", "5", "6" }));

        binding = org.jdesktop.beansbinding.Bindings.createAutoBinding(org.jdesktop.beansbinding.AutoBinding.UpdateStrategy.READ_WRITE, minorFixedNumberIntervalsRB, org.jdesktop.beansbinding.ELProperty.create("${selected}"), fixedNumberMinorCB, org.jdesktop.beansbinding.BeanProperty.create("enabled"));
        bindingGroup.addBinding(binding);

        fixedNumberMinorCB.addFocusListener(new java.awt.event.FocusAdapter() {
            public void focusLost(java.awt.event.FocusEvent evt) {
                fixedNumberMinorCBFocusLost(evt);
            }
        });
        fixedNumberMinorCB.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                fixedNumberMinorCBActionPerformed(evt);
            }
        });

        minorButtonGroup.add(minorRepeatEveryRB);
        minorRepeatEveryRB.setText("repeat every:");

        binding = org.jdesktop.beansbinding.Bindings.createAutoBinding(org.jdesktop.beansbinding.AutoBinding.UpdateStrategy.READ_WRITE, alsoUseMinorCB, org.jdesktop.beansbinding.ELProperty.create("${selected}"), minorRepeatEveryRB, org.jdesktop.beansbinding.BeanProperty.create("enabled"));
        bindingGroup.addBinding(binding);

        repeatEveryCB1.setEditable(true);
        repeatEveryCB1.setModel(new javax.swing.DefaultComboBoxModel<>(new String[] { "+1:  every unit", "+1 days: specify with unit", "+2hr: specify with unit", "+1: every cycle on log plot" }));

        binding = org.jdesktop.beansbinding.Bindings.createAutoBinding(org.jdesktop.beansbinding.AutoBinding.UpdateStrategy.READ_WRITE, minorRepeatEveryRB, org.jdesktop.beansbinding.ELProperty.create("${selected}"), repeatEveryCB1, org.jdesktop.beansbinding.BeanProperty.create("enabled"));
        bindingGroup.addBinding(binding);

        repeatEveryCB1.addFocusListener(new java.awt.event.FocusAdapter() {
            public void focusLost(java.awt.event.FocusEvent evt) {
                repeatEveryCB1FocusLost(evt);
            }
        });
        repeatEveryCB1.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                repeatEveryCB1ActionPerformed(evt);
            }
        });

        javax.swing.GroupLayout minorPanelLayout = new javax.swing.GroupLayout(minorPanel);
        minorPanel.setLayout(minorPanelLayout);
        minorPanelLayout.setHorizontalGroup(
            minorPanelLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(minorPanelLayout.createSequentialGroup()
                .addGroup(minorPanelLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                    .addGroup(minorPanelLayout.createSequentialGroup()
                        .addGroup(minorPanelLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                            .addGroup(minorPanelLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                                .addComponent(minorFixedNumberIntervalsRB, javax.swing.GroupLayout.Alignment.TRAILING)
                                .addComponent(minorListOfLocationsRB)
                                .addGroup(minorPanelLayout.createSequentialGroup()
                                    .addGap(21, 21, 21)
                                    .addComponent(fixedNumberMinorCB, javax.swing.GroupLayout.PREFERRED_SIZE, 93, javax.swing.GroupLayout.PREFERRED_SIZE)))
                            .addComponent(minorRepeatEveryRB)
                            .addGroup(minorPanelLayout.createSequentialGroup()
                                .addGap(21, 21, 21)
                                .addComponent(repeatEveryCB1, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)))
                        .addGap(0, 0, Short.MAX_VALUE))
                    .addGroup(javax.swing.GroupLayout.Alignment.TRAILING, minorPanelLayout.createSequentialGroup()
                        .addGap(0, 0, Short.MAX_VALUE)
                        .addComponent(minorListOfLocationsTF, javax.swing.GroupLayout.PREFERRED_SIZE, 339, javax.swing.GroupLayout.PREFERRED_SIZE)))
                .addContainerGap())
        );
        minorPanelLayout.setVerticalGroup(
            minorPanelLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(javax.swing.GroupLayout.Alignment.TRAILING, minorPanelLayout.createSequentialGroup()
                .addComponent(minorListOfLocationsRB)
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addComponent(minorListOfLocationsTF, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
                .addGap(11, 11, 11)
                .addComponent(minorFixedNumberIntervalsRB)
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addComponent(fixedNumberMinorCB, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addComponent(minorRepeatEveryRB)
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addComponent(repeatEveryCB1, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
                .addContainerGap(33, Short.MAX_VALUE))
        );

        jLabel3.setText("Specification:");

        javax.swing.GroupLayout layout = new javax.swing.GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(
            layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(layout.createSequentialGroup()
                .addContainerGap()
                .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                    .addComponent(jLabel1, javax.swing.GroupLayout.PREFERRED_SIZE, 0, Short.MAX_VALUE)
                    .addGroup(layout.createSequentialGroup()
                        .addGap(12, 12, 12)
                        .addComponent(jLabel3)
                        .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                        .addComponent(valueTextField, javax.swing.GroupLayout.PREFERRED_SIZE, 706, javax.swing.GroupLayout.PREFERRED_SIZE)
                        .addGap(0, 0, Short.MAX_VALUE))
                    .addGroup(layout.createSequentialGroup()
                        .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                            .addComponent(jLabel2)
                            .addGroup(layout.createSequentialGroup()
                                .addGap(12, 12, 12)
                                .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                                    .addComponent(majorRepeatEveryRB)
                                    .addComponent(majorListOfLocationsRB)
                                    .addGroup(layout.createSequentialGroup()
                                        .addGap(21, 21, 21)
                                        .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                                            .addComponent(majorListOfLocationsTF, javax.swing.GroupLayout.PREFERRED_SIZE, 355, javax.swing.GroupLayout.PREFERRED_SIZE)
                                            .addComponent(repeatEveryCB, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE))))))
                        .addGap(40, 40, 40)
                        .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                            .addGroup(layout.createSequentialGroup()
                                .addGap(21, 21, 21)
                                .addComponent(minorPanel, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE)
                                .addContainerGap())
                            .addComponent(alsoUseMinorCB)))))
        );
        layout.setVerticalGroup(
            layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(layout.createSequentialGroup()
                .addComponent(jLabel1, javax.swing.GroupLayout.PREFERRED_SIZE, 130, javax.swing.GroupLayout.PREFERRED_SIZE)
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.BASELINE)
                    .addComponent(valueTextField, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
                    .addComponent(jLabel3))
                .addGap(18, 18, 18)
                .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.BASELINE)
                    .addComponent(jLabel2)
                    .addComponent(alsoUseMinorCB))
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                    .addGroup(layout.createSequentialGroup()
                        .addComponent(majorListOfLocationsRB)
                        .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.UNRELATED)
                        .addComponent(majorListOfLocationsTF, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
                        .addGap(5, 5, 5)
                        .addComponent(majorRepeatEveryRB)
                        .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                        .addComponent(repeatEveryCB, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE))
                    .addComponent(minorPanel, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)))
        );

        bindingGroup.bind();
    }// </editor-fold>//GEN-END:initComponents

    private void valueTextFieldActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_valueTextFieldActionPerformed
        updateComponents();
    }//GEN-LAST:event_valueTextFieldActionPerformed

    private void majorListOfLocationsTFActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_majorListOfLocationsTFActionPerformed
        update();
    }//GEN-LAST:event_majorListOfLocationsTFActionPerformed

    private void majorListOfLocationsTFFocusLost(java.awt.event.FocusEvent evt) {//GEN-FIRST:event_majorListOfLocationsTFFocusLost
        update();
    }//GEN-LAST:event_majorListOfLocationsTFFocusLost

    private void repeatEveryCBFocusLost(java.awt.event.FocusEvent evt) {//GEN-FIRST:event_repeatEveryCBFocusLost
        update();
    }//GEN-LAST:event_repeatEveryCBFocusLost

    private void repeatEveryCBActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_repeatEveryCBActionPerformed
        update();
    }//GEN-LAST:event_repeatEveryCBActionPerformed

    private void minorListOfLocationsTFActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_minorListOfLocationsTFActionPerformed
        update();
    }//GEN-LAST:event_minorListOfLocationsTFActionPerformed

    private void minorListOfLocationsTFFocusLost(java.awt.event.FocusEvent evt) {//GEN-FIRST:event_minorListOfLocationsTFFocusLost
        update();
    }//GEN-LAST:event_minorListOfLocationsTFFocusLost

    private void fixedNumberMinorCBActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_fixedNumberMinorCBActionPerformed
        update();
    }//GEN-LAST:event_fixedNumberMinorCBActionPerformed

    private void fixedNumberMinorCBFocusLost(java.awt.event.FocusEvent evt) {//GEN-FIRST:event_fixedNumberMinorCBFocusLost
        update();
    }//GEN-LAST:event_fixedNumberMinorCBFocusLost

    private void repeatEveryCB1FocusLost(java.awt.event.FocusEvent evt) {//GEN-FIRST:event_repeatEveryCB1FocusLost
        update();
    }//GEN-LAST:event_repeatEveryCB1FocusLost

    private void repeatEveryCB1ActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_repeatEveryCB1ActionPerformed
        update();
    }//GEN-LAST:event_repeatEveryCB1ActionPerformed

    private void updateComponents() {
        String spec= valueTextField.getText();
        String[] ss= spec.split("/",-2);
        if ( ss[0].length()>0 && ( ss[0].charAt(0)=='+' || ss[0].charAt(0)=='*') ) {
            majorRepeatEveryRB.setSelected(true);
            repeatEveryCB.setSelectedItem(ss[0]);
        } else {
            majorListOfLocationsTF.setText(ss[0]);
        }
        if ( ss.length>1 ) {
            alsoUseMinorCB.setSelected(true);
            if ( ss[1].split(",").length>1 ) {
                minorListOfLocationsTF.setText(ss[1]);
                minorListOfLocationsRB.setSelected(true);
            } else if ( !( ss[1].startsWith("+") || ss[1].startsWith("*") ) ) {
                fixedNumberMinorCB.setSelectedItem(ss[1]);
                minorFixedNumberIntervalsRB.setSelected(true);
            }  else {
                repeatEveryCB1.setSelectedItem(ss[1]);
                minorRepeatEveryRB.setSelected(true);                        
            }
        } else {
            alsoUseMinorCB.setSelected(false);
        }
    }

    // Variables declaration - do not modify//GEN-BEGIN:variables
    private javax.swing.JCheckBox alsoUseMinorCB;
    private javax.swing.JComboBox<String> fixedNumberMinorCB;
    private javax.swing.JLabel jLabel1;
    private javax.swing.JLabel jLabel2;
    private javax.swing.JLabel jLabel3;
    private javax.swing.ButtonGroup majorButtonGroup;
    private javax.swing.JRadioButton majorListOfLocationsRB;
    private javax.swing.JTextField majorListOfLocationsTF;
    private javax.swing.JRadioButton majorRepeatEveryRB;
    private javax.swing.ButtonGroup minorButtonGroup;
    private javax.swing.JRadioButton minorFixedNumberIntervalsRB;
    private javax.swing.JRadioButton minorListOfLocationsRB;
    private javax.swing.JTextField minorListOfLocationsTF;
    private javax.swing.JPanel minorPanel;
    private javax.swing.JRadioButton minorRepeatEveryRB;
    private javax.swing.JComboBox<String> repeatEveryCB;
    private javax.swing.JComboBox<String> repeatEveryCB1;
    private javax.swing.JTextField valueTextField;
    private org.jdesktop.beansbinding.BindingGroup bindingGroup;
    // End of variables declaration//GEN-END:variables

    @Override
    public void setValue(String v) {
        this.valueTextField.setText(v);
        updateComponents();
    }

    @Override
    public String getValue() {
        update();
        return this.valueTextField.getText();
    }

    public void update() {
        StringBuilder build= new StringBuilder();
        if ( majorListOfLocationsRB.isSelected() ) {
            build.append(majorListOfLocationsTF.getText());
        } else {
            String text= (String)repeatEveryCB.getSelectedItem();
            int i= text.indexOf(":");
            if ( i>-1 ) text= text.substring(0,i).trim();
            if ( !( text.startsWith("+") || text.startsWith("*") ) ) {
                text= "+"+text;
            }
            build.append(text);
        }
        if ( alsoUseMinorCB.isSelected() ) {
            build.append("/");
            if ( minorListOfLocationsRB.isSelected() ) {
                build.append( minorListOfLocationsTF.getText() );
            } else if ( minorFixedNumberIntervalsRB.isSelected() ) {
                build.append( fixedNumberMinorCB.getSelectedItem().toString() );
            } else {
                String text= (String)repeatEveryCB1.getSelectedItem();
                int i= text.indexOf(":");
                if ( i>-1 ) text= text.substring(0,i).trim();
                if ( !( text.startsWith("+") || text.startsWith("*") ) ) {
                    text= "+"+text;
                }
                build.append( text );
            }
        }
        this.valueTextField.setText(build.toString());
    }
    
    @Override
    public Component getComponent() {
        return this;
    }

    @Override
    public void setContext(Object o) {
    }

    @Override
    public String getLabel() {
        return "Tick Values Editor";
    }
}
