
package org.das2.util;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.SwingUtilities;

/**
 * GUI for spawning command, where you can see output.
 * @author jbf
 */
public class ProcessPanel extends javax.swing.JPanel {

    /**
     * Creates new form ProcessPanel
     */
    public ProcessPanel() {
        initComponents();
    }

    ProcessBuilder builder;
    Process process;
    StringBuilder build;

    public void setCommand( String[] cmd ) {
        builder = new ProcessBuilder( cmd );
        SwingUtilities.invokeLater(() -> {
            jTextField1.setText( String.join( " " , cmd ) );
        });
    }
    
    public void setDirectory( File cwd ) {
        builder.directory( cwd );
    }    
    
    private void getOutput(Process p) {
        final BufferedReader r= new BufferedReader(new InputStreamReader(p.getInputStream()));
        Thread t= new Thread( () -> {
            try {
                String s= r.readLine();
                while ( s!=null ) {
                    build.append(s).append("\n");
                    jTextArea1.setText(build.toString());
                    s= r.readLine();
                }
            } catch (IOException ex) {
                Logger.getLogger(ProcessPanel.class.getName()).log(Level.SEVERE, null, ex);
            }
        });
        t.start();
    }

    private void getError(Process p) {
        final BufferedReader r= new BufferedReader(new InputStreamReader(p.getInputStream()));
        Thread t= new Thread( () -> {
            try {
                String s= r.readLine();
                while ( s!=null ) {
                    build.append(s).append("\n");
                    jTextArea1.setText(build.toString());
                    s= r.readLine();
                }
            } catch (IOException ex) {
                Logger.getLogger(ProcessPanel.class.getName()).log(Level.SEVERE, null, ex);
            }
        });
        t.start();
    }

    public void start() throws IOException {
        process= builder.start();
        build= new StringBuilder();
        getOutput(process);
        getError(process);
        
    }
    /**
     * This method is called from within the constructor to initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is always
     * regenerated by the Form Editor.
     */
    @SuppressWarnings("unchecked")
    // <editor-fold defaultstate="collapsed" desc="Generated Code">//GEN-BEGIN:initComponents
    private void initComponents() {

        jLabel1 = new javax.swing.JLabel();
        jTextField1 = new javax.swing.JTextField();
        jScrollPane1 = new javax.swing.JScrollPane();
        jTextArea1 = new javax.swing.JTextArea();

        jLabel1.setText("Command:");

        jTextField1.setText("jTextField1");

        jTextArea1.setColumns(20);
        jTextArea1.setRows(5);
        jScrollPane1.setViewportView(jTextArea1);

        javax.swing.GroupLayout layout = new javax.swing.GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(
            layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(javax.swing.GroupLayout.Alignment.TRAILING, layout.createSequentialGroup()
                .addContainerGap()
                .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.TRAILING)
                    .addComponent(jScrollPane1, javax.swing.GroupLayout.DEFAULT_SIZE, 376, Short.MAX_VALUE)
                    .addComponent(jTextField1, javax.swing.GroupLayout.Alignment.LEADING)
                    .addGroup(javax.swing.GroupLayout.Alignment.LEADING, layout.createSequentialGroup()
                        .addComponent(jLabel1)
                        .addGap(0, 0, Short.MAX_VALUE)))
                .addContainerGap())
        );
        layout.setVerticalGroup(
            layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(layout.createSequentialGroup()
                .addContainerGap()
                .addComponent(jLabel1)
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addComponent(jTextField1, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addComponent(jScrollPane1, javax.swing.GroupLayout.DEFAULT_SIZE, 230, Short.MAX_VALUE)
                .addContainerGap())
        );
    }// </editor-fold>//GEN-END:initComponents


    // Variables declaration - do not modify//GEN-BEGIN:variables
    private javax.swing.JLabel jLabel1;
    private javax.swing.JScrollPane jScrollPane1;
    private javax.swing.JTextArea jTextArea1;
    private javax.swing.JTextField jTextField1;
    // End of variables declaration//GEN-END:variables
}
