/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.svggen;

import java.io.IOException;
import java.io.OutputStreamWriter;
import java.io.Writer;
import org.apache.batik.svggen.SVGGraphics2DIOException;
import org.apache.batik.svggen.SVGGraphics2DRuntimeException;
import org.apache.batik.util.SVGConstants;
import org.w3c.dom.Attr;
import org.w3c.dom.CDATASection;
import org.w3c.dom.Comment;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;

class XmlWriter
implements SVGConstants {
    private static String EOL;
    private static final String TAG_END = " />";
    private static final String TAG_START = "</";
    private static final String SPACE = " ";

    XmlWriter() {
    }

    private static void writeXml(Attr attr, IndentWriter out) throws IOException {
        String name = attr.getName();
        out.write(name);
        out.write("=\"");
        XmlWriter.writeChildrenXml(attr, out);
        out.write(34);
    }

    private static void writeChildrenXml(Attr attr, IndentWriter out) throws IOException {
        String value = attr.getValue();
        int i = 0;
        while (i < value.length()) {
            char c = value.charAt(i);
            switch (c) {
                case '<': {
                    out.write("&lt;");
                    break;
                }
                case '>': {
                    out.write("&gt;");
                    break;
                }
                case '&': {
                    out.write("&amp;");
                    break;
                }
                case '\'': {
                    out.write("&apos;");
                    break;
                }
                case '\"': {
                    out.write("&quot;");
                    break;
                }
                default: {
                    out.write(c);
                    break;
                }
            }
            ++i;
        }
    }

    /*
     * Unable to fully structure code
     */
    private static void writeXml(Comment comment, IndentWriter out) throws IOException {
        block4: {
            data = comment.getData().toCharArray();
            out.write("<!--");
            if (data == null) break block4;
            sawDash = false;
            length = data.length;
            i = 0;
            while (i < length) {
                if (data[i] != '-') ** GOTO lbl14
                if (!sawDash) {
                    sawDash = true;
                    out.write(45);
                } else {
                    out.write(32);
lbl14:
                    // 2 sources

                    sawDash = false;
                    out.write(data[i]);
                }
                ++i;
            }
            if (data[data.length - 1] == '-') {
                out.write(32);
            }
        }
        out.write("-->");
    }

    /*
     * Unable to fully structure code
     */
    private static void writeXml(Text text, IndentWriter out) throws IOException {
        data = text.getData().toCharArray();
        start = 0;
        last = 0;
        if (data != null) ** GOTO lbl23
        System.err.println("Null text data??");
        return;
lbl-1000:
        // 1 sources

        {
            c = data[last];
            if (c == '<') {
                out.write(data, start, last - start);
                start = last + 1;
                out.write("&lt;");
            } else if (c == '>') {
                out.write(data, start, last - start);
                start = last + 1;
                out.write("&gt;");
            } else if (c == '&') {
                out.write(data, start, last - start);
                start = last + 1;
                out.write("&amp;");
            }
            ++last;
lbl23:
            // 2 sources

            ** while (last < data.length)
        }
lbl24:
        // 1 sources

        out.write(data, start, last - start);
    }

    private static void writeXml(CDATASection cdataSection, IndentWriter out) throws IOException {
        char[] data = cdataSection.getData().toCharArray();
        out.write("<![CDATA[");
        int i = 0;
        while (i < data.length) {
            char c = data[i];
            if (c == ']' && i + 2 < data.length && data[i + 1] == ']' && data[i + 2] == '>') {
                out.write("]]]]><![CDATA[>");
            } else {
                out.write(c);
            }
            ++i;
        }
        out.write("]]>");
    }

    private static void writeXml(Element element, IndentWriter out) throws IOException, SVGGraphics2DIOException {
        out.write(TAG_START, 0, 1);
        out.write(element.getTagName());
        NamedNodeMap attributes = element.getAttributes();
        if (attributes != null) {
            int nAttr = attributes.getLength();
            int i = 0;
            while (i < nAttr) {
                Attr attr = (Attr)attributes.item(i);
                out.write(32);
                XmlWriter.writeXml(attr, out);
                ++i;
            }
        }
        if (!element.hasChildNodes()) {
            out.write(TAG_END, 0, 3);
        } else {
            out.write(TAG_END, 2, 1);
            XmlWriter.writeChildrenXml(element, out);
            out.write(TAG_START, 0, 2);
            out.write(element.getTagName());
            out.write(TAG_END, 2, 1);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void writeChildrenXml(Element element, IndentWriter out) throws IOException, SVGGraphics2DIOException {
        NodeList children = element.getChildNodes();
        if (children == null) {
            return;
        }
        int length = children.getLength();
        int oldIndent = 0;
        oldIndent = out.getIndentLevel();
        try {
            out.setIndentLevel(oldIndent + 2);
            int i = 0;
            while (i < length) {
                if (children.item(i).getNodeType() != 3) {
                    out.printIndent();
                }
                XmlWriter.writeXml(children.item(i), (Writer)out);
                ++i;
            }
        }
        finally {
            out.setIndentLevel(oldIndent);
            if (length > 0 && children.item(length - 1).getNodeType() != 3) {
                out.printIndent();
            }
        }
    }

    private static void writeDocumentHeader(IndentWriter out) throws IOException {
        String encoding = null;
        if (out.getProxied() instanceof OutputStreamWriter) {
            encoding = XmlWriter.java2std(((OutputStreamWriter)out.getProxied()).getEncoding());
        }
        out.write("<?xml version=\"1.0\"");
        if (encoding != null) {
            out.write(" encoding=\"");
            out.write(encoding);
            out.write(34);
        }
        out.write("?>");
        out.write(EOL);
        out.write(EOL);
        out.write("<!DOCTYPE svg PUBLIC '");
        out.write("-//W3C//DTD SVG 1.0//EN");
        out.write("' '");
        out.write("http://www.w3.org/TR/2001/REC-SVG-20010904/DTD/svg10.dtd");
        out.write("'");
        out.write(">");
        out.write(EOL);
    }

    private static void writeXml(Document document, IndentWriter out) throws IOException, SVGGraphics2DIOException {
        XmlWriter.writeDocumentHeader(out);
        NodeList childList = document.getChildNodes();
        XmlWriter.writeXml(childList, out);
    }

    private static void writeXml(NodeList childList, IndentWriter out) throws IOException, SVGGraphics2DIOException {
        int length = childList.getLength();
        if (length == 0) {
            return;
        }
        int i = 0;
        while (i < length) {
            Node child = childList.item(i);
            XmlWriter.writeXml(child, (Writer)out);
            out.write(EOL);
            ++i;
        }
    }

    static String java2std(String encodingName) {
        if (encodingName == null) {
            return null;
        }
        if (encodingName.startsWith("ISO8859_")) {
            return "ISO-8859-" + encodingName.substring(8);
        }
        if (encodingName.startsWith("8859_")) {
            return "ISO-8859-" + encodingName.substring(5);
        }
        if ("ASCII7".equalsIgnoreCase(encodingName) || "ASCII".equalsIgnoreCase(encodingName)) {
            return "US-ASCII";
        }
        if ("UTF8".equalsIgnoreCase(encodingName)) {
            return "UTF-8";
        }
        if (encodingName.startsWith("Unicode")) {
            return "UTF-16";
        }
        if ("SJIS".equalsIgnoreCase(encodingName)) {
            return "Shift_JIS";
        }
        if ("JIS".equalsIgnoreCase(encodingName)) {
            return "ISO-2022-JP";
        }
        if ("EUCJIS".equalsIgnoreCase(encodingName)) {
            return "EUC-JP";
        }
        return encodingName;
    }

    public static void writeXml(Node node, Writer writer) throws SVGGraphics2DIOException {
        try {
            IndentWriter out = null;
            out = writer instanceof IndentWriter ? (IndentWriter)writer : new IndentWriter(writer);
            switch (node.getNodeType()) {
                case 2: {
                    XmlWriter.writeXml((Attr)node, out);
                    break;
                }
                case 8: {
                    XmlWriter.writeXml((Comment)node, out);
                    break;
                }
                case 3: {
                    XmlWriter.writeXml((Text)node, out);
                    break;
                }
                case 4: {
                    XmlWriter.writeXml((CDATASection)node, out);
                    break;
                }
                case 9: {
                    XmlWriter.writeXml((Document)node, out);
                    break;
                }
                case 11: {
                    XmlWriter.writeDocumentHeader(out);
                    NodeList childList = node.getChildNodes();
                    XmlWriter.writeXml(childList, out);
                    break;
                }
                case 1: {
                    XmlWriter.writeXml((Element)node, out);
                    break;
                }
                default: {
                    throw new SVGGraphics2DRuntimeException("Unable to write node of type " + node.getClass().getName());
                }
            }
        }
        catch (IOException io) {
            throw new SVGGraphics2DIOException(io);
        }
    }

    static {
        String temp;
        try {
            temp = System.getProperty("line.separator", "\n");
        }
        catch (SecurityException e) {
            temp = "\n";
        }
        EOL = temp;
    }

    static class IndentWriter
    extends Writer {
        private Writer proxied;
        private int indentLevel;

        public IndentWriter(Writer proxied) {
            if (proxied == null) {
                throw new SVGGraphics2DRuntimeException("proxy should not be null");
            }
            this.proxied = proxied;
        }

        public void setIndentLevel(int indentLevel) {
            this.indentLevel = indentLevel;
        }

        public int getIndentLevel() {
            return this.indentLevel;
        }

        public void printIndent() throws IOException {
            this.proxied.write(EOL);
            int temp = this.indentLevel;
            while (temp > 0) {
                this.proxied.write(32);
                --temp;
            }
        }

        public Writer getProxied() {
            return this.proxied;
        }

        public void write(int c) throws IOException {
            this.proxied.write(c);
        }

        public void write(char[] cbuf) throws IOException {
            this.proxied.write(cbuf);
        }

        public void write(char[] cbuf, int off, int len) throws IOException {
            this.proxied.write(cbuf, off, len);
        }

        public void write(String str) throws IOException {
            this.proxied.write(str);
        }

        public void write(String str, int off, int len) throws IOException {
            this.proxied.write(str, off, len);
        }

        public void flush() throws IOException {
            this.proxied.flush();
        }

        public void close() throws IOException {
            this.proxied.close();
        }
    }
}

