/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.svggen.font.table;

import java.io.IOException;
import java.io.RandomAccessFile;
import org.apache.batik.svggen.font.table.CmapFormat;
import org.apache.batik.svggen.font.table.CmapIndexEntry;
import org.apache.batik.svggen.font.table.DirectoryEntry;
import org.apache.batik.svggen.font.table.Table;

public class CmapTable
implements Table {
    private int version;
    private int numTables;
    private CmapIndexEntry[] entries;
    private CmapFormat[] formats;

    protected CmapTable(DirectoryEntry de, RandomAccessFile raf) throws IOException {
        raf.seek(de.getOffset());
        long fp = raf.getFilePointer();
        this.version = raf.readUnsignedShort();
        this.numTables = raf.readUnsignedShort();
        this.entries = new CmapIndexEntry[this.numTables];
        this.formats = new CmapFormat[this.numTables];
        int i = 0;
        while (i < this.numTables) {
            this.entries[i] = new CmapIndexEntry(raf);
            ++i;
        }
        int i2 = 0;
        while (i2 < this.numTables) {
            raf.seek(fp + (long)this.entries[i2].getOffset());
            int format = raf.readUnsignedShort();
            this.formats[i2] = CmapFormat.create(format, raf);
            ++i2;
        }
    }

    public CmapFormat getCmapFormat(short platformId, short encodingId) {
        int i = 0;
        while (i < this.numTables) {
            if (this.entries[i].getPlatformId() == platformId && this.entries[i].getEncodingId() == encodingId) {
                return this.formats[i];
            }
            ++i;
        }
        return null;
    }

    public int getType() {
        return 1668112752;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer().append("cmap\n");
        int i = 0;
        while (i < this.numTables) {
            sb.append("\t").append(this.entries[i].toString()).append("\n");
            ++i;
        }
        int i2 = 0;
        while (i2 < this.numTables) {
            sb.append("\t").append(this.formats[i2].toString()).append("\n");
            ++i2;
        }
        return sb.toString();
    }
}

