/*
 * Decompiled with CFR 0.152.
 */
package com.lowagie.text.rtf.table;

import com.lowagie.text.Row;
import com.lowagie.text.Table;
import com.lowagie.text.rtf.RtfElement;
import com.lowagie.text.rtf.document.RtfDocument;
import com.lowagie.text.rtf.table.RtfBorderGroup;
import com.lowagie.text.rtf.table.RtfRow;
import com.lowagie.text.rtf.text.RtfParagraph;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;

public class RtfTable
extends RtfElement {
    private ArrayList rows = null;
    private float tableWidthPercent = 80.0f;
    private float[] proportionalWidths = null;
    private float cellPadding = 0.0f;
    private float cellSpacing = 0.0f;
    private RtfBorderGroup borders = null;
    private int alignment = 1;
    private boolean fitToPage = false;
    private int headerRows = 0;

    public RtfTable(RtfDocument doc, Table table) {
        super(doc);
        table.complete();
        this.importTable(table);
    }

    private void importTable(Table table) {
        this.rows = new ArrayList();
        this.tableWidthPercent = table.widthPercentage();
        this.proportionalWidths = table.getProportionalWidths();
        this.cellPadding = (float)((double)table.cellpadding() * 20.0);
        this.cellSpacing = (float)((double)table.cellspacing() * 20.0);
        this.borders = new RtfBorderGroup(this.document, 1, table.border(), table.borderWidth(), table.borderColor());
        this.alignment = table.alignment();
        int i = 0;
        Iterator rowIterator = table.iterator();
        while (rowIterator.hasNext()) {
            this.rows.add(new RtfRow(this.document, this, (Row)rowIterator.next(), i));
            ++i;
        }
        i = 0;
        while (i < this.rows.size()) {
            ((RtfRow)this.rows.get(i)).handleCellSpanning();
            ++i;
        }
        this.headerRows = table.lastHeaderRow();
    }

    public byte[] write() {
        ByteArrayOutputStream result = new ByteArrayOutputStream();
        try {
            if (!this.inHeader) {
                result.write(RtfParagraph.PARAGRAPH);
            }
            int i = 0;
            while (i < this.rows.size()) {
                result.write(((RtfElement)this.rows.get(i)).write());
                ++i;
            }
            result.write(RtfParagraph.PARAGRAPH_DEFAULTS);
            result.write(RtfParagraph.PARAGRAPH);
            switch (this.alignment) {
                case 0: {
                    result.write(RtfParagraph.ALIGN_LEFT);
                    break;
                }
                case 2: {
                    result.write(RtfParagraph.ALIGN_RIGHT);
                    break;
                }
                case 1: {
                    result.write(RtfParagraph.ALIGN_CENTER);
                    break;
                }
                case 3: 
                case 8: {
                    result.write(RtfParagraph.ALIGN_JUSTIFY);
                }
            }
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
        }
        return result.toByteArray();
    }

    protected int getAlignment() {
        return this.alignment;
    }

    protected RtfBorderGroup getBorders() {
        return this.borders;
    }

    protected float getCellPadding() {
        return this.cellPadding;
    }

    protected float getCellSpacing() {
        return this.cellSpacing;
    }

    protected float[] getProportionalWidths() {
        return (float[])this.proportionalWidths.clone();
    }

    protected float getTableWidthPercent() {
        return this.tableWidthPercent;
    }

    protected ArrayList getRows() {
        return this.rows;
    }

    protected boolean getFitToPage() {
        return this.fitToPage;
    }

    protected int getHeaderRows() {
        return this.headerRows;
    }
}

