/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.pds.objectAccess;

import gov.nasa.arc.pds.xml.generated.FileAreaObservational;
import gov.nasa.pds.objectAccess.ObjectProvider;
import gov.nasa.pds.objectAccess.TableExporter;
import gov.nasa.pds.objectAccess.TableReader;
import gov.nasa.pds.objectAccess.ThreeDImageExporter;
import gov.nasa.pds.objectAccess.ThreeDSpectrumExporter;
import gov.nasa.pds.objectAccess.TwoDImageExporter;
import java.io.File;
import java.net.URL;

public class ExporterFactory {
    private ExporterFactory() {
    }

    public static TwoDImageExporter get2DImageExporter(File label, int fileAreaIndex) throws Exception {
        return ExporterFactory.get2DImageExporter(label.toURI().toURL(), fileAreaIndex);
    }

    public static TwoDImageExporter get2DImageExporter(URL label, int fileAreaIndex) throws Exception {
        return new TwoDImageExporter(label, fileAreaIndex);
    }

    public static ThreeDImageExporter get3DImageExporter(File label, int fileAreaIndex) throws Exception {
        return ExporterFactory.get3DImageExporter(label.toURI().toURL(), fileAreaIndex);
    }

    public static ThreeDImageExporter get3DImageExporter(URL label, int fileAreaIndex) throws Exception {
        return new ThreeDImageExporter(label, fileAreaIndex);
    }

    public static ThreeDSpectrumExporter get3DSpectrumExporter(File label, int fileAreaIndex) throws Exception {
        return ExporterFactory.get3DSpectrumExporter(label.toURI().toURL(), fileAreaIndex);
    }

    public static ThreeDSpectrumExporter get3DSpectrumExporter(URL label, int fileAreaIndex) throws Exception {
        return new ThreeDSpectrumExporter(label, fileAreaIndex);
    }

    public static TableExporter getTableExporter(File label, int fileAreaIndex) throws Exception {
        return ExporterFactory.getTableExporter(label.toURI().toURL(), fileAreaIndex);
    }

    public static TableExporter getTableExporter(URL label, int fileAreaIndex) throws Exception {
        return new TableExporter(label, fileAreaIndex);
    }

    public static TwoDImageExporter get2DImageExporter(FileAreaObservational fileArea, ObjectProvider provider) throws Exception {
        return new TwoDImageExporter(fileArea, provider);
    }

    public static ThreeDImageExporter get3DImageExporter(FileAreaObservational fileArea, ObjectProvider provider) throws Exception {
        return new ThreeDImageExporter(fileArea, provider);
    }

    public static ThreeDSpectrumExporter get3DSpectrumExporter(FileAreaObservational fileArea, ObjectProvider provider) throws Exception {
        return new ThreeDSpectrumExporter(fileArea, provider);
    }

    public static TableExporter getTableExporter(FileAreaObservational fileArea, ObjectProvider provider) throws Exception {
        return new TableExporter(fileArea, provider);
    }

    public static TableReader getTableReader(Object tableObject, File dataFile) throws Exception {
        return ExporterFactory.getTableReader(tableObject, dataFile.toURI().toURL());
    }

    public static TableReader getTableReader(Object tableObject, URL dataFile) throws Exception {
        return new TableReader(tableObject, dataFile, true);
    }
}

