/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.pds.objectAccess.table;

import gov.nasa.pds.objectAccess.table.FieldAdapter;
import java.math.BigInteger;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;

public class DefaultFieldAdapter
implements FieldAdapter {
    private static final String NOT_SUPPORTED = "Operation not supported";
    private static final Charset US_ASCII = Charset.forName("US-ASCII");

    @Override
    public byte getByte(byte[] buf, int offset, int length, int startBit, int stopBit) {
        throw new UnsupportedOperationException(NOT_SUPPORTED);
    }

    @Override
    public short getShort(byte[] buf, int offset, int length, int startBit, int stopBit) {
        throw new UnsupportedOperationException(NOT_SUPPORTED);
    }

    @Override
    public int getInt(byte[] buf, int offset, int length, int startBit, int stopBit) {
        throw new UnsupportedOperationException(NOT_SUPPORTED);
    }

    @Override
    public long getLong(byte[] buf, int offset, int length, int startBit, int stopBit) {
        throw new UnsupportedOperationException(NOT_SUPPORTED);
    }

    @Override
    public float getFloat(byte[] buf, int offset, int length, int startBit, int stopBit) {
        throw new UnsupportedOperationException(NOT_SUPPORTED);
    }

    @Override
    public double getDouble(byte[] buf, int offset, int length, int startBit, int stopBit) {
        throw new UnsupportedOperationException(NOT_SUPPORTED);
    }

    @Override
    public String getString(byte[] buf, int offset, int length, int startBit, int stopBit) {
        return new String(buf, offset, length, US_ASCII);
    }

    @Override
    public String getString(byte[] buf, int offset, int length, int startBit, int stopBit, Charset charset) {
        return new String(buf, offset, length, charset);
    }

    @Override
    public void setByte(byte value, int offset, int length, ByteBuffer buffer, boolean isRightJustified) {
        throw new UnsupportedOperationException(NOT_SUPPORTED);
    }

    @Override
    public void setShort(short value, int offset, int length, ByteBuffer buffer, boolean isRightJustified) {
        throw new UnsupportedOperationException(NOT_SUPPORTED);
    }

    @Override
    public void setInt(int value, int offset, int length, ByteBuffer buffer, boolean isRightJustified) {
        throw new UnsupportedOperationException(NOT_SUPPORTED);
    }

    @Override
    public void setLong(long value, int offset, int length, ByteBuffer buffer, boolean isRightJustified) {
        throw new UnsupportedOperationException(NOT_SUPPORTED);
    }

    @Override
    public void setFloat(float value, int offset, int length, ByteBuffer buffer, boolean isRightJustified) {
        throw new UnsupportedOperationException(NOT_SUPPORTED);
    }

    @Override
    public void setDouble(double value, int offset, int length, ByteBuffer buffer, boolean isRightJustified) {
        throw new UnsupportedOperationException(NOT_SUPPORTED);
    }

    @Override
    public void setString(String value, int offset, int length, ByteBuffer buffer, boolean isRightJustified, Charset charset) {
        if (value.length() > length) {
            throw new IllegalArgumentException("The size of the value is greater than the field length.");
        }
        buffer.position(offset);
        buffer.put(this.getJustifiedValue(value, length, isRightJustified, charset), 0, length);
    }

    @Override
    public void setString(String value, int offset, int length, ByteBuffer buffer, boolean isRightJustified) {
        this.setString(value, offset, length, buffer, isRightJustified, Charset.forName("US-ASCII"));
    }

    public void setString(String value, ByteBuffer buffer, Charset charset) {
        buffer.put(value.getBytes(charset));
    }

    private byte[] getJustifiedValue(String value, int fieldLen, boolean isRightJustified, Charset charset) {
        int i;
        StringBuffer sb = new StringBuffer();
        int padding = fieldLen - value.length();
        if (isRightJustified) {
            for (i = 0; i < padding; ++i) {
                sb.append(' ');
            }
        }
        sb.append(value);
        if (!isRightJustified) {
            for (i = 0; i < padding; ++i) {
                sb.append(' ');
            }
        }
        return sb.toString().getBytes(charset);
    }

    @Override
    public BigInteger getBigInteger(byte[] buf, int offset, int length, int startBit, int stopBit) {
        throw new UnsupportedOperationException(NOT_SUPPORTED);
    }

    @Override
    public void setBigInteger(BigInteger value, int offset, int length, ByteBuffer buffer, boolean isRightJustified) {
        throw new UnsupportedOperationException(NOT_SUPPORTED);
    }
}

