/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.pds.objectAccess.table;

import gov.nasa.arc.pds.xml.generated.FieldCharacter;
import gov.nasa.arc.pds.xml.generated.GroupFieldCharacter;
import gov.nasa.arc.pds.xml.generated.TableCharacter;
import gov.nasa.pds.label.object.FieldDescription;
import gov.nasa.pds.label.object.FieldType;
import gov.nasa.pds.objectAccess.InvalidTableException;
import gov.nasa.pds.objectAccess.table.TableAdapter;
import java.util.ArrayList;
import java.util.List;

public class TableCharacterAdapter
implements TableAdapter {
    TableCharacter table;
    List<FieldDescription> fields;

    public TableCharacterAdapter(TableCharacter table) throws InvalidTableException {
        this.table = table;
        this.fields = new ArrayList<FieldDescription>();
        this.expandFields(table.getRecordCharacter().getFieldCharactersAndGroupFieldCharacters(), 0);
    }

    private void expandFields(List<Object> fields, int baseOffset) throws InvalidTableException {
        for (Object field : fields) {
            if (field instanceof FieldCharacter) {
                this.expandField((FieldCharacter)field, baseOffset);
                continue;
            }
            this.expandGroupField((GroupFieldCharacter)field, baseOffset);
        }
    }

    private void expandField(FieldCharacter field, int baseOffset) {
        FieldDescription desc = new FieldDescription();
        desc.setName(field.getName());
        desc.setType(FieldType.getFieldType(field.getDataType()));
        desc.setOffset(field.getFieldLocation().getValue().intValueExact() - 1 + baseOffset);
        desc.setLength(field.getFieldLength().getValue().intValueExact());
        if (field.getFieldFormat() != null) {
            desc.setFieldFormat(field.getFieldFormat());
        }
        if (field.getValidationFormat() != null) {
            desc.setValidationFormat(field.getValidationFormat());
        }
        if (field.getFieldStatistics() != null) {
            if (field.getFieldStatistics().getMinimum() != null) {
                desc.setMinimum(field.getFieldStatistics().getMinimum());
            }
            if (field.getFieldStatistics().getMaximum() != null) {
                desc.setMaximum(field.getFieldStatistics().getMaximum());
            }
        }
        this.fields.add(desc);
    }

    private void expandGroupField(GroupFieldCharacter group, int outerOffset) throws InvalidTableException {
        int actualGroupLength;
        int baseOffset = outerOffset + group.getGroupLocation().getValue().intValueExact() - 1;
        int groupLength = group.getGroupLength().getValue().intValueExact() / group.getRepetitions().intValueExact();
        if (groupLength < (actualGroupLength = this.getGroupExtent(group))) {
            String msg = "ERROR: GroupFieldCharacter attribute group_length is smaller than size of contained fields: " + groupLength * group.getRepetitions().intValueExact() + "<" + actualGroupLength * group.getRepetitions().intValueExact() + ".";
            groupLength = actualGroupLength;
            throw new InvalidTableException(msg);
        }
        if (groupLength > actualGroupLength) {
            String msg = "ERROR: GroupFieldCharacter attribute group_length is larger than size of contained fields: " + groupLength * group.getRepetitions().intValueExact() + ">" + actualGroupLength * group.getRepetitions().intValueExact() + ".";
            groupLength = actualGroupLength;
            throw new InvalidTableException(msg);
        }
        for (int i = 0; i < group.getRepetitions().intValueExact(); ++i) {
            this.expandFields(group.getFieldCharactersAndGroupFieldCharacters(), baseOffset);
            baseOffset += groupLength;
        }
    }

    private int getGroupExtent(GroupFieldCharacter group) {
        int groupExtent = 0;
        for (Object o : group.getFieldCharactersAndGroupFieldCharacters()) {
            int fieldEnd;
            Object field;
            if (o instanceof GroupFieldCharacter) {
                field = (GroupFieldCharacter)o;
                fieldEnd = ((GroupFieldCharacter)field).getGroupLocation().getValue().intValueExact() + this.getGroupExtent((GroupFieldCharacter)field) - 1;
                groupExtent = Math.max(groupExtent, fieldEnd);
                continue;
            }
            field = (FieldCharacter)o;
            fieldEnd = ((FieldCharacter)field).getFieldLocation().getValue().intValueExact() + ((FieldCharacter)field).getFieldLength().getValue().intValueExact() - 1;
            groupExtent = Math.max(groupExtent, fieldEnd);
        }
        return groupExtent;
    }

    @Override
    public int getRecordCount() {
        return this.table.getRecords().intValueExact();
    }

    @Override
    public int getFieldCount() {
        return this.fields.size();
    }

    @Override
    public FieldDescription getField(int index) {
        return this.fields.get(index);
    }

    @Override
    public FieldDescription[] getFields() {
        return this.fields.toArray(new FieldDescription[this.fields.size()]);
    }

    @Override
    public long getOffset() {
        return this.table.getOffset().getValue().longValueExact();
    }

    @Override
    public int getRecordLength() {
        return this.table.getRecordCharacter().getRecordLength().getValue().intValueExact();
    }
}

