/*
 * Decompiled with CFR 0.152.
 */
package com.drew.metadata.exif;

import com.drew.lang.annotations.NotNull;
import com.drew.lang.annotations.Nullable;
import com.drew.metadata.TagDescriptor;
import com.drew.metadata.exif.CasioType1MakernoteDirectory;

public class CasioType1MakernoteDescriptor
extends TagDescriptor<CasioType1MakernoteDirectory> {
    public CasioType1MakernoteDescriptor(@NotNull CasioType1MakernoteDirectory casioType1MakernoteDirectory) {
        super(casioType1MakernoteDirectory);
    }

    @Override
    @Nullable
    public String getDescription(int n) {
        switch (n) {
            case 1: {
                return this.getRecordingModeDescription();
            }
            case 2: {
                return this.getQualityDescription();
            }
            case 3: {
                return this.getFocusingModeDescription();
            }
            case 4: {
                return this.getFlashModeDescription();
            }
            case 5: {
                return this.getFlashIntensityDescription();
            }
            case 6: {
                return this.getObjectDistanceDescription();
            }
            case 7: {
                return this.getWhiteBalanceDescription();
            }
            case 10: {
                return this.getDigitalZoomDescription();
            }
            case 11: {
                return this.getSharpnessDescription();
            }
            case 12: {
                return this.getContrastDescription();
            }
            case 13: {
                return this.getSaturationDescription();
            }
            case 20: {
                return this.getCcdSensitivityDescription();
            }
        }
        return super.getDescription(n);
    }

    @Nullable
    public String getCcdSensitivityDescription() {
        Integer n = ((CasioType1MakernoteDirectory)this._directory).getInteger(20);
        if (n == null) {
            return null;
        }
        switch (n) {
            case 64: {
                return "Normal";
            }
            case 125: {
                return "+1.0";
            }
            case 250: {
                return "+2.0";
            }
            case 244: {
                return "+3.0";
            }
            case 80: {
                return "Normal (ISO 80 equivalent)";
            }
            case 100: {
                return "High";
            }
        }
        return "Unknown (" + n + ")";
    }

    @Nullable
    public String getSaturationDescription() {
        Integer n = ((CasioType1MakernoteDirectory)this._directory).getInteger(13);
        if (n == null) {
            return null;
        }
        switch (n) {
            case 0: {
                return "Normal";
            }
            case 1: {
                return "Low";
            }
            case 2: {
                return "High";
            }
        }
        return "Unknown (" + n + ")";
    }

    @Nullable
    public String getContrastDescription() {
        Integer n = ((CasioType1MakernoteDirectory)this._directory).getInteger(12);
        if (n == null) {
            return null;
        }
        switch (n) {
            case 0: {
                return "Normal";
            }
            case 1: {
                return "Low";
            }
            case 2: {
                return "High";
            }
        }
        return "Unknown (" + n + ")";
    }

    @Nullable
    public String getSharpnessDescription() {
        Integer n = ((CasioType1MakernoteDirectory)this._directory).getInteger(11);
        if (n == null) {
            return null;
        }
        switch (n) {
            case 0: {
                return "Normal";
            }
            case 1: {
                return "Soft";
            }
            case 2: {
                return "Hard";
            }
        }
        return "Unknown (" + n + ")";
    }

    @Nullable
    public String getDigitalZoomDescription() {
        Integer n = ((CasioType1MakernoteDirectory)this._directory).getInteger(10);
        if (n == null) {
            return null;
        }
        switch (n) {
            case 65536: {
                return "No digital zoom";
            }
            case 65537: {
                return "2x digital zoom";
            }
            case 131072: {
                return "2x digital zoom";
            }
            case 262144: {
                return "4x digital zoom";
            }
        }
        return "Unknown (" + n + ")";
    }

    @Nullable
    public String getWhiteBalanceDescription() {
        Integer n = ((CasioType1MakernoteDirectory)this._directory).getInteger(7);
        if (n == null) {
            return null;
        }
        switch (n) {
            case 1: {
                return "Auto";
            }
            case 2: {
                return "Tungsten";
            }
            case 3: {
                return "Daylight";
            }
            case 4: {
                return "Florescent";
            }
            case 5: {
                return "Shade";
            }
            case 129: {
                return "Manual";
            }
        }
        return "Unknown (" + n + ")";
    }

    @Nullable
    public String getObjectDistanceDescription() {
        Integer n = ((CasioType1MakernoteDirectory)this._directory).getInteger(6);
        if (n == null) {
            return null;
        }
        return n + " mm";
    }

    @Nullable
    public String getFlashIntensityDescription() {
        Integer n = ((CasioType1MakernoteDirectory)this._directory).getInteger(5);
        if (n == null) {
            return null;
        }
        switch (n) {
            case 11: {
                return "Weak";
            }
            case 13: {
                return "Normal";
            }
            case 15: {
                return "Strong";
            }
        }
        return "Unknown (" + n + ")";
    }

    @Nullable
    public String getFlashModeDescription() {
        Integer n = ((CasioType1MakernoteDirectory)this._directory).getInteger(4);
        if (n == null) {
            return null;
        }
        switch (n) {
            case 1: {
                return "Auto";
            }
            case 2: {
                return "On";
            }
            case 3: {
                return "Off";
            }
            case 4: {
                return "Red eye reduction";
            }
        }
        return "Unknown (" + n + ")";
    }

    @Nullable
    public String getFocusingModeDescription() {
        Integer n = ((CasioType1MakernoteDirectory)this._directory).getInteger(3);
        if (n == null) {
            return null;
        }
        switch (n) {
            case 2: {
                return "Macro";
            }
            case 3: {
                return "Auto focus";
            }
            case 4: {
                return "Manual focus";
            }
            case 5: {
                return "Infinity";
            }
        }
        return "Unknown (" + n + ")";
    }

    @Nullable
    public String getQualityDescription() {
        Integer n = ((CasioType1MakernoteDirectory)this._directory).getInteger(2);
        if (n == null) {
            return null;
        }
        switch (n) {
            case 1: {
                return "Economy";
            }
            case 2: {
                return "Normal";
            }
            case 3: {
                return "Fine";
            }
        }
        return "Unknown (" + n + ")";
    }

    @Nullable
    public String getRecordingModeDescription() {
        Integer n = ((CasioType1MakernoteDirectory)this._directory).getInteger(1);
        if (n == null) {
            return null;
        }
        switch (n) {
            case 1: {
                return "Single shutter";
            }
            case 2: {
                return "Panorama";
            }
            case 3: {
                return "Night scene";
            }
            case 4: {
                return "Portrait";
            }
            case 5: {
                return "Landscape";
            }
        }
        return "Unknown (" + n + ")";
    }
}

