
/*
 * CsvDataSourceFormatEditorPanel.java
 *
 * Created on Oct 9, 2024, 6:53 AM
 */

package org.autoplot.csv;

import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JPanel;
import org.das2.util.LoggerManager;
import org.autoplot.datasource.DataSourceFormatEditorPanel;
import org.autoplot.datasource.URISplit;

/**
 * Editor Panel for formatting data.
 * @author jbf
 */
public class CsvDataSourceFormatEditorPanel extends javax.swing.JPanel implements DataSourceFormatEditorPanel {

    private static final Logger logger= LoggerManager.getLogger("apdss");
    String file;

    /** Creates new form AsciiTableDataSourceFormatEditorPanel */
    public CsvDataSourceFormatEditorPanel() {
        initComponents();
    }

    /** This method is called from within the constructor to
     * initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is
     * always regenerated by the Form Editor.
     */
    @SuppressWarnings("unchecked")
    // <editor-fold defaultstate="collapsed" desc="Generated Code">//GEN-BEGIN:initComponents
    private void initComponents() {

        useFormatSpecCB = new javax.swing.JCheckBox();
        explicitFormatSpecPanel = new javax.swing.JPanel();
        jLabel1 = new javax.swing.JLabel();
        numberFormatSpecifierTF = new javax.swing.JTextField();
        timesFormatTF = new javax.swing.JComboBox();
        jLabel2 = new javax.swing.JLabel();
        timeUnitsDropList = new javax.swing.JComboBox();
        timeUnitsCB = new javax.swing.JCheckBox();
        delimiterCheckBox = new javax.swing.JCheckBox();
        delimiterTextField = new javax.swing.JTextField();

        useFormatSpecCB.setText("Explicit Format Specifiers");
        useFormatSpecCB.setToolTipText("Specify the format to for numbers and times.");

        jLabel1.setText("Numbers:");

        numberFormatSpecifierTF.setText("%5.2f");

        timesFormatTF.setModel(new javax.swing.DefaultComboBoxModel(new String[] { "Day", "Minute", "Second", "Millisecond", "Microsecond", "Nanosecond" }));

        jLabel2.setText("Time Resolution:");

        org.jdesktop.layout.GroupLayout explicitFormatSpecPanelLayout = new org.jdesktop.layout.GroupLayout(explicitFormatSpecPanel);
        explicitFormatSpecPanel.setLayout(explicitFormatSpecPanelLayout);
        explicitFormatSpecPanelLayout.setHorizontalGroup(
            explicitFormatSpecPanelLayout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
            .add(explicitFormatSpecPanelLayout.createSequentialGroup()
                .add(explicitFormatSpecPanelLayout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
                    .add(jLabel1)
                    .add(jLabel2))
                .addPreferredGap(org.jdesktop.layout.LayoutStyle.RELATED)
                .add(explicitFormatSpecPanelLayout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
                    .add(numberFormatSpecifierTF, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, 80, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE)
                    .add(timesFormatTF, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE))
                .addContainerGap(144, Short.MAX_VALUE))
        );
        explicitFormatSpecPanelLayout.setVerticalGroup(
            explicitFormatSpecPanelLayout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
            .add(explicitFormatSpecPanelLayout.createSequentialGroup()
                .add(explicitFormatSpecPanelLayout.createParallelGroup(org.jdesktop.layout.GroupLayout.BASELINE)
                    .add(jLabel1)
                    .add(numberFormatSpecifierTF, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE))
                .addPreferredGap(org.jdesktop.layout.LayoutStyle.RELATED)
                .add(explicitFormatSpecPanelLayout.createParallelGroup(org.jdesktop.layout.GroupLayout.BASELINE)
                    .add(jLabel2)
                    .add(timesFormatTF, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE))
                .addContainerGap(org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE))
        );

        timeUnitsDropList.setEditable(true);
        timeUnitsDropList.setModel(new javax.swing.DefaultComboBoxModel(new String[] { "hours since 2015-01-01T00:00", "seconds since 2015-09-22T00:00" }));

        timeUnitsCB.setText("Time Units:");

        delimiterCheckBox.setText("Delimiter:");
        delimiterCheckBox.setToolTipText("The delimiter, or SPACE, NONE, COMMA, SEMICOLON, COLON, TAB");

        delimiterTextField.setText(" ");

        org.jdesktop.layout.GroupLayout layout = new org.jdesktop.layout.GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(
            layout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
            .add(layout.createSequentialGroup()
                .addContainerGap()
                .add(layout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
                    .add(layout.createSequentialGroup()
                        .add(timeUnitsCB)
                        .addPreferredGap(org.jdesktop.layout.LayoutStyle.RELATED)
                        .add(timeUnitsDropList, 0, 365, Short.MAX_VALUE))
                    .add(layout.createSequentialGroup()
                        .add(delimiterCheckBox)
                        .addPreferredGap(org.jdesktop.layout.LayoutStyle.RELATED)
                        .add(delimiterTextField, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, 26, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE))
                    .add(layout.createSequentialGroup()
                        .add(layout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
                            .add(useFormatSpecCB)
                            .add(layout.createSequentialGroup()
                                .add(12, 12, 12)
                                .add(explicitFormatSpecPanel, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE)))
                        .add(0, 0, Short.MAX_VALUE)))
                .addContainerGap())
        );
        layout.setVerticalGroup(
            layout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
            .add(layout.createSequentialGroup()
                .addContainerGap()
                .add(useFormatSpecCB)
                .addPreferredGap(org.jdesktop.layout.LayoutStyle.RELATED)
                .add(explicitFormatSpecPanel, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE)
                .addPreferredGap(org.jdesktop.layout.LayoutStyle.RELATED)
                .add(layout.createParallelGroup(org.jdesktop.layout.GroupLayout.BASELINE)
                    .add(timeUnitsDropList, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE)
                    .add(timeUnitsCB))
                .addPreferredGap(org.jdesktop.layout.LayoutStyle.RELATED)
                .add(layout.createParallelGroup(org.jdesktop.layout.GroupLayout.BASELINE)
                    .add(delimiterCheckBox)
                    .add(delimiterTextField, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE))
                .addContainerGap(140, Short.MAX_VALUE))
        );
    }// </editor-fold>//GEN-END:initComponents


    // Variables declaration - do not modify//GEN-BEGIN:variables
    private javax.swing.JCheckBox delimiterCheckBox;
    private javax.swing.JTextField delimiterTextField;
    private javax.swing.JPanel explicitFormatSpecPanel;
    private javax.swing.JLabel jLabel1;
    private javax.swing.JLabel jLabel2;
    private javax.swing.JTextField numberFormatSpecifierTF;
    private javax.swing.JCheckBox timeUnitsCB;
    private javax.swing.JComboBox timeUnitsDropList;
    private javax.swing.JComboBox timesFormatTF;
    private javax.swing.JCheckBox useFormatSpecCB;
    // End of variables declaration//GEN-END:variables

    @Override
    public JPanel getPanel() {
        return this;
    }

    @Override
    public void setURI(String uri) {
        URISplit split= URISplit.parse(uri);
        file= split.file;
        Map<String,String> args= URISplit.parseParams(split.params);
        String s;
        useFormatSpecCB.setSelected(false);
        s= args.get("format");
        if ( s!=null ) {
            numberFormatSpecifierTF.setText( args.get("format") );
            useFormatSpecCB.setSelected(true);
        }
        s= args.get("tformat");
        if ( s!=null ) {
            timesFormatTF.setSelectedItem(s);
            useFormatSpecCB.setSelected(true);
        }
        s= args.get("depend0Units");
        if ( s!=null ) {
            timeUnitsDropList.setSelectedItem(s);
            timeUnitsCB.setSelected(true);
        }
        s= args.getOrDefault("delim",",");
        delimiterCheckBox.setSelected(!s.equals(","));
        if ( delimiterCheckBox.isSelected() ) {
            delimiterTextField.setText(s);
        } 
    }

    @Override
    public String getURI() {
        String result= file;
        Map<String,String> args= new HashMap();

        if ( useFormatSpecCB.isSelected() ) {
            try {
                args.put("format", URLEncoder.encode(numberFormatSpecifierTF.getText(), "UTF-8"));
            } catch (UnsupportedEncodingException ex) {
                logger.log(Level.SEVERE, ex.getMessage(), ex);
            }
            String ts= String.valueOf( timesFormatTF.getSelectedItem() );
//            if ( includeZ.isSelected() ) {
            args.put( "tformat", ts );
//            } else {
//                args.put( "tformat", ts + "NoZ" );
//            }
        }
        if ( timeUnitsCB.isSelected() ) {
            args.put( "depend0Units",timeUnitsDropList.getSelectedItem().toString() );
        }
        
        if ( delimiterCheckBox.isSelected() ) {
            String s= delimiterTextField.getText();
            if ( s.equals(" ") ) s= "SPACE";
            args.put("delim", s );
        }
        
        String params= URISplit.formatParams(args);
        if ( result==null ) result= "file:///";
        URISplit ss= URISplit.parse(result);

        if ( params.length()>0 ) {
            ss.params= params;
        }
        return URISplit.format( ss );

    }


}
