/*
 * Decompiled with CFR 0.152.
 */
package org.das2.sdi;

import java.util.Optional;
import org.das2.sdi.BinnedData1DImpl;
import org.das2.sdi.BinnedData2DImpl;
import org.das2.sdi.ContiguousBinnedData1DImpl;
import org.das2.sdi.FillDetector2DImpl;
import org.das2.sdi.FillDetectorImpl;
import org.das2.sdi.SimpleBinnedData1DImpl;
import org.das2.sdi.SimpleBinnedData2DImpl;
import org.das2.sdi.SimpleContiguousBinnedData1DImpl;
import org.das2.sdi.SimpleXYDataImpl;
import org.das2.sdi.SimpleXYZDataImpl;
import org.das2.sdi.UncertaintyProvider2DImpl;
import org.das2.sdi.UncertaintyProviderImpl;
import org.das2.sdi.XYDataImpl;
import org.das2.sdi.XYZDataImpl;
import org.virbo.dataset.AbstractRank1DataSet;
import org.virbo.dataset.QDataSet;
import org.virbo.dataset.SemanticOps;
import org.virbo.dataset.WeightsDataSet;
import org.virbo.dsops.Ops;
import sdi.data.BinnedData1D;
import sdi.data.BinnedData2D;
import sdi.data.ContiguousBinnedData1D;
import sdi.data.FillDetector;
import sdi.data.FillDetector2D;
import sdi.data.SimpleBinnedData1D;
import sdi.data.SimpleBinnedData2D;
import sdi.data.SimpleContiguousBinnedData1D;
import sdi.data.SimpleXYData;
import sdi.data.SimpleXYZData;
import sdi.data.UncertaintyProvider;
import sdi.data.UncertaintyProvider2D;
import sdi.data.XYData;
import sdi.data.XYZData;

public class Adapter {
    private Adapter() {
    }

    public static SimpleXYData adaptSimpleXYData(QDataSet x, QDataSet y) {
        return new SimpleXYDataImpl(x, y);
    }

    public static SimpleXYData adaptSimpleXYData(QDataSet ds) {
        return new SimpleXYDataImpl(ds);
    }

    public static XYData adaptXYData(QDataSet x, QDataSet y) {
        return new XYDataImpl(x, y);
    }

    public static XYData adaptXYData(QDataSet ds) {
        return new XYDataImpl(ds);
    }

    public static SimpleXYZData adaptSimpleXYZData(QDataSet x, QDataSet y, QDataSet z) {
        return new SimpleXYZDataImpl(x, y, z);
    }

    public static SimpleXYZData adaptSimpleXYZData(QDataSet ds) {
        return new SimpleXYZDataImpl(ds);
    }

    public static XYZData adaptXYZData(QDataSet x, QDataSet y, QDataSet z) {
        return new XYZDataImpl(x, y, z);
    }

    public static XYZData adaptXYZData(QDataSet ds) {
        return new XYZDataImpl(ds);
    }

    public static SimpleBinnedData1D adaptSimpleBinnedData1D(QDataSet x, QDataSet y) {
        return new SimpleBinnedData1DImpl(x, y);
    }

    public static SimpleBinnedData1D adaptSimpleBinnedData1D(QDataSet ds) {
        return new SimpleBinnedData1DImpl(ds);
    }

    public static BinnedData1D adaptBinnedData1D(QDataSet x, QDataSet y) {
        return new BinnedData1DImpl(x, y);
    }

    public static BinnedData1D adaptBinnedData1D(QDataSet ds) {
        return new BinnedData1DImpl(ds);
    }

    public static SimpleBinnedData2D adaptSimpleBinnedData2D(QDataSet x, QDataSet y, QDataSet z) {
        return new SimpleBinnedData2DImpl(x, y, z);
    }

    public static SimpleBinnedData2D adaptSimpleBinnedData2D(QDataSet ds) {
        return new SimpleBinnedData2DImpl(ds);
    }

    public static BinnedData2D adaptBinnedData2D(QDataSet x, QDataSet y, QDataSet z) {
        return new BinnedData2DImpl(x, y, z);
    }

    public static BinnedData2D adaptBinnedData2D(QDataSet ds) {
        return new BinnedData2DImpl(ds);
    }

    public static SimpleContiguousBinnedData1D adaptSimpleContiguousBinnedData1D(QDataSet xlow, QDataSet xhigh, QDataSet y) {
        return new SimpleContiguousBinnedData1DImpl(xlow, xhigh, y);
    }

    public static SimpleContiguousBinnedData1D adaptSimpleContiguousBinnedData1D(QDataSet ds) {
        return new SimpleContiguousBinnedData1DImpl(ds);
    }

    public static ContiguousBinnedData1D adaptContiguousBinnedData1D(QDataSet xlow, QDataSet xhigh, QDataSet y) {
        return new ContiguousBinnedData1DImpl(xlow, xhigh, y);
    }

    public static ContiguousBinnedData1D adaptContiguousBinnedData1D(QDataSet ds) {
        return new ContiguousBinnedData1DImpl(ds);
    }

    protected static QDataSet getUPAdapter(final QDataSet ds, Optional<UncertaintyProvider> oup, final boolean plus) {
        if (oup.isPresent()) {
            final UncertaintyProvider up = oup.get();
            AbstractRank1DataSet result = new AbstractRank1DataSet(ds.length()){

                public double value(int i) {
                    return plus ? up.getUncertPlus(i) - ds.value(i) : ds.value(i) - up.getUncertMinus(i);
                }
            };
            result.putProperty("UNITS", (Object)SemanticOps.getUnits((QDataSet)ds).getOffsetUnits());
            return result;
        }
        return null;
    }

    protected static QDataSet getWeights(QDataSet ds, Optional<FillDetector> ofd) {
        if (ofd.isPresent()) {
            final FillDetector fd = ofd.get();
            return new AbstractRank1DataSet(ds.length()){

                public double value(int i) {
                    return fd.isFill(i) ? 0.0 : 1.0;
                }
            };
        }
        return null;
    }

    public static Optional<FillDetector> getFillDetector(QDataSet ds) {
        QDataSet wds = SemanticOps.weightsDataSet((QDataSet)ds);
        if (wds instanceof WeightsDataSet.Finite || wds instanceof WeightsDataSet.AllValid) {
            return Optional.empty();
        }
        return Optional.ofNullable(new FillDetectorImpl(ds));
    }

    public static Optional<FillDetector2D> getFillDetector2D(QDataSet ds) {
        QDataSet wds = SemanticOps.weightsDataSet((QDataSet)ds);
        if (wds instanceof WeightsDataSet.Finite || wds instanceof WeightsDataSet.AllValid) {
            return Optional.empty();
        }
        return Optional.ofNullable(new FillDetector2DImpl(ds));
    }

    public static Optional<UncertaintyProvider> getUncertaintyProvider(QDataSet ds) {
        QDataSet dxp = (QDataSet)ds.property("DELTA_PLUS");
        QDataSet dxm = (QDataSet)ds.property("DELTA_MINUS");
        if (dxp != null && dxm != null) {
            return Optional.ofNullable(new UncertaintyProviderImpl(Ops.add((QDataSet)ds, (QDataSet)dxp), Ops.subtract((QDataSet)ds, (QDataSet)dxm)));
        }
        return Optional.empty();
    }

    public static Optional<UncertaintyProvider2D> getUncertaintyProvider2D(QDataSet ds) {
        QDataSet dxp = (QDataSet)ds.property("DELTA_PLUS");
        QDataSet dxm = (QDataSet)ds.property("DELTA_MINUS");
        if (dxp != null && dxm != null) {
            return Optional.ofNullable(new UncertaintyProvider2DImpl(Ops.add((QDataSet)ds, (QDataSet)dxp), Ops.subtract((QDataSet)ds, (QDataSet)dxm)));
        }
        return Optional.empty();
    }
}

