/*
 * Decompiled with CFR 0.152.
 */
package org.das2.sdi;

import org.das2.sdi.BinImpl;
import org.virbo.dataset.DataSetUtil;
import org.virbo.dataset.QDataSet;
import org.virbo.dataset.SemanticOps;
import org.virbo.dsops.Ops;
import sdi.data.Bin;
import sdi.data.SimpleBinnedData1D;

class SimpleBinnedData1DImpl
implements SimpleBinnedData1D {
    QDataSet y;
    QDataSet x;

    public SimpleBinnedData1DImpl(QDataSet x, QDataSet y) {
        this.y = y;
        if (y.rank() != 1) {
            throw new IllegalArgumentException("source y is not rank 1: " + y);
        }
        if (x.rank() != 1) {
            throw new IllegalArgumentException("source x is not rank 1: " + x);
        }
        if ((QDataSet)x.property("BIN_MINUS") == null || (QDataSet)x.property("BIN_PLUS") == null) {
            QDataSet cadence = DataSetUtil.guessCadence((QDataSet)x, null);
            if (cadence != null) {
                cadence = Ops.divide((Object)cadence, (Object)2);
                x = Ops.putProperty((QDataSet)x, (String)"BIN_PLUS", (Object)cadence);
                x = Ops.putProperty((QDataSet)x, (String)"BIN_MINUS", (Object)cadence);
            } else {
                throw new IllegalArgumentException("source x must have BIN_PLUS and BIN_MINUS");
            }
        }
        this.x = x;
    }

    public SimpleBinnedData1DImpl(QDataSet source) {
        this(SemanticOps.xtagsDataSet((QDataSet)source), source);
    }

    public int size() {
        return this.x.length();
    }

    public Bin getXBin(int i) {
        return new BinImpl(this.x, i);
    }

    public double getY(int i) {
        return this.y.value(0);
    }
}

